/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.provider;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.function.Function;

public interface LibraryResolutionProvider<LibraryType> {
    public static int compareVersions(String version1, String version2) {
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 != null && version2 == null) {
            return -1;
        }
        if (version1 == null && version2 != null) {
            return 1;
        }
        String[] string1Vals = version1.split("\\.");
        String[] string2Vals = version2.split("\\.");
        int length = Math.max(string1Vals.length, string2Vals.length);
        for (int i = 0; i < length; ++i) {
            Integer v1 = i < string1Vals.length ? Integer.parseInt(string1Vals[i]) : 0;
            Integer v2 = i < string2Vals.length ? Integer.parseInt(string2Vals[i]) : 0;
            if (v1 > v2) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        }
        return 0;
    }

    public LibraryType resolveLibraryById(String var1, RequestDetails var2);

    public LibraryType resolveLibraryByName(String var1, String var2);

    public LibraryType resolveLibraryByCanonicalUrl(String var1, RequestDetails var2);

    public static <LibraryType> LibraryType selectFromList(Iterable<LibraryType> libraries, String libraryVersion, Function<LibraryType, String> getVersion) {
        LibraryType library = null;
        Object maxVersion = null;
        for (LibraryType l : libraries) {
            String currentVersion = getVersion.apply(l);
            if (libraryVersion != null && currentVersion.equals(libraryVersion) || libraryVersion == null && currentVersion == null) {
                library = l;
            }
            if (maxVersion != null && LibraryResolutionProvider.compareVersions(getVersion.apply(maxVersion), getVersion.apply(l)) >= 0) continue;
            maxVersion = l;
        }
        if (libraryVersion == null && maxVersion != null) {
            return (LibraryType)maxVersion;
        }
        return library;
    }

    public void update(LibraryType var1);
}

