/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.common.retrieve;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.opencds.cqf.cql.engine.fhir.retrieve.SearchParamFhirRetrieveProvider;
import org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JpaFhirRetrieveProvider
extends SearchParamFhirRetrieveProvider {
    private static final Logger logger = LoggerFactory.getLogger(JpaFhirRetrieveProvider.class);
    private final DaoRegistry registry;
    private final RequestDetails myRequestDetails;

    @Autowired
    public JpaFhirRetrieveProvider(DaoRegistry registry, SearchParameterResolver searchParameterResolver, RequestDetails theRequestDetails) {
        super(searchParameterResolver);
        this.registry = registry;
        this.myRequestDetails = theRequestDetails;
    }

    protected Iterable<Object> executeQueries(String dataType, List<org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterMap> queries) {
        if (queries == null || queries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterMap map : queries) {
            objects.addAll(this.executeQuery(dataType, map));
        }
        return objects;
    }

    protected Collection<Object> executeQuery(String dataType, org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterMap map) {
        SearchParameterMap hapiMap = SearchParameterMap.newSynchronous();
        try {
            Method[] methods = hapiMap.getClass().getDeclaredMethods();
            List<Method> methodList = Arrays.asList(methods);
            List puts = methodList.stream().filter(x -> x.getName().equals("put")).collect(Collectors.toList());
            Method method = (Method)puts.get(0);
            method.setAccessible(true);
            for (Map.Entry entry : map.entrySet()) {
                method.invoke((Object)hapiMap, entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            logger.warn("Error converting search parameter map", (Throwable)e);
        }
        IFhirResourceDao dao = this.registry.getResourceDao(dataType);
        IBundleProvider bundleProvider = dao.search(hapiMap, this.myRequestDetails);
        if (bundleProvider.size() == null) {
            return this.resolveResourceList(bundleProvider.getResources(0, 10000));
        }
        List resourceList = bundleProvider.getAllResources();
        return this.resolveResourceList(resourceList);
    }

    public synchronized Collection<Object> resolveResourceList(List<IBaseResource> resourceList) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (IBaseResource res : resourceList) {
            Class<?> clazz = res.getClass();
            ret.add(clazz.cast(res));
        }
        return ret;
    }
}

