/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.config;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.cql.common.provider.CqlProviderFactory;
import ca.uhn.fhir.cql.common.provider.EvaluationProviderFactory;
import ca.uhn.fhir.cql.common.provider.LibraryResolutionProvider;
import ca.uhn.fhir.cql.config.BaseCqlConfig;
import ca.uhn.fhir.cql.r4.evaluation.ProviderFactory;
import ca.uhn.fhir.cql.r4.helper.LibraryHelper;
import ca.uhn.fhir.cql.r4.listener.ElmCacheResourceChangeListener;
import ca.uhn.fhir.cql.r4.provider.JpaTerminologyProvider;
import ca.uhn.fhir.cql.r4.provider.LibraryResolutionProviderImpl;
import ca.uhn.fhir.cql.r4.provider.MeasureOperationsProvider;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import ca.uhn.fhir.jpa.cache.IResourceChangeListenerRegistry;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcR4;
import java.util.Map;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.model.Model;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.r4.model.Library;
import org.opencds.cqf.cql.engine.fhir.model.R4FhirModelResolver;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.evaluator.engine.model.CachingModelResolverDecorator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class CqlR4Config
extends BaseCqlConfig {
    @Override
    @Lazy
    @Bean
    CqlProviderFactory cqlProviderFactory() {
        return new CqlProviderFactory();
    }

    @Lazy
    @Bean
    TerminologyProvider terminologyProvider(ITermReadSvcR4 theITermReadSvc, DaoRegistry theDaoRegistry, IValidationSupport theValidationSupport) {
        return new JpaTerminologyProvider(theITermReadSvc, theDaoRegistry, theValidationSupport);
    }

    @Lazy
    @Bean
    EvaluationProviderFactory evaluationProviderFactory(FhirContext theFhirContext, DaoRegistry theDaoRegistry, TerminologyProvider theLocalSystemTerminologyProvider, ModelResolver modelResolver) {
        return new ProviderFactory(theFhirContext, theDaoRegistry, theLocalSystemTerminologyProvider, modelResolver);
    }

    @Lazy
    @Bean
    LibraryResolutionProvider<Library> libraryResolutionProvider() {
        return new LibraryResolutionProviderImpl();
    }

    @Lazy
    @Bean
    public MeasureOperationsProvider measureOperationsProvider() {
        return new MeasureOperationsProvider();
    }

    @Lazy
    @Bean
    public ModelResolver fhirModelResolver() {
        return new CachingModelResolverDecorator((ModelResolver)new R4FhirModelResolver());
    }

    @Lazy
    @Bean
    public LibraryHelper libraryHelper(Map<VersionedIdentifier, Model> globalModelCache, Map<org.cqframework.cql.elm.execution.VersionedIdentifier, org.cqframework.cql.elm.execution.Library> globalLibraryCache, CqlTranslatorOptions cqlTranslatorOptions) {
        return new LibraryHelper(globalModelCache, globalLibraryCache, cqlTranslatorOptions);
    }

    @Lazy
    @Bean
    public CqlTranslatorOptions cqlTranslatorOptions() {
        return CqlTranslatorOptions.defaultOptions();
    }

    @Bean
    public ElmCacheResourceChangeListener elmCacheResourceChangeListener(IResourceChangeListenerRegistry resourceChangeListenerRegistry, IFhirResourceDao<Library> libraryDao, Map<org.cqframework.cql.elm.execution.VersionedIdentifier, org.cqframework.cql.elm.execution.Library> globalLibraryCache) {
        ElmCacheResourceChangeListener listener = new ElmCacheResourceChangeListener(libraryDao, globalLibraryCache);
        resourceChangeListenerRegistry.registerResourceResourceChangeListener("Library", SearchParameterMap.newSynchronous(), (IResourceChangeListener)listener, 1000L);
        return listener;
    }
}

