/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.dstu3.evaluation;

import ca.uhn.fhir.cql.common.evaluation.MeasurePopulationType;
import ca.uhn.fhir.cql.common.evaluation.MeasureScoring;
import ca.uhn.fhir.cql.dstu3.builder.MeasureReportBuilder;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ReferenceParam;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.cqframework.cql.elm.execution.ExpressionDef;
import org.cqframework.cql.elm.execution.FunctionDef;
import org.cqframework.cql.elm.execution.OperandDef;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureEvaluation {
    private static final Logger logger = LoggerFactory.getLogger(MeasureEvaluation.class);
    private final Interval measurementPeriod;
    private final DaoRegistry registry;

    public MeasureEvaluation(DaoRegistry registry, Interval measurementPeriod) {
        this.registry = registry;
        this.measurementPeriod = measurementPeriod;
    }

    public MeasureReport evaluatePatientMeasure(Measure measure, Context context, String patientId, RequestDetails theRequestDetails) {
        logger.info("Generating individual report");
        if (patientId == null) {
            return this.evaluatePopulationMeasure(measure, context, theRequestDetails);
        }
        Patient patient = (Patient)this.registry.getResourceDao(Patient.class).read((IIdType)new IdType(patientId), theRequestDetails);
        boolean isSingle = true;
        return this.evaluate(measure, context, patient == null ? Collections.emptyList() : Collections.singletonList(patient), MeasureReport.MeasureReportType.INDIVIDUAL, isSingle);
    }

    public MeasureReport evaluatePatientListMeasure(Measure measure, Context context, String practitionerRef, RequestDetails theRequestDetails) {
        logger.info("Generating patient-list report");
        List<Patient> patients = practitionerRef == null ? this.getAllPatients(theRequestDetails) : this.getPractitionerPatients(practitionerRef, theRequestDetails);
        boolean isSingle = false;
        return this.evaluate(measure, context, patients, MeasureReport.MeasureReportType.PATIENTLIST, isSingle);
    }

    private List<Patient> getPractitionerPatients(String practitionerRef, RequestDetails theRequestDetails) {
        SearchParameterMap map = SearchParameterMap.newSynchronous();
        map.add("general-practitioner", (IQueryParameterType)new ReferenceParam((String)(practitionerRef.startsWith("Practitioner/") ? practitionerRef : "Practitioner/" + practitionerRef)));
        ArrayList<Patient> patients = new ArrayList<Patient>();
        IBundleProvider patientProvider = this.registry.getResourceDao("Patient").search(map, theRequestDetails);
        List patientList = patientProvider.getAllResources();
        patientList.forEach(x -> patients.add((Patient)x));
        return patients;
    }

    private List<Patient> getAllPatients(RequestDetails theRequestDetails) {
        ArrayList<Patient> patients = new ArrayList<Patient>();
        IBundleProvider patientProvider = this.registry.getResourceDao("Patient").search(SearchParameterMap.newSynchronous(), theRequestDetails);
        List patientList = patientProvider.getAllResources();
        patientList.forEach(x -> patients.add((Patient)x));
        return patients;
    }

    public MeasureReport evaluatePopulationMeasure(Measure measure, Context context, RequestDetails theRequestDetails) {
        logger.info("Generating summary report");
        boolean isSingle = false;
        return this.evaluate(measure, context, this.getAllPatients(theRequestDetails), MeasureReport.MeasureReportType.SUMMARY, isSingle);
    }

    private void clearExpressionCache(Context context) {
        try {
            Field privateField = Context.class.getDeclaredField("expressions");
            privateField.setAccessible(true);
            LinkedHashMap expressions = (LinkedHashMap)privateField.get(context);
            expressions.clear();
        }
        catch (Exception e) {
            logger.warn("Error resetting expression cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource evaluateObservationCriteria(Context context, Patient patient, Resource resource, Measure.MeasureGroupPopulationComponent pop, MeasureReport report) {
        if (pop == null || !pop.hasCriteria()) {
            return null;
        }
        context.setContextValue("Patient", (Object)patient.getIdElement().getIdPart());
        this.clearExpressionCache(context);
        String observationName = pop.getCriteria();
        ExpressionDef ed = context.resolveExpressionRef(observationName);
        if (!(ed instanceof FunctionDef)) {
            throw new IllegalArgumentException(Msg.code((int)1648) + String.format("Measure observation %s does not reference a function definition", observationName));
        }
        Object result = null;
        context.pushWindow();
        try {
            context.push(new Variable().withName(((OperandDef)((FunctionDef)ed).getOperand().get(0)).getName()).withValue((Object)resource));
            result = ed.getExpression().evaluate(context);
        }
        finally {
            context.popWindow();
        }
        if (result instanceof Resource) {
            return (Resource)result;
        }
        Observation obs = new Observation();
        obs.setStatus(Observation.ObservationStatus.FINAL);
        obs.setId(UUID.randomUUID().toString());
        CodeableConcept cc = new CodeableConcept();
        cc.setText(observationName);
        obs.setCode(cc);
        Extension obsExtension = new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/cqf-measureInfo");
        Extension extExtMeasure = new Extension().setUrl("measure").setValue((Type)new UriType("http://hl7.org/fhir/us/cqfmeasures/" + report.getMeasure()));
        obsExtension.addExtension(extExtMeasure);
        Extension extExtPop = new Extension().setUrl("populationId").setValue((Type)new StringType(observationName));
        obsExtension.addExtension(extExtPop);
        obs.addExtension(obsExtension);
        return obs;
    }

    private Iterable<Resource> evaluateCriteria(Context context, Patient patient, Measure.MeasureGroupPopulationComponent pop) {
        if (pop == null || !pop.hasCriteria()) {
            return Collections.emptyList();
        }
        context.setContextValue("Patient", (Object)patient.getIdElement().getIdPart());
        this.clearExpressionCache(context);
        Object result = context.resolveExpressionRef(pop.getCriteria()).evaluate(context);
        if (result == null) {
            return Collections.emptyList();
        }
        if (result instanceof Boolean) {
            if (((Boolean)result).booleanValue()) {
                return Collections.singletonList(patient);
            }
            return Collections.emptyList();
        }
        return (Iterable)result;
    }

    private boolean evaluatePopulationCriteria(Context context, Patient patient, Measure.MeasureGroupPopulationComponent criteria, HashMap<String, Resource> population, HashMap<String, Patient> populationPatients, Measure.MeasureGroupPopulationComponent exclusionCriteria, HashMap<String, Resource> exclusionPopulation, HashMap<String, Patient> exclusionPatients) {
        boolean inPopulation = false;
        if (criteria != null) {
            for (Resource resource : this.evaluateCriteria(context, patient, criteria)) {
                inPopulation = true;
                population.put(resource.getIdElement().getIdPart(), resource);
            }
        }
        if (inPopulation && exclusionCriteria != null) {
            for (Resource resource : this.evaluateCriteria(context, patient, exclusionCriteria)) {
                inPopulation = false;
                exclusionPopulation.put(resource.getIdElement().getIdPart(), resource);
                population.remove(resource.getIdElement().getIdPart());
            }
        }
        if (inPopulation && populationPatients != null) {
            populationPatients.put(patient.getIdElement().getIdPart(), patient);
        }
        if (!inPopulation && exclusionPatients != null) {
            exclusionPatients.put(patient.getIdElement().getIdPart(), patient);
        }
        return inPopulation;
    }

    private void addPopulationCriteriaReport(MeasureReport report, MeasureReport.MeasureReportGroupComponent reportGroup, Measure.MeasureGroupPopulationComponent populationCriteria, int populationCount, Iterable<Patient> patientPopulation) {
        if (populationCriteria != null) {
            MeasureReport.MeasureReportGroupPopulationComponent populationReport = new MeasureReport.MeasureReportGroupPopulationComponent();
            populationReport.setIdentifier(populationCriteria.getIdentifier());
            populationReport.setCode(populationCriteria.getCode());
            if (report.getType() == MeasureReport.MeasureReportType.PATIENTLIST && patientPopulation != null) {
                ListResource subjectList = new ListResource();
                subjectList.setId(UUID.randomUUID().toString());
                populationReport.setPatients(new Reference().setReference("#" + subjectList.getId()));
                for (Patient patient : patientPopulation) {
                    ListResource.ListEntryComponent entry = new ListResource.ListEntryComponent().setItem(new Reference().setReference(patient.getIdElement().getIdPart().startsWith("Patient/") ? patient.getIdElement().getIdPart() : String.format("Patient/%s", patient.getIdElement().getIdPart())).setDisplay(patient.getNameFirstRep().getNameAsSingleString()));
                    subjectList.addEntry(entry);
                }
                report.addContained((Resource)subjectList);
            }
            populationReport.setCount(populationCount);
            reportGroup.addPopulation(populationReport);
        }
    }

    private MeasureReport evaluate(Measure measure, Context context, List<Patient> patients, MeasureReport.MeasureReportType type, boolean isSingle) {
        MeasureReportBuilder reportBuilder = new MeasureReportBuilder();
        reportBuilder.buildStatus("complete");
        reportBuilder.buildType(type);
        reportBuilder.buildMeasureReference(measure.getIdElement().getValue());
        if (type == MeasureReport.MeasureReportType.INDIVIDUAL && !patients.isEmpty()) {
            reportBuilder.buildPatientReference(patients.get(0).getIdElement().getValue());
        }
        reportBuilder.buildPeriod(this.measurementPeriod);
        MeasureReport report = (MeasureReport)reportBuilder.build();
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        HashMap<String, HashSet<String>> codeToResourceMap = new HashMap<String, HashSet<String>>();
        HashSet evaluatedResourcesList = new HashSet();
        MeasureScoring measureScoring = MeasureScoring.fromCode(measure.getScoring().getCodingFirstRep().getCode());
        if (measureScoring == null) {
            throw new RuntimeException(Msg.code((int)1649) + "Measure scoring is required in order to calculate.");
        }
        List<Object> sde = new ArrayList<Measure.MeasureSupplementalDataComponent>();
        HashMap<String, HashMap<String, Integer>> sdeAccumulators = null;
        for (Measure.MeasureGroupComponent group : measure.getGroup()) {
            MeasureReport.MeasureReportGroupComponent reportGroup = new MeasureReport.MeasureReportGroupComponent();
            reportGroup.setIdentifier(group.getIdentifier());
            report.getGroup().add(reportGroup);
            Measure.MeasureGroupPopulationComponent initialPopulationCriteria = null;
            Measure.MeasureGroupPopulationComponent numeratorCriteria = null;
            Measure.MeasureGroupPopulationComponent numeratorExclusionCriteria = null;
            Measure.MeasureGroupPopulationComponent denominatorCriteria = null;
            Measure.MeasureGroupPopulationComponent denominatorExclusionCriteria = null;
            Measure.MeasureGroupPopulationComponent denominatorExceptionCriteria = null;
            Measure.MeasureGroupPopulationComponent measurePopulationCriteria = null;
            Measure.MeasureGroupPopulationComponent measurePopulationExclusionCriteria = null;
            Measure.MeasureGroupPopulationComponent measureObservationCriteria = null;
            HashMap<String, Resource> initialPopulation = null;
            HashMap<String, Resource> numerator = null;
            HashMap<String, Resource> numeratorExclusion = null;
            HashMap<String, Resource> denominator = null;
            HashMap<String, Resource> denominatorExclusion = null;
            HashMap<String, Resource> denominatorException = null;
            HashMap<String, Resource> measurePopulation = null;
            HashMap<String, Resource> measurePopulationExclusion = null;
            HashMap<String, Resource> measureObservation = null;
            HashMap initialPopulationPatients = null;
            HashMap<String, Patient> numeratorPatients = null;
            HashMap<String, Patient> numeratorExclusionPatients = null;
            HashMap<String, Patient> denominatorPatients = null;
            HashMap<String, Patient> denominatorExclusionPatients = null;
            HashMap<String, Patient> denominatorExceptionPatients = null;
            HashMap<String, Patient> measurePopulationPatients = null;
            HashMap<String, Patient> measurePopulationExclusionPatients = null;
            sdeAccumulators = new HashMap<String, HashMap<String, Integer>>();
            sde = measure.getSupplementalData();
            for (Measure.MeasureGroupPopulationComponent pop : group.getPopulation()) {
                MeasurePopulationType populationType = MeasurePopulationType.fromCode(pop.getCode().getCodingFirstRep().getCode());
                if (populationType == null) continue;
                switch (populationType) {
                    case INITIALPOPULATION: {
                        initialPopulationCriteria = pop;
                        initialPopulation = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        initialPopulationPatients = new HashMap();
                        break;
                    }
                    case NUMERATOR: {
                        numeratorCriteria = pop;
                        numerator = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        numeratorPatients = new HashMap<String, Patient>();
                        break;
                    }
                    case NUMERATOREXCLUSION: {
                        numeratorExclusionCriteria = pop;
                        numeratorExclusion = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        numeratorExclusionPatients = new HashMap<String, Patient>();
                        break;
                    }
                    case DENOMINATOR: {
                        denominatorCriteria = pop;
                        denominator = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        denominatorPatients = new HashMap<String, Patient>();
                        break;
                    }
                    case DENOMINATOREXCLUSION: {
                        denominatorExclusionCriteria = pop;
                        denominatorExclusion = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        denominatorExclusionPatients = new HashMap<String, Patient>();
                        break;
                    }
                    case DENOMINATOREXCEPTION: {
                        denominatorExceptionCriteria = pop;
                        denominatorException = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        denominatorExceptionPatients = new HashMap<String, Patient>();
                        break;
                    }
                    case MEASUREPOPULATION: {
                        measurePopulationCriteria = pop;
                        measurePopulation = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        measurePopulationPatients = new HashMap<String, Patient>();
                        break;
                    }
                    case MEASUREPOPULATIONEXCLUSION: {
                        measurePopulationExclusionCriteria = pop;
                        measurePopulationExclusion = new HashMap<String, Resource>();
                        if (type != MeasureReport.MeasureReportType.PATIENTLIST) break;
                        measurePopulationExclusionPatients = new HashMap<String, Patient>();
                        break;
                    }
                    case MEASUREOBSERVATION: {
                        measureObservationCriteria = pop;
                        measureObservation = new HashMap<String, Resource>();
                    }
                }
            }
            switch (measureScoring) {
                case PROPORTION: 
                case RATIO: {
                    for (Patient patient : patients) {
                        boolean inInitialPopulation = this.evaluatePopulationCriteria(context, patient, initialPopulationCriteria, initialPopulation, initialPopulationPatients, null, null, null);
                        this.populateResourceMap(context, MeasurePopulationType.INITIALPOPULATION, resources, codeToResourceMap);
                        if (inInitialPopulation) {
                            boolean inDenominator = this.evaluatePopulationCriteria(context, patient, denominatorCriteria, denominator, denominatorPatients, denominatorExclusionCriteria, denominatorExclusion, denominatorExclusionPatients);
                            this.populateResourceMap(context, MeasurePopulationType.DENOMINATOR, resources, codeToResourceMap);
                            if (inDenominator) {
                                boolean inNumerator = this.evaluatePopulationCriteria(context, patient, numeratorCriteria, numerator, numeratorPatients, numeratorExclusionCriteria, numeratorExclusion, numeratorExclusionPatients);
                                this.populateResourceMap(context, MeasurePopulationType.NUMERATOR, resources, codeToResourceMap);
                                if (!inNumerator && inDenominator && denominatorExceptionCriteria != null) {
                                    boolean inException = false;
                                    for (Resource resource2 : this.evaluateCriteria(context, patient, denominatorExceptionCriteria)) {
                                        inException = true;
                                        denominatorException.put(resource2.getIdElement().getIdPart(), resource2);
                                        denominator.remove(resource2.getIdElement().getIdPart());
                                        this.populateResourceMap(context, MeasurePopulationType.DENOMINATOREXCEPTION, resources, codeToResourceMap);
                                    }
                                    if (inException) {
                                        if (denominatorExceptionPatients != null) {
                                            denominatorExceptionPatients.put(patient.getIdElement().getIdPart(), patient);
                                        }
                                        if (denominatorPatients != null) {
                                            denominatorPatients.remove(patient.getIdElement().getIdPart());
                                        }
                                    }
                                }
                            }
                        }
                        this.populateSDEAccumulators(measure, context, patient, sdeAccumulators, sde);
                    }
                    if (denominator == null || numerator == null || denominator.size() <= 0) break;
                    reportGroup.setMeasureScore((double)numerator.size() / (double)denominator.size());
                    break;
                }
                case CONTINUOUSVARIABLE: {
                    for (Patient patient : patients) {
                        boolean inMeasurePopulation;
                        boolean inInitialPopulation = this.evaluatePopulationCriteria(context, patient, initialPopulationCriteria, initialPopulation, initialPopulationPatients, null, null, null);
                        this.populateResourceMap(context, MeasurePopulationType.INITIALPOPULATION, resources, codeToResourceMap);
                        if (inInitialPopulation && (inMeasurePopulation = this.evaluatePopulationCriteria(context, patient, measurePopulationCriteria, measurePopulation, measurePopulationPatients, measurePopulationExclusionCriteria, measurePopulationExclusion, measurePopulationExclusionPatients))) {
                            for (Resource resource3 : measurePopulation.values()) {
                                Resource observation = this.evaluateObservationCriteria(context, patient, resource3, measureObservationCriteria, report);
                                measureObservation.put(resource3.getIdElement().getIdPart(), observation);
                                report.addContained(observation);
                            }
                        }
                        this.populateSDEAccumulators(measure, context, patient, sdeAccumulators, sde);
                    }
                    break;
                }
                case COHORT: {
                    for (Patient patient : patients) {
                        this.evaluatePopulationCriteria(context, patient, initialPopulationCriteria, initialPopulation, initialPopulationPatients, null, null, null);
                        this.populateResourceMap(context, MeasurePopulationType.INITIALPOPULATION, resources, codeToResourceMap);
                        this.populateSDEAccumulators(measure, context, patient, sdeAccumulators, sde);
                    }
                    break;
                }
            }
            this.addPopulationCriteriaReport(report, reportGroup, initialPopulationCriteria, initialPopulation != null ? initialPopulation.size() : 0, initialPopulationPatients != null ? initialPopulationPatients.values() : null);
            this.addPopulationCriteriaReport(report, reportGroup, numeratorCriteria, numerator != null ? numerator.size() : 0, numeratorPatients != null ? numeratorPatients.values() : null);
            this.addPopulationCriteriaReport(report, reportGroup, numeratorExclusionCriteria, numeratorExclusion != null ? numeratorExclusion.size() : 0, numeratorExclusionPatients != null ? numeratorExclusionPatients.values() : null);
            this.addPopulationCriteriaReport(report, reportGroup, denominatorCriteria, denominator != null ? denominator.size() : 0, denominatorPatients != null ? denominatorPatients.values() : null);
            this.addPopulationCriteriaReport(report, reportGroup, denominatorExclusionCriteria, denominatorExclusion != null ? denominatorExclusion.size() : 0, denominatorExclusionPatients != null ? denominatorExclusionPatients.values() : null);
            this.addPopulationCriteriaReport(report, reportGroup, denominatorExceptionCriteria, denominatorException != null ? denominatorException.size() : 0, denominatorExceptionPatients != null ? denominatorExceptionPatients.values() : null);
            this.addPopulationCriteriaReport(report, reportGroup, measurePopulationCriteria, measurePopulation != null ? measurePopulation.size() : 0, measurePopulationPatients != null ? measurePopulationPatients.values() : null);
            this.addPopulationCriteriaReport(report, reportGroup, measurePopulationExclusionCriteria, measurePopulationExclusion != null ? measurePopulationExclusion.size() : 0, measurePopulationExclusionPatients != null ? measurePopulationExclusionPatients.values() : null);
        }
        for (String key : codeToResourceMap.keySet()) {
            ListResource list = new ListResource();
            for (String element : (HashSet)codeToResourceMap.get(key)) {
                ListResource.ListEntryComponent comp = new ListResource.ListEntryComponent();
                comp.setItem(new Reference("#" + element));
                list.addEntry(comp);
            }
            if (list.isEmpty()) continue;
            list.setId("List/" + UUID.randomUUID());
            list.setTitle(key);
            resources.put(list.getId(), (Resource)list);
            list.getEntry().forEach(listResource -> evaluatedResourcesList.add(listResource.getItem().getReference()));
        }
        if (!resources.isEmpty()) {
            ArrayList evaluatedResourceIds = new ArrayList();
            evaluatedResourcesList.forEach(resource -> evaluatedResourceIds.add(new Reference(resource)));
        }
        if (sdeAccumulators.size() > 0) {
            report = this.processAccumulators(report, sdeAccumulators, sde, isSingle, patients);
        }
        return report;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void populateSDEAccumulators(Measure measure, Context context, Patient patient, HashMap<String, HashMap<String, Integer>> sdeAccumulators, List<Measure.MeasureSupplementalDataComponent> sde) {
        context.setContextValue("Patient", (Object)patient.getIdElement().getIdPart());
        List sdeList = sde.stream().map(sdeItem -> context.resolveExpressionRef(sdeItem.getCriteria()).evaluate(context)).collect(Collectors.toList());
        if (!sdeList.isEmpty()) {
            block8: for (int i = 0; i < sdeList.size(); ++i) {
                Object sdeListItem = sdeList.get(i);
                if (null == sdeListItem) continue;
                String sdeAccumulatorKey = sde.get(i).getId();
                if (null == sdeAccumulatorKey || sdeAccumulatorKey.length() < 1) {
                    sdeAccumulatorKey = sde.get(i).getCriteria();
                }
                HashMap<String, Integer> sdeItemMap = sdeAccumulators.get(sdeAccumulatorKey);
                String code = "";
                switch (sdeListItem.getClass().getSimpleName()) {
                    case "Code": {
                        code = ((Code)sdeListItem).getCode();
                        break;
                    }
                    case "ArrayList": {
                        if (((ArrayList)sdeListItem).size() <= 0 || !((ArrayList)sdeListItem).get(0).getClass().getSimpleName().equals("Coding")) continue block8;
                        code = ((Coding)((ArrayList)sdeListItem).get(0)).getCode();
                    }
                }
                if (null == code) continue;
                if (null != sdeItemMap && null != sdeItemMap.get(code)) {
                    Integer sdeItemValue;
                    Integer n = sdeItemValue = sdeItemMap.get(code);
                    sdeItemValue = sdeItemValue + 1;
                    sdeItemMap.put(code, sdeItemValue);
                    sdeAccumulators.get(sdeAccumulatorKey).put(code, sdeItemValue);
                    continue;
                }
                if (null == sdeAccumulators.get(sdeAccumulatorKey)) {
                    HashMap<String, Integer> newSDEItem = new HashMap<String, Integer>();
                    newSDEItem.put(code, 1);
                    sdeAccumulators.put(sdeAccumulatorKey, newSDEItem);
                    continue;
                }
                sdeAccumulators.get(sdeAccumulatorKey).put(code, 1);
            }
        }
    }

    private MeasureReport processAccumulators(MeasureReport report, HashMap<String, HashMap<String, Integer>> sdeAccumulators, List<Measure.MeasureSupplementalDataComponent> sde, boolean isSingle, List<Patient> patients) {
        ArrayList newRefList = new ArrayList();
        sdeAccumulators.forEach((sdeKey, sdeAccumulator) -> sdeAccumulator.forEach((sdeAccumulatorKey, sdeAccumulatorValue) -> {
            Observation obs = new Observation();
            obs.setStatus(Observation.ObservationStatus.FINAL);
            obs.setId(UUID.randomUUID().toString());
            Coding valueCoding = new Coding();
            if (sdeKey.equalsIgnoreCase("sde-sex")) {
                valueCoding.setCode(sdeAccumulatorKey);
            } else {
                String coreCategory = sdeKey.substring(sdeKey.lastIndexOf(45) >= 0 ? sdeKey.lastIndexOf(45) : 0);
                patients.forEach(pt -> pt.getExtension().forEach(ptExt -> {
                    String code;
                    if (ptExt.getUrl().contains(coreCategory) && (code = ((Coding)((Extension)ptExt.getExtension().get(0)).getValue()).getCode()).equalsIgnoreCase((String)sdeAccumulatorKey)) {
                        valueCoding.setSystem(((Coding)((Extension)ptExt.getExtension().get(0)).getValue()).getSystem());
                        valueCoding.setCode(code);
                        valueCoding.setDisplay(((Coding)((Extension)ptExt.getExtension().get(0)).getValue()).getDisplay());
                    }
                }));
            }
            CodeableConcept obsCodeableConcept = new CodeableConcept();
            Extension obsExtension = new Extension().setUrl("http://hl7.org/fhir/StructureDefinition/cqf-measureInfo");
            Extension extExtMeasure = new Extension().setUrl("measure").setValue((Type)new StringType("http://hl7.org/fhir/us/cqfmeasures/" + report.getMeasure()));
            obsExtension.addExtension(extExtMeasure);
            Extension extExtPop = new Extension().setUrl("populationId").setValue((Type)new StringType(sdeKey));
            obsExtension.addExtension(extExtPop);
            obs.addExtension(obsExtension);
            obs.setValue((Type)new Quantity((long)sdeAccumulatorValue.intValue()));
            if (!isSingle) {
                valueCoding.setCode(sdeAccumulatorKey);
                obsCodeableConcept.setCoding(Collections.singletonList(valueCoding));
                obs.setCode(obsCodeableConcept);
            } else {
                obs.setCode(new CodeableConcept().setText(sdeKey));
                obsCodeableConcept.setCoding(Collections.singletonList(valueCoding));
                obs.setValue((Type)obsCodeableConcept);
            }
            newRefList.add(new Reference("#" + obs.getId()));
            report.addContained((Resource)obs);
        }));
        return report;
    }

    private void populateResourceMap(Context context, MeasurePopulationType type, HashMap<String, Resource> resources, HashMap<String, HashSet<String>> codeToResourceMap) {
        if (context.getEvaluatedResources().isEmpty()) {
            return;
        }
        if (!codeToResourceMap.containsKey(type.toCode())) {
            codeToResourceMap.put(type.toCode(), new HashSet());
        }
        HashSet<String> codeHashSet = codeToResourceMap.get(type.toCode());
        for (Object o : context.getEvaluatedResources()) {
            if (!(o instanceof Resource)) continue;
            Resource r = (Resource)o;
            String id = (String)(r.getIdElement().getResourceType() != null ? r.getIdElement().getResourceType() + "/" : "") + r.getIdElement().getIdPart();
            codeHashSet.add(id);
            if (resources.containsKey(id)) continue;
            resources.put(id, r);
        }
        context.clearEvaluatedResources();
    }
}

