/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.dstu3.evaluation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.cql.common.provider.EvaluationProviderFactory;
import ca.uhn.fhir.cql.common.retrieve.JpaFhirRetrieveProvider;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import org.opencds.cqf.cql.engine.data.CompositeDataProvider;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterResolver;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.retrieve.RetrieveProvider;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.evaluator.engine.terminology.PrivateCachingTerminologyProviderDecorator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProviderFactory
implements EvaluationProviderFactory {
    private final DaoRegistry registry;
    private final TerminologyProvider defaultTerminologyProvider;
    private final FhirContext fhirContext;
    private final ModelResolver fhirModelResolver;

    @Autowired
    public ProviderFactory(FhirContext fhirContext, DaoRegistry registry, TerminologyProvider defaultTerminologyProvider, ModelResolver fhirModelResolver) {
        this.defaultTerminologyProvider = defaultTerminologyProvider;
        this.registry = registry;
        this.fhirContext = fhirContext;
        this.fhirModelResolver = fhirModelResolver;
    }

    @Override
    public DataProvider createDataProvider(String model, String version, RequestDetails theRequestDetails) {
        return this.createDataProvider(model, version, null, null, null, theRequestDetails);
    }

    @Override
    public DataProvider createDataProvider(String model, String version, String url, String user, String pass, RequestDetails theRequestDetails) {
        TerminologyProvider terminologyProvider = this.createTerminologyProvider(model, version, url, user, pass);
        return this.createDataProvider(model, version, terminologyProvider, theRequestDetails);
    }

    @Override
    public DataProvider createDataProvider(String model, String version, TerminologyProvider terminologyProvider, RequestDetails theRequestDetails) {
        if (model.equals("FHIR") && version.startsWith("3")) {
            JpaFhirRetrieveProvider retrieveProvider = new JpaFhirRetrieveProvider(this.registry, new SearchParameterResolver(this.fhirContext), theRequestDetails);
            retrieveProvider.setTerminologyProvider(terminologyProvider);
            retrieveProvider.setExpandValueSets(true);
            return new CompositeDataProvider(this.fhirModelResolver, (RetrieveProvider)retrieveProvider);
        }
        throw new IllegalArgumentException(Msg.code((int)1650) + String.format("Can't construct a data provider for model %s version %s", model, version));
    }

    @Override
    public TerminologyProvider createTerminologyProvider(String model, String version, String url, String user, String pass) {
        TerminologyProvider terminologyProvider = null;
        terminologyProvider = this.defaultTerminologyProvider;
        return new PrivateCachingTerminologyProviderDecorator(terminologyProvider);
    }
}

