/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.dstu3.helper;

import ca.uhn.fhir.cql.common.provider.LibraryContentProvider;
import ca.uhn.fhir.cql.common.provider.LibraryResolutionProvider;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.Model;
import org.cqframework.cql.elm.execution.Library;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.Resource;
import org.opencds.cqf.cql.engine.execution.LibraryLoader;
import org.opencds.cqf.cql.evaluator.cql2elm.model.CacheAwareModelManager;
import org.opencds.cqf.cql.evaluator.engine.execution.CacheAwareLibraryLoaderDecorator;
import org.opencds.cqf.cql.evaluator.engine.execution.TranslatingLibraryLoader;
import org.opencds.cqf.cql.evaluator.engine.execution.TranslatorOptionAwareLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryHelper {
    private static final Logger ourLog = LoggerFactory.getLogger(LibraryHelper.class);
    private final Map<VersionedIdentifier, Model> modelCache;
    private final Map<org.cqframework.cql.elm.execution.VersionedIdentifier, Library> libraryCache;
    private final CqlTranslatorOptions translatorOptions;

    public LibraryHelper(Map<VersionedIdentifier, Model> modelCache, Map<org.cqframework.cql.elm.execution.VersionedIdentifier, Library> libraryCache, CqlTranslatorOptions translatorOptions) {
        this.modelCache = modelCache;
        this.libraryCache = libraryCache;
        this.translatorOptions = translatorOptions;
    }

    public LibraryLoader createLibraryLoader(LibraryResolutionProvider<org.hl7.fhir.dstu3.model.Library> provider) {
        CacheAwareModelManager modelManager = new CacheAwareModelManager(this.modelCache);
        List<LibraryContentProvider<org.hl7.fhir.dstu3.model.Library, Attachment>> contentProviders = Collections.singletonList(new LibraryContentProvider<org.hl7.fhir.dstu3.model.Library, Attachment>(provider, x -> x.getContent(), x -> x.getContentType(), x -> x.getData()));
        return new CacheAwareLibraryLoaderDecorator((TranslatorOptionAwareLibraryLoader)new TranslatingLibraryLoader((ModelManager)modelManager, contentProviders, this.translatorOptions), this.libraryCache);
    }

    public List<Library> loadLibraries(Measure measure, LibraryLoader libraryLoader, LibraryResolutionProvider<org.hl7.fhir.dstu3.model.Library> libraryResourceProvider, RequestDetails theRequestDetails) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (Reference ref : measure.getLibrary()) {
            org.hl7.fhir.dstu3.model.Library library;
            String id;
            if (ref.getReferenceElement().getIdPart().startsWith("#")) {
                for (Resource resource : measure.getContained()) {
                    if (!(resource instanceof org.hl7.fhir.dstu3.model.Library) || !resource.getIdElement().getIdPart().equals(ref.getReferenceElement().getIdPart().substring(1))) continue;
                    libraryResourceProvider.update((org.hl7.fhir.dstu3.model.Library)resource);
                }
            }
            if ((id = ref.getReferenceElement().getIdPart()).startsWith("#")) {
                id = id.substring(1);
            }
            if ((library = libraryResourceProvider.resolveLibraryById(id, theRequestDetails)) == null) continue;
            if (this.isLogicLibrary(library)) {
                libraries.add(libraryLoader.load(new org.cqframework.cql.elm.execution.VersionedIdentifier().withId(library.getName()).withVersion(library.getVersion())));
                continue;
            }
            String message = "Skipping library " + library.getId() + " is not a logic library.  Probably missing type.coding.system=\"http://hl7.org/fhir/library-type\"";
            messages.add((CallSite)((Object)message));
            ourLog.warn(message);
        }
        if (libraries.isEmpty()) {
            throw new IllegalArgumentException(Msg.code((int)1651) + String.format("Could not load library source for libraries referenced in %s:\n%s", measure.getId(), StringUtils.join((Object[])new Object[]{"\n", messages})));
        }
        org.cqframework.cql.elm.execution.VersionedIdentifier primaryLibraryId = ((Library)libraries.get(0)).getIdentifier();
        org.hl7.fhir.dstu3.model.Library primaryLibrary = libraryResourceProvider.resolveLibraryByName(primaryLibraryId.getId(), primaryLibraryId.getVersion());
        for (RelatedArtifact artifact : primaryLibrary.getRelatedArtifact()) {
            org.hl7.fhir.dstu3.model.Library library;
            if (!artifact.hasType() || !artifact.getType().equals((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON) || !artifact.hasResource() || !artifact.getResource().hasReference() || !artifact.getResource().getReferenceElement().getResourceType().equals("Library") || (library = libraryResourceProvider.resolveLibraryById(artifact.getResource().getReferenceElement().getIdPart(), theRequestDetails)) == null) continue;
            if (this.isLogicLibrary(library)) {
                libraries.add(libraryLoader.load(new org.cqframework.cql.elm.execution.VersionedIdentifier().withId(library.getName()).withVersion(library.getVersion())));
                continue;
            }
            ourLog.warn("Library {} not included as part of evaluation context. Only Libraries with the 'logic-library' type are included.", (Object)library.getId());
        }
        return libraries;
    }

    private boolean isLogicLibrary(org.hl7.fhir.dstu3.model.Library library) {
        if (library == null) {
            return false;
        }
        if (!library.hasType()) {
            if (library.hasContent()) {
                for (Attachment a : library.getContent()) {
                    if (!a.hasContentType() || !a.getContentType().equals("text/cql") && !a.getContentType().equals("application/elm+xml") && !a.getContentType().equals("application/elm+json")) continue;
                    return true;
                }
            }
            return false;
        }
        if (!library.getType().hasCoding()) {
            return false;
        }
        for (Coding c : library.getType().getCoding()) {
            if (!c.hasSystem() || !c.getSystem().equals("http://hl7.org/fhir/library-type") || !c.hasCode() || !c.getCode().equals("logic-library")) continue;
            return true;
        }
        return false;
    }

    public Library resolveLibraryById(String libraryId, LibraryLoader libraryLoader, LibraryResolutionProvider<org.hl7.fhir.dstu3.model.Library> libraryResourceProvider, RequestDetails theRequestDetails) {
        org.hl7.fhir.dstu3.model.Library fhirLibrary = libraryResourceProvider.resolveLibraryById(libraryId, theRequestDetails);
        return libraryLoader.load(new org.cqframework.cql.elm.execution.VersionedIdentifier().withId(fhirLibrary.getName()).withVersion(fhirLibrary.getVersion()));
    }

    public Library resolvePrimaryLibrary(Measure measure, LibraryLoader libraryLoader, LibraryResolutionProvider<org.hl7.fhir.dstu3.model.Library> libraryResourceProvider, RequestDetails theRequestDetails) {
        String id = measure.getLibraryFirstRep().getReferenceElement().getIdPart();
        Library library = this.resolveLibraryById(id, libraryLoader, libraryResourceProvider, theRequestDetails);
        if (library == null) {
            throw new IllegalArgumentException(Msg.code((int)1652) + String.format("Could not resolve primary library for Measure/%s.", measure.getIdElement().getIdPart()));
        }
        return library;
    }
}

