/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.dstu3.provider;

import ca.uhn.fhir.cql.common.provider.LibraryResolutionProvider;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LibraryResolutionProviderImpl
implements LibraryResolutionProvider<Library> {
    @Autowired
    private IFhirResourceDao<Library> myLibraryDao;

    @Override
    public void update(Library library) {
        this.myLibraryDao.update((IBaseResource)library);
    }

    @Override
    public Library resolveLibraryById(String libraryId, RequestDetails theRequestDetails) {
        try {
            return (Library)this.myLibraryDao.read((IIdType)new IdType(libraryId), theRequestDetails);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Msg.code((int)1641) + String.format("Could not resolve library id %s", libraryId));
        }
    }

    @Override
    public Library resolveLibraryByCanonicalUrl(String url, RequestDetails theRequestDetails) {
        IBundleProvider bundleProvider;
        Objects.requireNonNull(url, "url must not be null");
        String[] parts = url.split("\\|");
        String resourceUrl = parts[0];
        String version = null;
        if (parts.length > 1) {
            version = parts[1];
        }
        SearchParameterMap map = SearchParameterMap.newSynchronous();
        map.add("url", (IQueryParameterType)new UriParam(resourceUrl));
        if (version != null) {
            map.add("version", (IQueryParameterType)new TokenParam(version));
        }
        if ((bundleProvider = this.myLibraryDao.search(map, theRequestDetails)).size() == null || bundleProvider.size() == 0) {
            return null;
        }
        List resourceList = bundleProvider.getAllResources();
        return LibraryResolutionProvider.selectFromList(this.resolveLibraries(resourceList), version, x -> x.getVersion());
    }

    @Override
    public Library resolveLibraryByName(String libraryName, String libraryVersion) {
        Iterable<Library> libraries = this.getLibrariesByName(libraryName);
        Library library = LibraryResolutionProvider.selectFromList(libraries, libraryVersion, x -> x.getVersion());
        if (library == null) {
            throw new IllegalArgumentException(Msg.code((int)1642) + String.format("Could not resolve library name %s", libraryName));
        }
        return library;
    }

    private Iterable<Library> getLibrariesByName(String name) {
        SearchParameterMap map = SearchParameterMap.newSynchronous();
        map.add("name", (IQueryParameterType)new StringParam(name, true));
        IBundleProvider bundleProvider = this.myLibraryDao.search(map, (RequestDetails)new SystemRequestDetails());
        if (bundleProvider.size() == null || bundleProvider.size() == 0) {
            return new ArrayList<Library>();
        }
        List resourceList = bundleProvider.getAllResources();
        return this.resolveLibraries(resourceList);
    }

    private Iterable<Library> resolveLibraries(List<IBaseResource> resourceList) {
        ArrayList<Library> ret = new ArrayList<Library>();
        for (IBaseResource res : resourceList) {
            Class<?> clazz = res.getClass();
            ret.add((Library)clazz.cast(res));
        }
        return ret;
    }
}

