/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.dstu3.provider;

import ca.uhn.fhir.cql.common.provider.EvaluationProviderFactory;
import ca.uhn.fhir.cql.common.provider.LibraryResolutionProvider;
import ca.uhn.fhir.cql.dstu3.evaluation.MeasureEvaluation;
import ca.uhn.fhir.cql.dstu3.evaluation.MeasureEvaluationSeed;
import ca.uhn.fhir.cql.dstu3.helper.LibraryHelper;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import org.hl7.fhir.dstu3.model.Extension;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Measure;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.cql.engine.execution.LibraryLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeasureOperationsProvider {
    @Autowired
    private LibraryResolutionProvider<Library> libraryResolutionProvider;
    @Autowired
    private DaoRegistry registry;
    @Autowired
    private IFhirResourceDao<Measure> myMeasureDao;
    @Autowired
    private EvaluationProviderFactory factory;
    @Autowired
    private LibraryHelper libraryHelper;

    @Operation(name="$evaluate-measure", idempotent=true, type=Measure.class)
    public MeasureReport evaluateMeasure(@IdParam IdType theId, @OperationParam(name="periodStart") String periodStart, @OperationParam(name="periodEnd") String periodEnd, @OperationParam(name="measure") String measureRef, @OperationParam(name="reportType") String reportType, @OperationParam(name="patient") String patientRef, @OperationParam(name="productLine") String productLine, @OperationParam(name="practitioner") String practitionerRef, @OperationParam(name="lastReceivedOn") String lastReceivedOn, @OperationParam(name="source") String source, @OperationParam(name="user") String user, @OperationParam(name="pass") String pass, RequestDetails theRequestDetails) throws InternalErrorException, FHIRException {
        LibraryLoader libraryLoader = this.libraryHelper.createLibraryLoader(this.libraryResolutionProvider);
        MeasureEvaluationSeed seed = new MeasureEvaluationSeed(this.factory, libraryLoader, this.libraryResolutionProvider, this.libraryHelper);
        Measure measure = (Measure)this.myMeasureDao.read((IIdType)theId, theRequestDetails);
        if (measure == null) {
            throw new RuntimeException(Msg.code((int)1639) + "Could not find Measure/" + theId.getIdPart());
        }
        seed.setup(measure, periodStart, periodEnd, productLine, source, user, pass, theRequestDetails);
        MeasureEvaluation evaluator = new MeasureEvaluation(this.registry, seed.getMeasurementPeriod());
        if (reportType != null) {
            switch (reportType) {
                case "patient": {
                    return evaluator.evaluatePatientMeasure(seed.getMeasure(), seed.getContext(), patientRef, theRequestDetails);
                }
                case "patient-list": {
                    return evaluator.evaluatePatientListMeasure(seed.getMeasure(), seed.getContext(), practitionerRef, theRequestDetails);
                }
                case "population": {
                    return evaluator.evaluatePopulationMeasure(seed.getMeasure(), seed.getContext(), theRequestDetails);
                }
            }
            throw new IllegalArgumentException(Msg.code((int)1640) + "Invalid report type: " + reportType);
        }
        MeasureReport report = evaluator.evaluatePatientMeasure(seed.getMeasure(), seed.getContext(), patientRef, theRequestDetails);
        if (productLine != null) {
            Extension ext = new Extension();
            ext.setUrl("http://hl7.org/fhir/us/cqframework/cqfmeasures/StructureDefinition/cqfm-productLine");
            ext.setValue((Type)new StringType(productLine));
            report.addExtension(ext);
        }
        return report;
    }
}

