/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.r4.builder;

import ca.uhn.fhir.cql.common.builder.BaseBuilder;
import java.util.Date;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Reference;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureReportBuilder
extends BaseBuilder<MeasureReport> {
    private static final Logger ourLog = LoggerFactory.getLogger(ca.uhn.fhir.cql.dstu3.builder.MeasureReportBuilder.class);

    public MeasureReportBuilder() {
        super(new MeasureReport());
    }

    public MeasureReportBuilder buildStatus(String status) {
        try {
            ((MeasureReport)this.complexProperty).setStatus(MeasureReport.MeasureReportStatus.fromCode((String)status));
        }
        catch (FHIRException e) {
            ourLog.warn("Exception caught while attempting to set Status to '" + status + "', assuming status COMPLETE!" + System.lineSeparator() + e.getMessage());
            ((MeasureReport)this.complexProperty).setStatus(MeasureReport.MeasureReportStatus.COMPLETE);
        }
        return this;
    }

    public MeasureReportBuilder buildType(MeasureReport.MeasureReportType type) {
        ((MeasureReport)this.complexProperty).setType(type);
        return this;
    }

    public MeasureReportBuilder buildType(String type) {
        ((MeasureReport)this.complexProperty).setType(MeasureReport.MeasureReportType.fromCode((String)type));
        return this;
    }

    public MeasureReportBuilder buildMeasureReference(String measureRef) {
        ((MeasureReport)this.complexProperty).setMeasure(measureRef);
        return this;
    }

    public MeasureReportBuilder buildPatientReference(String patientRef) {
        ((MeasureReport)this.complexProperty).setSubject(new Reference(patientRef));
        return this;
    }

    public MeasureReportBuilder buildPeriod(Interval period) {
        Object start = period.getStart();
        if (start instanceof DateTime) {
            ((MeasureReport)this.complexProperty).setPeriod(new Period().setStart(Date.from(((DateTime)start).getDateTime().toInstant())).setEnd(Date.from(((DateTime)period.getEnd()).getDateTime().toInstant())));
        } else if (start instanceof Date) {
            ((MeasureReport)this.complexProperty).setPeriod(new Period().setStart((Date)period.getStart()).setEnd((Date)period.getEnd()));
        }
        return this;
    }
}

