/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.r4.evaluation;

import ca.uhn.fhir.cql.common.helper.DateHelper;
import ca.uhn.fhir.cql.common.helper.UsingHelper;
import ca.uhn.fhir.cql.common.provider.EvaluationProviderFactory;
import ca.uhn.fhir.cql.common.provider.LibraryResolutionProvider;
import ca.uhn.fhir.cql.r4.helper.LibraryHelper;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Triple;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.opencds.cqf.cql.engine.data.DataProvider;
import org.opencds.cqf.cql.engine.debug.DebugMap;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.LibraryLoader;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;

public class MeasureEvaluationSeed {
    private Measure measure;
    private Context context;
    private Interval measurementPeriod;
    private final LibraryLoader libraryLoader;
    private final LibraryResolutionProvider<Library> libraryResourceProvider;
    private final EvaluationProviderFactory providerFactory;
    private DataProvider dataProvider;
    private final LibraryHelper libraryHelper;

    public MeasureEvaluationSeed(EvaluationProviderFactory providerFactory, LibraryLoader libraryLoader, LibraryResolutionProvider<Library> libraryResourceProvider, LibraryHelper libraryHelper) {
        this.providerFactory = providerFactory;
        this.libraryLoader = libraryLoader;
        this.libraryResourceProvider = libraryResourceProvider;
        this.libraryHelper = libraryHelper;
    }

    public Measure getMeasure() {
        return this.measure;
    }

    public Context getContext() {
        return this.context;
    }

    public Interval getMeasurementPeriod() {
        return this.measurementPeriod;
    }

    public DataProvider getDataProvider() {
        return this.dataProvider;
    }

    public void setup(Measure measure, String periodStart, String periodEnd, String productLine, String source, String user, String pass, RequestDetails theRequestDetails) {
        this.measure = measure;
        this.libraryHelper.loadLibraries(measure, this.libraryLoader, this.libraryResourceProvider, theRequestDetails);
        org.cqframework.cql.elm.execution.Library library = this.libraryHelper.resolvePrimaryLibrary(measure, this.libraryLoader, this.libraryResourceProvider, theRequestDetails);
        this.context = new Context(library);
        this.context.registerLibraryLoader(this.libraryLoader);
        List<Triple<String, String, String>> usingDefs = UsingHelper.getUsingUrlAndVersion(library.getUsings());
        if (usingDefs.size() > 1) {
            throw new IllegalArgumentException(Msg.code((int)1671) + "Evaluation of Measure using multiple Models is not supported at this time.");
        }
        TerminologyProvider terminologyProvider = null;
        if (usingDefs.size() > 0) {
            terminologyProvider = this.providerFactory.createTerminologyProvider((String)usingDefs.get(0).getLeft(), (String)usingDefs.get(0).getMiddle(), source, user, pass);
            this.context.registerTerminologyProvider(terminologyProvider);
        }
        for (Triple<String, String, String> def : usingDefs) {
            this.dataProvider = this.providerFactory.createDataProvider((String)def.getLeft(), (String)def.getMiddle(), terminologyProvider, theRequestDetails);
            this.context.registerDataProvider((String)def.getRight(), this.dataProvider);
        }
        if (periodStart != null && periodEnd != null) {
            this.measurementPeriod = new Interval((Object)DateHelper.resolveRequestDate("periodStart", periodStart), true, (Object)DateHelper.resolveRequestDate("periodEnd", periodEnd), true);
            this.context.setParameter(null, "Measurement Period", (Object)new Interval((Object)DateTime.fromJavaDate((Date)((Date)this.measurementPeriod.getStart())), true, (Object)DateTime.fromJavaDate((Date)((Date)this.measurementPeriod.getEnd())), true));
        }
        if (productLine != null) {
            this.context.setParameter(null, "Product Line", (Object)productLine);
        }
        this.context.setExpressionCaching(true);
        DebugMap debugMap = new DebugMap();
        debugMap.setIsLoggingEnabled(true);
        this.context.setDebugMap(debugMap);
    }
}

