/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.r4.helper;

import ca.uhn.fhir.cql.common.provider.LibraryContentProvider;
import ca.uhn.fhir.cql.common.provider.LibraryResolutionProvider;
import ca.uhn.fhir.cql.r4.helper.CanonicalHelper;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.cql2elm.CqlTranslatorOptions;
import org.cqframework.cql.cql2elm.LibraryManager;
import org.cqframework.cql.cql2elm.LibrarySourceProvider;
import org.cqframework.cql.cql2elm.ModelManager;
import org.cqframework.cql.cql2elm.model.Model;
import org.hl7.elm.r1.VersionedIdentifier;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.cql.engine.execution.LibraryLoader;
import org.opencds.cqf.cql.evaluator.cql2elm.model.CacheAwareModelManager;
import org.opencds.cqf.cql.evaluator.engine.execution.CacheAwareLibraryLoaderDecorator;
import org.opencds.cqf.cql.evaluator.engine.execution.TranslatingLibraryLoader;
import org.opencds.cqf.cql.evaluator.engine.execution.TranslatorOptionAwareLibraryLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryHelper {
    private static final Logger ourLog = LoggerFactory.getLogger(LibraryHelper.class);
    private final Map<VersionedIdentifier, Model> modelCache;
    private final Map<org.cqframework.cql.elm.execution.VersionedIdentifier, org.cqframework.cql.elm.execution.Library> libraryCache;
    private final CqlTranslatorOptions translatorOptions;

    public LibraryHelper(Map<VersionedIdentifier, Model> modelCache, Map<org.cqframework.cql.elm.execution.VersionedIdentifier, org.cqframework.cql.elm.execution.Library> libraryCache, CqlTranslatorOptions translatorOptions) {
        this.modelCache = modelCache;
        this.libraryCache = libraryCache;
        this.translatorOptions = translatorOptions;
    }

    public LibraryLoader createLibraryLoader(LibraryResolutionProvider<Library> provider) {
        CacheAwareModelManager modelManager = new CacheAwareModelManager(this.modelCache);
        LibraryManager libraryManager = new LibraryManager((ModelManager)modelManager);
        libraryManager.getLibrarySourceLoader().clearProviders();
        List<LibraryContentProvider<Library, Attachment>> contentProviders = Collections.singletonList(new LibraryContentProvider<Library, Attachment>(provider, x -> x.getContent(), x -> x.getContentType(), x -> x.getData()));
        return new CacheAwareLibraryLoaderDecorator((TranslatorOptionAwareLibraryLoader)new TranslatingLibraryLoader((ModelManager)modelManager, contentProviders, this.translatorOptions), this.libraryCache);
    }

    public LibraryLoader createLibraryLoader(LibrarySourceProvider provider) {
        CacheAwareModelManager modelManager = new CacheAwareModelManager(this.modelCache);
        LibraryManager libraryManager = new LibraryManager((ModelManager)modelManager);
        libraryManager.getLibrarySourceLoader().clearProviders();
        libraryManager.getLibrarySourceLoader().registerProvider(provider);
        return new CacheAwareLibraryLoaderDecorator((TranslatorOptionAwareLibraryLoader)new TranslatingLibraryLoader((ModelManager)modelManager, null, this.translatorOptions), this.libraryCache);
    }

    public Library resolveLibraryReference(LibraryResolutionProvider<Library> libraryResourceProvider, String reference, RequestDetails theRequestDetails) {
        if (reference.startsWith("Library/") || !reference.contains("/")) {
            return libraryResourceProvider.resolveLibraryById(reference.replace("Library/", ""), theRequestDetails);
        }
        if (reference.contains("/Library/")) {
            return libraryResourceProvider.resolveLibraryByCanonicalUrl(reference, theRequestDetails);
        }
        return null;
    }

    public List<org.cqframework.cql.elm.execution.Library> loadLibraries(Measure measure, LibraryLoader libraryLoader, LibraryResolutionProvider<Library> libraryResourceProvider, RequestDetails theRequestDetails) {
        ArrayList<org.cqframework.cql.elm.execution.Library> libraries = new ArrayList<org.cqframework.cql.elm.execution.Library>();
        Library primaryLibrary = null;
        for (CanonicalType ref : measure.getLibrary()) {
            String id = (String)ref.getValue();
            if (id.startsWith("#")) {
                id = id.substring(1);
                for (Resource resource : measure.getContained()) {
                    if (!(resource instanceof Library) || !resource.getIdElement().getIdPart().equals(id)) continue;
                    libraryResourceProvider.update((Library)resource);
                }
            }
            Library library = this.resolveLibraryReference(libraryResourceProvider, id, theRequestDetails);
            if (primaryLibrary == null) {
                primaryLibrary = library;
            }
            if (library == null || !this.isLogicLibrary(library)) continue;
            libraries.add(libraryLoader.load(new org.cqframework.cql.elm.execution.VersionedIdentifier().withId(library.getName()).withVersion(library.getVersion())));
        }
        if (libraries.isEmpty()) {
            throw new IllegalArgumentException(Msg.code((int)1677) + String.format("Could not load library source for libraries referenced in %s.", measure.getId()));
        }
        for (RelatedArtifact artifact : primaryLibrary.getRelatedArtifact()) {
            if (!artifact.hasType() || !artifact.getType().equals((Object)RelatedArtifact.RelatedArtifactType.DEPENDSON) || !artifact.hasResource()) continue;
            Library library = null;
            library = this.resolveLibraryReference(libraryResourceProvider, artifact.getResource(), theRequestDetails);
            if (library == null) continue;
            if (this.isLogicLibrary(library)) {
                libraries.add(libraryLoader.load(new org.cqframework.cql.elm.execution.VersionedIdentifier().withId(library.getName()).withVersion(library.getVersion())));
                continue;
            }
            ourLog.warn("Library {} not included as part of evaluation context. Only Libraries with the 'logic-library' type are included.", (Object)library.getId());
        }
        return libraries;
    }

    private boolean isLogicLibrary(Library library) {
        if (library == null) {
            return false;
        }
        if (!library.hasType()) {
            if (library.hasContent()) {
                for (Attachment a : library.getContent()) {
                    if (!a.hasContentType() || !a.getContentType().equals("text/cql") && !a.getContentType().equals("application/elm+xml") && !a.getContentType().equals("application/elm+json")) continue;
                    return true;
                }
            }
            return false;
        }
        if (!library.getType().hasCoding()) {
            return false;
        }
        for (Coding c : library.getType().getCoding()) {
            if (!c.hasSystem() || !c.getSystem().equals("http://terminology.hl7.org/CodeSystem/library-type") || !c.hasCode() || !c.getCode().equals("logic-library")) continue;
            return true;
        }
        return false;
    }

    public org.cqframework.cql.elm.execution.Library resolveLibraryById(String libraryId, LibraryLoader libraryLoader, LibraryResolutionProvider<Library> libraryResourceProvider, RequestDetails theRequestDetails) {
        Library fhirLibrary = libraryResourceProvider.resolveLibraryById(libraryId, theRequestDetails);
        return libraryLoader.load(new org.cqframework.cql.elm.execution.VersionedIdentifier().withId(fhirLibrary.getName()).withVersion(fhirLibrary.getVersion()));
    }

    public org.cqframework.cql.elm.execution.Library resolvePrimaryLibrary(Measure measure, LibraryLoader libraryLoader, LibraryResolutionProvider<Library> libraryResourceProvider, RequestDetails theRequestDetails) {
        String id = CanonicalHelper.getId((CanonicalType)measure.getLibrary().get(0));
        org.cqframework.cql.elm.execution.Library library = this.resolveLibraryById(id, libraryLoader, libraryResourceProvider, theRequestDetails);
        if (library == null) {
            throw new IllegalArgumentException(Msg.code((int)1678) + String.format("Could not resolve primary library for Measure/%s.", measure.getIdElement().getIdPart()));
        }
        return library;
    }

    public org.cqframework.cql.elm.execution.Library resolvePrimaryLibrary(PlanDefinition planDefinition, LibraryLoader libraryLoader, LibraryResolutionProvider<Library> libraryResourceProvider, RequestDetails theRequestDetails) {
        String id = CanonicalHelper.getId((CanonicalType)planDefinition.getLibrary().get(0));
        org.cqframework.cql.elm.execution.Library library = this.resolveLibraryById(id, libraryLoader, libraryResourceProvider, theRequestDetails);
        if (library == null) {
            throw new IllegalArgumentException(Msg.code((int)1679) + String.format("Could not resolve primary library for PlanDefinition/%s", planDefinition.getIdElement().getIdPart()));
        }
        return library;
    }
}

