/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.r4.listener;

import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.cache.IResourceChangeEvent;
import ca.uhn.fhir.jpa.cache.IResourceChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.cqframework.cql.elm.execution.VersionedIdentifier;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.Library;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElmCacheResourceChangeListener
implements IResourceChangeListener {
    private static final Logger ourLog = LoggerFactory.getLogger(ElmCacheResourceChangeListener.class);
    private IFhirResourceDao<Library> libraryDao;
    private Map<VersionedIdentifier, org.cqframework.cql.elm.execution.Library> globalLibraryCache;

    public ElmCacheResourceChangeListener(IFhirResourceDao<Library> libraryDao, Map<VersionedIdentifier, org.cqframework.cql.elm.execution.Library> globalLibraryCache) {
        this.libraryDao = libraryDao;
        this.globalLibraryCache = globalLibraryCache;
    }

    public void handleInit(Collection<IIdType> theResourceIds) {
    }

    public void handleChange(IResourceChangeEvent theResourceChangeEvent) {
        if (theResourceChangeEvent == null) {
            return;
        }
        this.invalidateCacheByIds(theResourceChangeEvent.getDeletedResourceIds());
        this.invalidateCacheByIds(theResourceChangeEvent.getUpdatedResourceIds());
    }

    private void invalidateCacheByIds(List<IIdType> theIds) {
        if (theIds == null) {
            return;
        }
        for (IIdType id : theIds) {
            this.invalidateCacheById(id);
        }
    }

    private void invalidateCacheById(IIdType theId) {
        if (!theId.getResourceType().equals("Library")) {
            return;
        }
        try {
            Library library = (Library)this.libraryDao.read(theId);
            this.globalLibraryCache.remove(new VersionedIdentifier().withId(library.getName()).withVersion(library.getVersion()));
        }
        catch (Exception e) {
            ourLog.debug("Failed to locate resource {} to look up name and version. Clearing all libraries from cache.", (Object)theId.getValueAsString());
            this.globalLibraryCache.clear();
        }
    }
}

