/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.cql.r4.provider;

import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import ca.uhn.fhir.context.support.ValueSetExpansionOptions;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.jpa.term.api.ITermReadSvcR4;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.param.UriParam;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JpaTerminologyProvider
implements TerminologyProvider {
    private final ITermReadSvcR4 myTerminologySvc;
    private final DaoRegistry myDaoRegistry;
    private final IValidationSupport myValidationSupport;
    private IFhirResourceDao<ValueSet> myValueSetDao;

    @Autowired
    public JpaTerminologyProvider(ITermReadSvcR4 theTerminologySvc, DaoRegistry theDaoRegistry, IValidationSupport theValidationSupport) {
        this.myTerminologySvc = theTerminologySvc;
        this.myDaoRegistry = theDaoRegistry;
        this.myValidationSupport = theValidationSupport;
    }

    @PostConstruct
    public void init() {
        this.myValueSetDao = this.myDaoRegistry.getResourceDao(ValueSet.class);
    }

    public boolean in(Code code, ValueSetInfo valueSet) throws ResourceNotFoundException {
        for (Code c : this.expand(valueSet)) {
            if (c == null || !c.getCode().equals(code.getCode()) || !c.getSystem().equals(code.getSystem())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Iterable<Code> expand(ValueSetInfo valueSet) throws ResourceNotFoundException {
        ValueSet vs;
        if (valueSet.getId().startsWith("http://") || valueSet.getId().startsWith("https://")) {
            if ((valueSet.getVersion() != null || valueSet.getCodeSystems() != null && valueSet.getCodeSystems().size() > 0) && (valueSet.getCodeSystems().size() != 1 || ((CodeSystemInfo)valueSet.getCodeSystems().get(0)).getVersion() != null)) {
                throw new UnsupportedOperationException(Msg.code((int)1667) + String.format("Could not expand value set %s; version and code system bindings are not supported at this time.", valueSet.getId()));
            }
            IBundleProvider bundleProvider = this.myValueSetDao.search(SearchParameterMap.newSynchronous().add("url", (IQueryParameterType)new UriParam(valueSet.getId())));
            List valueSets = bundleProvider.getAllResources();
            if (valueSets.isEmpty()) {
                throw new IllegalArgumentException(Msg.code((int)1668) + String.format("Could not resolve value set %s.", valueSet.getId()));
            }
            if (valueSets.size() != 1) throw new IllegalArgumentException(Msg.code((int)1669) + "Found more than 1 ValueSet with url: " + valueSet.getId());
            vs = (ValueSet)valueSets.get(0);
        } else {
            vs = (ValueSet)this.myValueSetDao.read((IIdType)new IdType(valueSet.getId()));
            if (vs == null) {
                throw new IllegalArgumentException(Msg.code((int)1670) + String.format("Could not resolve value set %s.", valueSet.getId()));
            }
        }
        if (!vs.hasExpansion() || !vs.getExpansion().hasContains()) {
            vs = this.myTerminologySvc.expandValueSet(new ValueSetExpansionOptions().setCount(Integer.MAX_VALUE).setFailOnMissingCodeSystem(false), vs);
        }
        ArrayList<Code> codes = new ArrayList<Code>();
        if (vs.hasExpansion() && vs.getExpansion().hasContains()) {
            for (ValueSet.ValueSetExpansionContainsComponent vsecc : vs.getExpansion().getContains()) {
                codes.add(new Code().withCode(vsecc.getCode()).withSystem(vsecc.getSystem()));
            }
            return codes;
        } else {
            if (!vs.hasCompose() || !vs.getCompose().hasInclude()) return codes;
            for (ValueSet.ConceptSetComponent include : vs.getCompose().getInclude()) {
                for (ValueSet.ConceptReferenceComponent concept : include.getConcept()) {
                    if (!concept.hasCode()) continue;
                    codes.add(new Code().withCode(concept.getCode()).withSystem(include.getSystem()));
                }
            }
        }
        return codes;
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) throws ResourceNotFoundException {
        IValidationSupport.LookupCodeResult cs = this.myTerminologySvc.lookupCode(new ValidationSupportContext(this.myValidationSupport), codeSystem.getId(), code.getCode());
        code.setDisplay(cs.getCodeDisplay());
        code.setSystem(codeSystem.getId());
        return code;
    }
}

