/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public abstract class RequestDetails {
    private final StopWatch myRequestStopwatch = new StopWatch();
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    private String myTenantId;
    private String myCompartmentName;
    private String myCompleteUrl;
    private String myFhirServerBase;
    private IIdType myId;
    private String myOperation;
    private Map<String, String[]> myParameters;
    private byte[] myRequestContents;
    private DeferredOperationCallback myDeferredInterceptorBroadcaster;
    private String myRequestPath;
    private RequestTypeEnum myRequestType;
    private String myResourceName;
    private boolean myRespondGzip;
    private IRestfulResponse myResponse;
    private RestOperationTypeEnum myRestOperationType;
    private String mySecondaryOperation;
    private boolean mySubRequest;
    private Map<String, List<String>> myUnqualifiedToQualifiedNames;
    private Map<Object, Object> myUserData;
    private IBaseResource myResource;
    private String myRequestId;
    private String myFixedConditionalUrl;

    public RequestDetails(IInterceptorBroadcaster theInterceptorBroadcaster) {
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
    }

    public String getFixedConditionalUrl() {
        return this.myFixedConditionalUrl;
    }

    public void setFixedConditionalUrl(String theFixedConditionalUrl) {
        this.myFixedConditionalUrl = theFixedConditionalUrl;
    }

    public String getRequestId() {
        return this.myRequestId;
    }

    public void setRequestId(String theRequestId) {
        this.myRequestId = theRequestId;
    }

    public StopWatch getRequestStopwatch() {
        return this.myRequestStopwatch;
    }

    public IBaseResource getResource() {
        return this.myResource;
    }

    public void setResource(IBaseResource theResource) {
        this.myResource = theResource;
    }

    public void addParameter(String theName, String[] theValues) {
        this.getParameters();
        this.myParameters.put(theName, theValues);
    }

    protected abstract byte[] getByteStreamRequestContents();

    public abstract Charset getCharset();

    public String getCompartmentName() {
        return this.myCompartmentName;
    }

    public void setCompartmentName(String theCompartmentName) {
        this.myCompartmentName = theCompartmentName;
    }

    public String getCompleteUrl() {
        return this.myCompleteUrl;
    }

    public void setCompleteUrl(String theCompleteUrl) {
        this.myCompleteUrl = theCompleteUrl;
    }

    public String getConditionalUrl(RestOperationTypeEnum theOperationType) {
        if (this.myFixedConditionalUrl != null) {
            return this.myFixedConditionalUrl;
        }
        switch (theOperationType) {
            case CREATE: {
                String retVal = this.getHeader("If-None-Exist");
                if (StringUtils.isBlank((CharSequence)retVal)) {
                    return null;
                }
                if (retVal.startsWith(this.getFhirServerBase())) {
                    retVal = retVal.substring(this.getFhirServerBase().length());
                }
                return retVal;
            }
            case DELETE: 
            case UPDATE: 
            case PATCH: {
                if (this.getId() != null && this.getId().hasIdPart()) {
                    return null;
                }
                int questionMarkIndex = this.getCompleteUrl().indexOf(63);
                if (questionMarkIndex == -1) {
                    return null;
                }
                return this.getResourceName() + this.getCompleteUrl().substring(questionMarkIndex);
            }
        }
        return null;
    }

    public abstract FhirContext getFhirContext();

    public String getFhirServerBase() {
        return this.myFhirServerBase;
    }

    public void setFhirServerBase(String theFhirServerBase) {
        this.myFhirServerBase = theFhirServerBase;
    }

    public abstract String getHeader(String var1);

    public abstract List<String> getHeaders(String var1);

    public IIdType getId() {
        return this.myId;
    }

    public void setId(IIdType theId) {
        this.myId = theId;
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public abstract InputStream getInputStream() throws IOException;

    public String getOperation() {
        return this.myOperation;
    }

    public void setOperation(String theOperation) {
        this.myOperation = theOperation;
    }

    public Map<String, String[]> getParameters() {
        if (this.myParameters == null) {
            this.myParameters = new HashMap<String, String[]>();
        }
        return Collections.unmodifiableMap(this.myParameters);
    }

    public void setParameters(Map<String, String[]> theParams) {
        this.myParameters = theParams;
        this.myUnqualifiedToQualifiedNames = null;
        boolean needsSanitization = false;
        for (String nextKey : theParams.keySet()) {
            if (!UrlUtil.isNeedsSanitization((CharSequence)nextKey)) continue;
            needsSanitization = true;
            break;
        }
        if (needsSanitization) {
            this.myParameters = this.myParameters.entrySet().stream().collect(Collectors.toMap(t -> UrlUtil.sanitizeUrlPart((CharSequence)((String)t.getKey())), t -> (String[])t.getValue()));
        }
    }

    public abstract Reader getReader() throws IOException;

    public IInterceptorBroadcaster getInterceptorBroadcaster() {
        if (this.myDeferredInterceptorBroadcaster != null) {
            return this.myDeferredInterceptorBroadcaster;
        }
        return this.myInterceptorBroadcaster;
    }

    public String getRequestPath() {
        return this.myRequestPath;
    }

    public void setRequestPath(String theRequestPath) {
        assert (theRequestPath.length() == 0 || theRequestPath.charAt(0) != '/');
        this.myRequestPath = theRequestPath;
    }

    public RequestTypeEnum getRequestType() {
        return this.myRequestType;
    }

    public void setRequestType(RequestTypeEnum theRequestType) {
        this.myRequestType = theRequestType;
    }

    public String getResourceName() {
        return this.myResourceName;
    }

    public void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    public IRestfulResponse getResponse() {
        return this.myResponse;
    }

    public void setResponse(IRestfulResponse theResponse) {
        this.myResponse = theResponse;
    }

    public RestOperationTypeEnum getRestOperationType() {
        return this.myRestOperationType;
    }

    public void setRestOperationType(RestOperationTypeEnum theRestOperationType) {
        this.myRestOperationType = theRestOperationType;
    }

    public String getSecondaryOperation() {
        return this.mySecondaryOperation;
    }

    public void setSecondaryOperation(String theSecondaryOperation) {
        this.mySecondaryOperation = theSecondaryOperation;
    }

    public abstract IRestfulServerDefaults getServer();

    public abstract String getServerBaseForRequest();

    public String getTenantId() {
        return this.myTenantId;
    }

    public void setTenantId(String theTenantId) {
        this.myTenantId = theTenantId;
    }

    public Map<String, List<String>> getUnqualifiedToQualifiedNames() {
        if (this.myUnqualifiedToQualifiedNames == null) {
            block0: for (String next : this.myParameters.keySet()) {
                for (int i = 0; i < next.length(); ++i) {
                    String unqualified;
                    List<String> list;
                    char nextChar = next.charAt(i);
                    if (nextChar != ':' && nextChar != '.') continue;
                    if (this.myUnqualifiedToQualifiedNames == null) {
                        this.myUnqualifiedToQualifiedNames = new HashMap<String, List<String>>();
                    }
                    if ((list = this.myUnqualifiedToQualifiedNames.get(unqualified = next.substring(0, i))) == null) {
                        list = new ArrayList<String>(4);
                        this.myUnqualifiedToQualifiedNames.put(unqualified, list);
                    }
                    list.add(next);
                    continue block0;
                }
            }
        }
        if (this.myUnqualifiedToQualifiedNames == null) {
            this.myUnqualifiedToQualifiedNames = Collections.emptyMap();
        }
        return this.myUnqualifiedToQualifiedNames;
    }

    public Map<Object, Object> getUserData() {
        if (this.myUserData == null) {
            this.myUserData = new HashMap<Object, Object>();
        }
        return this.myUserData;
    }

    public boolean isRespondGzip() {
        return this.myRespondGzip;
    }

    public void setRespondGzip(boolean theRespondGzip) {
        this.myRespondGzip = theRespondGzip;
    }

    public boolean isSubRequest() {
        return this.mySubRequest;
    }

    public void setSubRequest(boolean theSubRequest) {
        this.mySubRequest = theSubRequest;
    }

    public final byte[] loadRequestContents() {
        if (this.myRequestContents == null) {
            this.myRequestContents = this.getByteStreamRequestContents();
        }
        return this.myRequestContents;
    }

    public void removeParameter(String theName) {
        Validate.notNull((Object)theName, (String)"theName must not be null", (Object[])new Object[0]);
        this.getParameters();
        this.myParameters.remove(theName);
    }

    public void setRequestContents(byte[] theRequestContents) {
        this.myRequestContents = theRequestContents;
    }

    public void startDeferredOperationCallback() {
        this.myDeferredInterceptorBroadcaster = new DeferredOperationCallback(this.myInterceptorBroadcaster);
    }

    public void stopDeferredRequestOperationCallbackAndRunDeferredItems() {
        DeferredOperationCallback deferredCallback = this.myDeferredInterceptorBroadcaster;
        deferredCallback.playDeferredActions();
        this.myInterceptorBroadcaster = deferredCallback.getWrap();
        this.myDeferredInterceptorBroadcaster = null;
    }

    private class DeferredOperationCallback
    implements IInterceptorBroadcaster {
        private final IInterceptorBroadcaster myWrap;
        private final List<Runnable> myDeferredTasks = new ArrayList<Runnable>();

        private DeferredOperationCallback(IInterceptorBroadcaster theWrap) {
            Validate.notNull((Object)theWrap);
            this.myWrap = theWrap;
        }

        void playDeferredActions() {
            this.myDeferredTasks.forEach(Runnable::run);
        }

        IInterceptorBroadcaster getWrap() {
            return this.myWrap;
        }

        public boolean callHooks(Pointcut thePointcut, HookParams theParams) {
            this.myDeferredTasks.add(() -> this.myWrap.callHooks(thePointcut, theParams));
            return true;
        }

        public Object callHooksAndReturnObject(Pointcut thePointcut, HookParams theParams) {
            this.myDeferredTasks.add(() -> this.myWrap.callHooksAndReturnObject(thePointcut, theParams));
            return null;
        }

        public boolean hasHooks(Pointcut thePointcut) {
            return this.myWrap.hasHooks(thePointcut);
        }
    }
}

