/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api.server;

import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class SimplePreResourceShowDetails
implements IPreResourceShowDetails,
Iterable<IBaseResource> {
    private final List<IBaseResource> myResources;
    private final boolean[] mySubSets;

    public SimplePreResourceShowDetails(IBaseResource theResource) {
        this(Lists.newArrayList((Object[])new IBaseResource[]{theResource}));
    }

    public <T extends IBaseResource> SimplePreResourceShowDetails(List<T> theResources) {
        this.myResources = theResources;
        this.mySubSets = new boolean[this.myResources.size()];
    }

    @Override
    public int size() {
        return this.myResources.size();
    }

    @Override
    public IBaseResource getResource(int theIndex) {
        return this.myResources.get(theIndex);
    }

    @Override
    public void setResource(int theIndex, IBaseResource theResource) {
        Validate.isTrue((theIndex >= 0 ? 1 : 0) != 0, (String)"Invalid index %d - theIndex must not be < 0", (long)theIndex);
        Validate.isTrue((theIndex < this.myResources.size() ? 1 : 0) != 0, (String)"Invalid index {} - theIndex must be < %d", (Object[])new Object[]{theIndex, this.myResources.size()});
        this.myResources.set(theIndex, theResource);
    }

    @Override
    public void markResourceAtIndexAsSubset(int theIndex) {
        Validate.isTrue((theIndex >= 0 ? 1 : 0) != 0, (String)"Invalid index %d - theIndex must not be < 0", (long)theIndex);
        Validate.isTrue((theIndex < this.myResources.size() ? 1 : 0) != 0, (String)"Invalid index {} - theIndex must be < %d", (Object[])new Object[]{theIndex, this.myResources.size()});
        this.mySubSets[theIndex] = true;
    }

    @Override
    public Iterator<IBaseResource> iterator() {
        return this.myResources.iterator();
    }
}

