/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.rest.server.Bindings;
import ca.uhn.fhir.rest.server.CommonResourceSupertypeScanner;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServerConfiguration {
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServerConfiguration.class);
    private Collection<ResourceBinding> resourceBindings;
    private List<BaseMethodBinding<?>> serverBindings;
    private Map<String, Class<? extends IBaseResource>> resourceNameToSharedSupertype;
    private String implementationDescription;
    private String serverVersion = VersionUtil.getVersion();
    private String serverName = "HAPI FHIR";
    private FhirContext fhirContext;
    private IServerAddressStrategy serverAddressStrategy;
    private IPrimitiveType<Date> myConformanceDate;

    public Collection<ResourceBinding> getResourceBindings() {
        return this.resourceBindings;
    }

    public RestfulServerConfiguration setResourceBindings(Collection<ResourceBinding> resourceBindings) {
        this.resourceBindings = resourceBindings;
        return this;
    }

    public List<BaseMethodBinding<?>> getServerBindings() {
        return this.serverBindings;
    }

    public RestfulServerConfiguration setServerBindings(List<BaseMethodBinding<?>> theServerBindings) {
        this.serverBindings = theServerBindings;
        return this;
    }

    public Map<String, Class<? extends IBaseResource>> getNameToSharedSupertype() {
        return this.resourceNameToSharedSupertype;
    }

    public RestfulServerConfiguration setNameToSharedSupertype(Map<String, Class<? extends IBaseResource>> resourceNameToSharedSupertype) {
        this.resourceNameToSharedSupertype = resourceNameToSharedSupertype;
        return this;
    }

    public String getImplementationDescription() {
        if (StringUtils.isBlank((CharSequence)this.implementationDescription)) {
            return "HAPI FHIR";
        }
        return this.implementationDescription;
    }

    public RestfulServerConfiguration setImplementationDescription(String implementationDescription) {
        this.implementationDescription = implementationDescription;
        return this;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public RestfulServerConfiguration setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public RestfulServerConfiguration setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    public RestfulServerConfiguration setFhirContext(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
        return this;
    }

    public IServerAddressStrategy getServerAddressStrategy() {
        return this.serverAddressStrategy;
    }

    public void setServerAddressStrategy(IServerAddressStrategy serverAddressStrategy) {
        this.serverAddressStrategy = serverAddressStrategy;
    }

    public IPrimitiveType<Date> getConformanceDate() {
        return this.myConformanceDate;
    }

    public void setConformanceDate(IPrimitiveType<Date> theConformanceDate) {
        this.myConformanceDate = theConformanceDate;
    }

    public Bindings provideBindings() {
        IdentityHashMap<SearchMethodBinding, String> myNamedSearchMethodBindingToName = new IdentityHashMap<SearchMethodBinding, String>();
        HashMap<String, List<SearchMethodBinding>> mySearchNameToBindings = new HashMap<String, List<SearchMethodBinding>>();
        IdentityHashMap<OperationMethodBinding, String> myOperationBindingToName = new IdentityHashMap<OperationMethodBinding, String>();
        HashMap<String, List<OperationMethodBinding>> myOperationNameToBindings = new HashMap<String, List<OperationMethodBinding>>();
        Map<String, List<BaseMethodBinding<?>>> resourceToMethods = this.collectMethodBindings();
        for (Map.Entry<String, List<BaseMethodBinding<?>>> nextEntry : resourceToMethods.entrySet()) {
            List<BaseMethodBinding<?>> nextMethodBindings = nextEntry.getValue();
            for (BaseMethodBinding<?> nextMethodBinding : nextMethodBindings) {
                String name;
                BaseResourceReturningMethodBinding methodBinding;
                if (nextMethodBinding instanceof OperationMethodBinding) {
                    methodBinding = (OperationMethodBinding)nextMethodBinding;
                    if (myOperationBindingToName.containsKey(methodBinding)) continue;
                    name = this.createOperationName((OperationMethodBinding)methodBinding);
                    ourLog.debug("Detected operation: {}", (Object)name);
                    myOperationBindingToName.put((OperationMethodBinding)methodBinding, name);
                    if (!myOperationNameToBindings.containsKey(name)) {
                        myOperationNameToBindings.put(name, new ArrayList());
                    }
                    myOperationNameToBindings.get(name).add((OperationMethodBinding)methodBinding);
                    continue;
                }
                if (!(nextMethodBinding instanceof SearchMethodBinding) || myNamedSearchMethodBindingToName.containsKey(methodBinding = (SearchMethodBinding)nextMethodBinding)) continue;
                name = this.createNamedQueryName((SearchMethodBinding)methodBinding);
                ourLog.debug("Detected named query: {}", (Object)name);
                myNamedSearchMethodBindingToName.put((SearchMethodBinding)methodBinding, name);
                if (!mySearchNameToBindings.containsKey(name)) {
                    mySearchNameToBindings.put(name, new ArrayList());
                }
                mySearchNameToBindings.get(name).add((SearchMethodBinding)methodBinding);
            }
        }
        return new Bindings(myNamedSearchMethodBindingToName, mySearchNameToBindings, myOperationNameToBindings, myOperationBindingToName);
    }

    public Map<String, List<BaseMethodBinding<?>>> collectMethodBindings() {
        String resourceName;
        TreeMap resourceToMethods = new TreeMap();
        for (ResourceBinding resourceBinding : this.getResourceBindings()) {
            resourceName = resourceBinding.getResourceName();
            for (BaseMethodBinding<?> nextMethodBinding : resourceBinding.getMethodBindings()) {
                if (!resourceToMethods.containsKey(resourceName)) {
                    resourceToMethods.put(resourceName, new ArrayList());
                }
                ((List)resourceToMethods.get(resourceName)).add(nextMethodBinding);
            }
        }
        for (BaseMethodBinding baseMethodBinding : this.getServerBindings()) {
            resourceName = "";
            if (!resourceToMethods.containsKey(resourceName)) {
                resourceToMethods.put(resourceName, new ArrayList());
            }
            ((List)resourceToMethods.get(resourceName)).add(baseMethodBinding);
        }
        return resourceToMethods;
    }

    public void computeSharedSupertypeForResourcePerName(Collection<IResourceProvider> providers) {
        HashMap resourceNameToScanner = new HashMap();
        List providedResourceClasses = providers.stream().map(provider -> provider.getResourceType()).collect(Collectors.toList());
        providedResourceClasses.stream().forEach(resourceClass -> {
            RuntimeResourceDefinition baseDefinition = this.getFhirContext().getResourceDefinition(resourceClass).getBaseDefinition();
            CommonResourceSupertypeScanner scanner = resourceNameToScanner.computeIfAbsent(baseDefinition.getName(), key -> new CommonResourceSupertypeScanner());
            scanner.register((Class<? extends IBaseResource>)resourceClass);
        });
        this.resourceNameToSharedSupertype = resourceNameToScanner.entrySet().stream().filter(entry -> ((CommonResourceSupertypeScanner)entry.getValue()).getLowestCommonSuperclass().isPresent()).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((CommonResourceSupertypeScanner)entry.getValue()).getLowestCommonSuperclass().get()));
    }

    private String createOperationName(OperationMethodBinding theMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (theMethodBinding.getResourceName() != null) {
            retVal.append(theMethodBinding.getResourceName());
        }
        retVal.append('-');
        if (theMethodBinding.isCanOperateAtInstanceLevel()) {
            retVal.append('i');
        }
        if (theMethodBinding.isCanOperateAtServerLevel()) {
            retVal.append('s');
        }
        retVal.append('-');
        retVal.append(theMethodBinding.getName(), 1, theMethodBinding.getName().length());
        return retVal.toString();
    }

    private String createNamedQueryName(SearchMethodBinding searchMethodBinding) {
        StringBuilder retVal = new StringBuilder();
        if (searchMethodBinding.getResourceName() != null) {
            retVal.append(searchMethodBinding.getResourceName());
        }
        retVal.append("-query-");
        retVal.append(searchMethodBinding.getQueryName());
        return retVal.toString();
    }
}

