/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorService;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.IRestfulServerDefaults;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public interface IServerInterceptor {
    @Hook(value=Pointcut.SERVER_HANDLE_EXCEPTION)
    public boolean handleException(RequestDetails var1, BaseServerResponseException var2, HttpServletRequest var3, HttpServletResponse var4) throws ServletException, IOException;

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_POST_PROCESSED)
    public boolean incomingRequestPostProcessed(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void incomingRequestPreHandled(RestOperationTypeEnum var1, ActionRequestDetails var2);

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_PROCESSED)
    public boolean incomingRequestPreProcessed(HttpServletRequest var1, HttpServletResponse var2);

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1);

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, HttpServletRequest var2, HttpServletResponse var3) throws AuthenticationException;

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, IBaseResource var2);

    @Deprecated
    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, IBaseResource var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public boolean outgoingResponse(RequestDetails var1, ResponseDetails var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    @Deprecated
    public boolean outgoingResponse(RequestDetails var1, TagList var2);

    @Deprecated
    public boolean outgoingResponse(RequestDetails var1, TagList var2, HttpServletRequest var3, HttpServletResponse var4) throws AuthenticationException;

    @Hook(value=Pointcut.SERVER_PRE_PROCESS_OUTGOING_EXCEPTION)
    public BaseServerResponseException preProcessOutgoingException(RequestDetails var1, Throwable var2, HttpServletRequest var3) throws ServletException;

    @Hook(value=Pointcut.SERVER_PROCESSING_COMPLETED_NORMALLY)
    public void processingCompletedNormally(ServletRequestDetails var1);

    @Deprecated
    public static class ActionRequestDetails {
        private final FhirContext myContext;
        private final IIdType myId;
        private final String myResourceType;
        private RequestDetails myRequestDetails;
        private IBaseResource myResource;

        public ActionRequestDetails(RequestDetails theRequestDetails) {
            this.myId = theRequestDetails.getId();
            this.myResourceType = theRequestDetails.getResourceName();
            this.myContext = theRequestDetails.getServer().getFhirContext();
            this.myRequestDetails = theRequestDetails;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, FhirContext theContext, IBaseResource theResource) {
            this(theRequestDetails, theContext, theContext.getResourceDefinition(theResource).getName(), theResource.getIdElement());
            this.myResource = theResource;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, FhirContext theContext, String theResourceType, IIdType theId) {
            this.myId = theId != null && StringUtils.isBlank((CharSequence)theId.getValue()) ? null : theId;
            this.myResourceType = theResourceType;
            this.myContext = theContext;
            this.myRequestDetails = theRequestDetails;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, IBaseResource theResource) {
            this(theRequestDetails, theRequestDetails.getServer().getFhirContext().getResourceDefinition(theResource).getName(), theResource.getIdElement());
            this.myResource = theResource;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, IBaseResource theResource, String theResourceType, IIdType theId) {
            this(theRequestDetails, theResourceType, theId);
            this.myResource = theResource;
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, IIdType theId) {
            this(theRequestDetails, theId.getResourceType(), theId);
        }

        public ActionRequestDetails(RequestDetails theRequestDetails, String theResourceType, IIdType theId) {
            this(theRequestDetails, theRequestDetails.getServer().getFhirContext(), theResourceType, theId);
        }

        public FhirContext getContext() {
            return this.myContext;
        }

        public IIdType getId() {
            return this.myId;
        }

        public RequestDetails getRequestDetails() {
            return this.myRequestDetails;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }

        public void setResource(IBaseResource theObject) {
            this.myResource = theObject;
        }

        public String getResourceType() {
            return this.myResourceType;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.myId).append("resourceType", (Object)this.myResourceType).append("resource", (Object)this.myResource).toString();
        }

        public Map<Object, Object> getUserData() {
            if (this.myRequestDetails == null) {
                return Collections.emptyMap();
            }
            return this.myRequestDetails.getUserData();
        }

        public void notifyIncomingRequestPreHandled(RestOperationTypeEnum theOperationType) {
            RequestDetails requestDetails = this.getRequestDetails();
            if (requestDetails == null) {
                return;
            }
            IRestfulServerDefaults server = requestDetails.getServer();
            if (server == null) {
                return;
            }
            IIdType previousRequestId = requestDetails.getId();
            requestDetails.setId(this.getId());
            IInterceptorService interceptorService = server.getInterceptorService();
            HookParams params = new HookParams();
            params.add(RestOperationTypeEnum.class, (Object)theOperationType);
            params.add((Object)this);
            params.add(RequestDetails.class, (Object)this.getRequestDetails());
            params.addIfMatchesType(ServletRequestDetails.class, (Object)this.getRequestDetails());
            interceptorService.callHooks(Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED, params);
            requestDetails.setId(previousRequestId);
        }
    }
}

