/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.auth;

import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.auth.AuthorizationInterceptor;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRule;
import ca.uhn.fhir.rest.server.interceptor.auth.IAuthRuleTester;
import ca.uhn.fhir.rest.server.interceptor.auth.PolicyEnum;
import ca.uhn.fhir.rest.server.interceptor.auth.RuleBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

abstract class BaseRule
implements IAuthRule {
    private String myName;
    private PolicyEnum myMode;
    private List<IAuthRuleTester> myTesters;
    private RuleBuilder.ITenantApplicabilityChecker myTenantApplicabilityChecker;

    BaseRule(String theRuleName) {
        this.myName = theRuleName;
    }

    public void addTester(IAuthRuleTester theTester) {
        Validate.notNull((Object)theTester, (String)"theTester must not be null", (Object[])new Object[0]);
        if (this.myTesters == null) {
            this.myTesters = new ArrayList<IAuthRuleTester>();
        }
        this.myTesters.add(theTester);
    }

    public void addTesters(List<IAuthRuleTester> theTesters) {
        theTesters.forEach(this::addTester);
    }

    boolean applyTesters(RestOperationTypeEnum theOperation, RequestDetails theRequestDetails, IIdType theInputResourceId, IBaseResource theInputResource, IBaseResource theOutputResource) {
        boolean retVal = true;
        if (theOutputResource == null) {
            for (IAuthRuleTester next : this.getTesters()) {
                if (next.matches(theOperation, theRequestDetails, theInputResourceId, theInputResource)) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    PolicyEnum getMode() {
        return this.myMode;
    }

    BaseRule setMode(PolicyEnum theRuleMode) {
        this.myMode = theRuleMode;
        return this;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public RuleBuilder.ITenantApplicabilityChecker getTenantApplicabilityChecker() {
        return this.myTenantApplicabilityChecker;
    }

    public final void setTenantApplicabilityChecker(RuleBuilder.ITenantApplicabilityChecker theTenantApplicabilityChecker) {
        this.myTenantApplicabilityChecker = theTenantApplicabilityChecker;
    }

    public List<IAuthRuleTester> getTesters() {
        if (this.myTesters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.myTesters);
    }

    public boolean isOtherTenant(RequestDetails theRequestDetails) {
        boolean otherTenant = false;
        if (this.getTenantApplicabilityChecker() != null && !this.getTenantApplicabilityChecker().applies(theRequestDetails)) {
            otherTenant = true;
        }
        return otherTenant;
    }

    AuthorizationInterceptor.Verdict newVerdict() {
        return new AuthorizationInterceptor.Verdict(this.myMode, this);
    }
}

