/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.consent;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.server.IPreResourceAccessDetails;
import ca.uhn.fhir.rest.api.server.IPreResourceShowDetails;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.ForbiddenOperationException;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOperationStatusEnum;
import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOutcome;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentContextServices;
import ca.uhn.fhir.rest.server.interceptor.consent.IConsentService;
import ca.uhn.fhir.rest.server.util.ICachedSearchDetails;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.IModelVisitor2;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;

@Interceptor
public class ConsentInterceptor {
    private static final AtomicInteger ourInstanceCount = new AtomicInteger(0);
    private final int myInstanceIndex = ourInstanceCount.incrementAndGet();
    private final String myRequestAuthorizedKey = ConsentInterceptor.class.getName() + "_" + this.myInstanceIndex + "_AUTHORIZED";
    private final String myRequestCompletedKey = ConsentInterceptor.class.getName() + "_" + this.myInstanceIndex + "_COMPLETED";
    private final String myRequestSeenResourcesKey = ConsentInterceptor.class.getName() + "_" + this.myInstanceIndex + "_SEENRESOURCES";
    private IConsentService myConsentService;
    private IConsentContextServices myContextConsentServices;

    public ConsentInterceptor() {
    }

    public ConsentInterceptor(IConsentService theConsentService) {
        this(theConsentService, IConsentContextServices.NULL_IMPL);
    }

    public ConsentInterceptor(IConsentService theConsentService, IConsentContextServices theContextConsentServices) {
        this.setConsentService(theConsentService);
        this.setContextConsentServices(theContextConsentServices);
    }

    public void setContextConsentServices(IConsentContextServices theContextConsentServices) {
        Validate.notNull((Object)theContextConsentServices, (String)"theContextConsentServices must not be null", (Object[])new Object[0]);
        this.myContextConsentServices = theContextConsentServices;
    }

    public void setConsentService(IConsentService theConsentService) {
        Validate.notNull((Object)theConsentService, (String)"theConsentService must not be null", (Object[])new Object[0]);
        this.myConsentService = theConsentService;
    }

    @Hook(value=Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED)
    public void interceptPreHandled(RequestDetails theRequestDetails) {
        ConsentOutcome outcome = this.myConsentService.startOperation(theRequestDetails, this.myContextConsentServices);
        Validate.notNull((Object)outcome, (String)"Consent service returned null outcome", (Object[])new Object[0]);
        switch (outcome.getStatus()) {
            case REJECT: {
                throw ConsentInterceptor.toForbiddenOperationException(outcome);
            }
            case PROCEED: {
                break;
            }
            case AUTHORIZED: {
                Map<Object, Object> userData = theRequestDetails.getUserData();
                userData.put(this.myRequestAuthorizedKey, Boolean.TRUE);
            }
        }
    }

    @Hook(value=Pointcut.STORAGE_PRECHECK_FOR_CACHED_SEARCH)
    public boolean interceptPreCheckForCachedSearch(RequestDetails theRequestDetails) {
        return this.isRequestAuthorized(theRequestDetails);
    }

    @Hook(value=Pointcut.STORAGE_PRESEARCH_REGISTERED)
    public void interceptPreSearchRegistered(RequestDetails theRequestDetails, ICachedSearchDetails theCachedSearchDetails) {
        if (!this.isRequestAuthorized(theRequestDetails)) {
            theCachedSearchDetails.setCannotBeReused();
        }
    }

    @Hook(value=Pointcut.STORAGE_PREACCESS_RESOURCES)
    public void interceptPreAccess(RequestDetails theRequestDetails, IPreResourceAccessDetails thePreResourceAccessDetails) {
        if (this.isRequestAuthorized(theRequestDetails)) {
            return;
        }
        block5: for (int i = 0; i < thePreResourceAccessDetails.size(); ++i) {
            IBaseResource nextResource = thePreResourceAccessDetails.getResource(i);
            ConsentOutcome nextOutcome = this.myConsentService.canSeeResource(theRequestDetails, nextResource, this.myContextConsentServices);
            switch (nextOutcome.getStatus()) {
                case PROCEED: {
                    continue block5;
                }
                case AUTHORIZED: {
                    continue block5;
                }
                case REJECT: {
                    thePreResourceAccessDetails.setDontReturnResourceAtIndex(i);
                }
            }
        }
    }

    @Hook(value=Pointcut.STORAGE_PRESHOW_RESOURCES)
    public void interceptPreShow(RequestDetails theRequestDetails, IPreResourceShowDetails thePreResourceShowDetails) {
        if (this.isRequestAuthorized(theRequestDetails)) {
            return;
        }
        IdentityHashMap<IBaseResource, Boolean> alreadySeenResources = this.getAlreadySeenResourcesMap(theRequestDetails);
        block5: for (int i = 0; i < thePreResourceShowDetails.size(); ++i) {
            IBaseResource nextResource = thePreResourceShowDetails.getResource(i);
            if (alreadySeenResources.putIfAbsent(nextResource, Boolean.TRUE) != null) continue;
            ConsentOutcome nextOutcome = this.myConsentService.willSeeResource(theRequestDetails, nextResource, this.myContextConsentServices);
            switch (nextOutcome.getStatus()) {
                case PROCEED: {
                    if (nextOutcome.getResource() == null) continue block5;
                    thePreResourceShowDetails.setResource(i, nextOutcome.getResource());
                    continue block5;
                }
                case AUTHORIZED: {
                    continue block5;
                }
                case REJECT: {
                    if (nextOutcome.getResource() != null) {
                        IBaseResource newResource = nextOutcome.getResource();
                        thePreResourceShowDetails.setResource(i, newResource);
                        alreadySeenResources.put(newResource, true);
                        continue block5;
                    }
                    if (nextOutcome.getOperationOutcome() != null) {
                        IBaseOperationOutcome newOperationOutcome = nextOutcome.getOperationOutcome();
                        thePreResourceShowDetails.setResource(i, (IBaseResource)newOperationOutcome);
                        alreadySeenResources.put((IBaseResource)newOperationOutcome, true);
                        continue block5;
                    }
                    String resourceId = nextResource.getIdElement().getValue();
                    thePreResourceShowDetails.setResource(i, null);
                    nextResource.setId(resourceId);
                }
            }
        }
    }

    private IdentityHashMap<IBaseResource, Boolean> getAlreadySeenResourcesMap(RequestDetails theRequestDetails) {
        return ConsentInterceptor.getAlreadySeenResourcesMap(theRequestDetails, this.myRequestSeenResourcesKey);
    }

    @Hook(value=Pointcut.SERVER_OUTGOING_RESPONSE)
    public void interceptOutgoingResponse(final RequestDetails theRequestDetails, ResponseDetails theResource) {
        if (theResource.getResponseResource() == null) {
            return;
        }
        if (this.isRequestAuthorized(theRequestDetails)) {
            return;
        }
        final IdentityHashMap<IBaseResource, Boolean> alreadySeenResources = this.getAlreadySeenResourcesMap(theRequestDetails);
        if (alreadySeenResources.putIfAbsent(theResource.getResponseResource(), Boolean.TRUE) == null) {
            ConsentOutcome outcome = this.myConsentService.willSeeResource(theRequestDetails, theResource.getResponseResource(), this.myContextConsentServices);
            if (outcome.getResource() != null) {
                theResource.setResponseResource(outcome.getResource());
            }
            switch (outcome.getStatus()) {
                case REJECT: {
                    if (outcome.getOperationOutcome() != null) {
                        theResource.setResponseResource((IBaseResource)outcome.getOperationOutcome());
                    } else {
                        theResource.setResponseResource(null);
                        theResource.setResponseCode(204);
                    }
                    return;
                }
                case AUTHORIZED: {
                    return;
                }
            }
        }
        final IBaseResource outerResource = theResource.getResponseResource();
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        IModelVisitor2 visitor = new IModelVisitor2(){

            public boolean acceptElement(IBase theElement, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                if (theElement instanceof IBaseBundle) {
                    BundleUtil.setTotal((FhirContext)theRequestDetails.getFhirContext(), (IBaseBundle)((IBaseBundle)theElement), null);
                }
                if (theElement == outerResource) {
                    return true;
                }
                if (theElement instanceof IBaseResource) {
                    if (alreadySeenResources.putIfAbsent((IBaseResource)theElement, Boolean.TRUE) != null) {
                        return true;
                    }
                    ConsentOutcome childOutcome = ConsentInterceptor.this.myConsentService.willSeeResource(theRequestDetails, (IBaseResource)theElement, ConsentInterceptor.this.myContextConsentServices);
                    IBaseOperationOutcome replacementResource = null;
                    boolean shouldReplaceResource = false;
                    boolean shouldCheckChildren = false;
                    switch (childOutcome.getStatus()) {
                        case REJECT: {
                            replacementResource = childOutcome.getOperationOutcome();
                            shouldReplaceResource = true;
                            break;
                        }
                        case PROCEED: 
                        case AUTHORIZED: {
                            replacementResource = childOutcome.getResource();
                            shouldReplaceResource = replacementResource != null;
                            boolean bl = shouldCheckChildren = childOutcome.getStatus() == ConsentOperationStatusEnum.PROCEED;
                        }
                    }
                    if (shouldReplaceResource) {
                        IBase container = theContainingElementPath.get(theContainingElementPath.size() - 2);
                        BaseRuntimeChildDefinition containerChildElement = theChildDefinitionPath.get(theChildDefinitionPath.size() - 1);
                        containerChildElement.getMutator().setValue(container, (IBase)replacementResource);
                    }
                    return shouldCheckChildren;
                }
                return true;
            }

            public boolean acceptUndeclaredExtension(IBaseExtension<?, ?> theNextExt, List<IBase> theContainingElementPath, List<BaseRuntimeChildDefinition> theChildDefinitionPath, List<BaseRuntimeElementDefinition<?>> theElementDefinitionPath) {
                return true;
            }
        };
        ctx.newTerser().visit(outerResource, visitor);
    }

    @Hook(value=Pointcut.SERVER_HANDLE_EXCEPTION)
    public void requestFailed(RequestDetails theRequest, BaseServerResponseException theException) {
        theRequest.getUserData().put(this.myRequestCompletedKey, Boolean.TRUE);
        this.myConsentService.completeOperationFailure(theRequest, theException, this.myContextConsentServices);
    }

    @Hook(value=Pointcut.SERVER_PROCESSING_COMPLETED_NORMALLY)
    public void requestSucceeded(RequestDetails theRequest) {
        if (Boolean.TRUE.equals(theRequest.getUserData().get(this.myRequestCompletedKey))) {
            return;
        }
        this.myConsentService.completeOperationSuccess(theRequest, this.myContextConsentServices);
    }

    private boolean isRequestAuthorized(RequestDetails theRequestDetails) {
        boolean retVal = false;
        if (theRequestDetails != null) {
            Object authorizedObj = theRequestDetails.getUserData().get(this.myRequestAuthorizedKey);
            retVal = Boolean.TRUE.equals(authorizedObj);
        }
        return retVal;
    }

    public static IdentityHashMap<IBaseResource, Boolean> getAlreadySeenResourcesMap(RequestDetails theRequestDetails, String theKey) {
        IdentityHashMap alreadySeenResources = (IdentityHashMap)theRequestDetails.getUserData().get(theKey);
        if (alreadySeenResources == null) {
            alreadySeenResources = new IdentityHashMap();
            theRequestDetails.getUserData().put(theKey, alreadySeenResources);
        }
        return alreadySeenResources;
    }

    private static ForbiddenOperationException toForbiddenOperationException(ConsentOutcome theOutcome) {
        IBaseOperationOutcome operationOutcome = null;
        if (theOutcome.getOperationOutcome() != null) {
            operationOutcome = theOutcome.getOperationOutcome();
        }
        return new ForbiddenOperationException("Rejected by consent service", operationOutcome);
    }
}

