/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Metadata;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.SimpleBundleProvider;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IBaseConformance;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ConformanceMethodBinding
extends BaseResourceReturningMethodBinding {
    private final AtomicReference<IBaseResource> myCachedResponse = new AtomicReference();
    private final AtomicLong myCachedResponseExpires = new AtomicLong(0L);
    private long myCacheMillis = 60000L;

    ConformanceMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod.getReturnType(), theMethod, theContext, theProvider);
        BaseResourceReturningMethodBinding.MethodReturnTypeEnum methodReturnType = this.getMethodReturnType();
        Class genericReturnType = (Class)theMethod.getGenericReturnType();
        if (methodReturnType != BaseResourceReturningMethodBinding.MethodReturnTypeEnum.RESOURCE || !IBaseConformance.class.isAssignableFrom(genericReturnType)) {
            throw new ConfigurationException("Conformance resource provider method '" + theMethod.getName() + "' should return a Conformance resource class, returns: " + theMethod.getReturnType());
        }
        Metadata metadata = theMethod.getAnnotation(Metadata.class);
        if (metadata != null) {
            this.setCacheMillis(metadata.cacheMillis());
        }
    }

    private long getCacheMillis() {
        return this.myCacheMillis;
    }

    private void setCacheMillis(long theCacheMillis) {
        this.myCacheMillis = theCacheMillis;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.RESOURCE;
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws BaseServerResponseException {
        RestOperationTypeEnum operationType;
        IBaseResource conf;
        CacheControlDirective cacheControlDirective = new CacheControlDirective().parse(theRequest.getHeaders("Cache-Control"));
        if (cacheControlDirective.isNoCache()) {
            conf = null;
        } else {
            long expires;
            conf = this.myCachedResponse.get();
            if ("true".equals(System.getProperty("test"))) {
                conf = null;
            }
            if (conf != null && (expires = this.myCachedResponseExpires.get()) < System.currentTimeMillis()) {
                conf = null;
            }
        }
        if (conf != null && (operationType = this.getRestOperationType(theRequest)) != null) {
            IServerInterceptor.ActionRequestDetails details = new IServerInterceptor.ActionRequestDetails(theRequest);
            this.populateActionRequestDetailsForInterceptor(theRequest, details, theMethodParams);
            HookParams preHandledParams = new HookParams();
            preHandledParams.add(RestOperationTypeEnum.class, (Object)theRequest.getRestOperationType());
            preHandledParams.add(RequestDetails.class, (Object)theRequest);
            preHandledParams.addIfMatchesType(ServletRequestDetails.class, (Object)theRequest);
            preHandledParams.add(IServerInterceptor.ActionRequestDetails.class, (Object)details);
            if (theRequest.getInterceptorBroadcaster() != null) {
                theRequest.getInterceptorBroadcaster().callHooks(Pointcut.SERVER_INCOMING_REQUEST_PRE_HANDLED, preHandledParams);
            }
        }
        if (conf == null) {
            conf = (IBaseResource)this.invokeServerMethod(theServer, theRequest, theMethodParams);
            if (this.myCacheMillis > 0L) {
                this.myCachedResponse.set(conf);
                this.myCachedResponseExpires.set(System.currentTimeMillis() + this.getCacheMillis());
            }
        }
        return new SimpleBundleProvider(conf);
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        if (theRequest.getRequestType() == RequestTypeEnum.OPTIONS && theRequest.getOperation() == null && theRequest.getResourceName() == null) {
            return true;
        }
        if (theRequest.getResourceName() != null) {
            return false;
        }
        if ("metadata".equals(theRequest.getOperation())) {
            if (theRequest.getRequestType() == RequestTypeEnum.GET) {
                return true;
            }
            throw new MethodNotAllowedException("/metadata request must use HTTP GET", new RequestTypeEnum[]{RequestTypeEnum.GET});
        }
        return false;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.METADATA;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return null;
    }
}

