/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.ResponseDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class GraphQLMethodBinding
extends BaseMethodBinding<String> {
    private final Integer myIdParamIndex;

    public GraphQLMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)theContext);
    }

    @Override
    public String getResourceName() {
        return null;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.GRAPHQL_REQUEST;
    }

    @Override
    public boolean isGlobalMethod() {
        return true;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        return "$graphql".equals(theRequest.getOperation());
    }

    @Override
    public Object invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest) throws BaseServerResponseException, IOException {
        Object[] methodParams = this.createMethodParams(theRequest);
        if (this.myIdParamIndex != null) {
            methodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theServer, theRequest, methodParams);
        int statusCode = 200;
        String statusMessage = (String)Constants.HTTP_STATUS_NAMES.get(statusCode);
        String contentType = "application/json";
        String charset = "UTF-8";
        boolean respondGzip = theRequest.isRespondGzip();
        String responseString = (String)response;
        HttpServletRequest servletRequest = null;
        HttpServletResponse servletResponse = null;
        if (theRequest instanceof ServletRequestDetails) {
            servletRequest = ((ServletRequestDetails)theRequest).getServletRequest();
            servletResponse = ((ServletRequestDetails)theRequest).getServletResponse();
        }
        HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(String.class, (Object)theRequest.getParameters().get("query")[0]).add(String.class, (Object)responseString).add(HttpServletRequest.class, (Object)servletRequest).add(HttpServletResponse.class, (Object)servletResponse);
        if (!theRequest.getInterceptorBroadcaster().callHooks(Pointcut.SERVER_OUTGOING_GRAPHQL_RESPONSE, params)) {
            return null;
        }
        params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(IBaseResource.class, null).add(ResponseDetails.class, (Object)new ResponseDetails()).add(HttpServletRequest.class, (Object)servletRequest).add(HttpServletResponse.class, (Object)servletResponse);
        if (!theRequest.getInterceptorBroadcaster().callHooks(Pointcut.SERVER_OUTGOING_RESPONSE, params)) {
            return null;
        }
        Writer writer = theRequest.getResponse().getResponseWriter(statusCode, statusMessage, contentType, charset, respondGzip);
        writer.write(responseString);
        writer.close();
        return null;
    }
}

