/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.annotation.Patch;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.method.BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody;
import ca.uhn.fhir.rest.server.method.PatchTypeParameter;
import ca.uhn.fhir.rest.server.method.UpdateMethodBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hl7.fhir.instance.model.api.IIdType;

public class PatchMethodBinding
extends BaseOutcomeReturningMethodBindingWithResourceIdButNoResourceBody {
    private int myPatchTypeParameterIndex = -1;
    private int myResourceParamIndex;

    public PatchMethodBinding(Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider, Patch.class, theMethod.getAnnotation(Patch.class).type());
        ListIterator<Class<?>> iter = Arrays.asList(theMethod.getParameterTypes()).listIterator();
        while (iter.hasNext()) {
            int nextIndex = iter.nextIndex();
            Class<?> next = iter.next();
            if (next.equals(PatchTypeEnum.class)) {
                this.myPatchTypeParameterIndex = nextIndex;
            }
            for (Annotation nextAnnotation : theMethod.getParameterAnnotations()[nextIndex]) {
                if (!(nextAnnotation instanceof ResourceParam)) continue;
                this.myResourceParamIndex = nextIndex;
            }
        }
        if (this.myPatchTypeParameterIndex == -1) {
            throw new ConfigurationException("Method has no parameter of type " + PatchTypeEnum.class.getName() + " - " + theMethod.toString());
        }
        if (this.myResourceParamIndex == -1) {
            throw new ConfigurationException("Method has no parameter with @" + ResourceParam.class.getSimpleName() + " annotation - " + theMethod.toString());
        }
    }

    @Override
    protected boolean allowVoidReturnType() {
        return true;
    }

    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        boolean retVal = super.incomingServerRequestMatchesMethod(theRequest);
        if (retVal) {
            PatchTypeParameter.getTypeForRequestOrThrowInvalidRequestException(theRequest);
        }
        return retVal;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.PATCH;
    }

    @Override
    protected Set<RequestTypeEnum> provideAllowableRequestTypes() {
        return Collections.singleton(RequestTypeEnum.PATCH);
    }

    @Override
    protected void addParametersForServerRequest(RequestDetails theRequest, Object[] theParams) {
        IIdType id = theRequest.getId();
        id = UpdateMethodBinding.applyETagAsVersion(theRequest, id);
        theParams[this.getIdParameterIndex().intValue()] = id;
    }

    @Override
    protected String getMatchingOperation() {
        return null;
    }
}

