/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.param.QualifierDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.method.BaseQueryParameter;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.method.IParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchMethodBinding
extends BaseResourceReturningMethodBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(SearchMethodBinding.class);
    private static final Set<String> SPECIAL_SEARCH_PARAMS;
    private final String myResourceProviderResourceName;
    private String myCompartmentName;
    private String myDescription;
    private Integer myIdParamIndex;
    private String myQueryName;
    private boolean myAllowUnknownParams;

    public SearchMethodBinding(Class<? extends IBaseResource> theReturnResourceType, Class<? extends IBaseResource> theResourceProviderResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theReturnResourceType, theMethod, theContext, theProvider);
        Search search = theMethod.getAnnotation(Search.class);
        this.myQueryName = (String)StringUtils.defaultIfBlank((CharSequence)search.queryName(), null);
        this.myCompartmentName = (String)StringUtils.defaultIfBlank((CharSequence)search.compartmentName(), null);
        this.myIdParamIndex = ParameterUtil.findIdParameterIndex((Method)theMethod, (FhirContext)this.getContext());
        this.myAllowUnknownParams = search.allowUnknownParams();
        Description desc = theMethod.getAnnotation(Description.class);
        if (desc != null) {
            this.myDescription = StringUtils.isNotBlank((CharSequence)desc.formalDefinition()) ? (String)StringUtils.defaultIfBlank((CharSequence)desc.formalDefinition(), null) : (String)StringUtils.defaultIfBlank((CharSequence)desc.shortDefinition(), null);
        }
        if (StringUtils.isBlank((CharSequence)this.myCompartmentName) && this.myIdParamIndex != null) {
            String msg = theContext.getLocalizer().getMessage(this.getClass().getName() + ".idWithoutCompartment", new Object[]{theMethod.getName(), theMethod.getDeclaringClass()});
            throw new ConfigurationException(msg);
        }
        this.myResourceProviderResourceName = theResourceProviderResourceType != null ? theContext.getResourceDefinition(theResourceProviderResourceType).getName() : null;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getQueryName() {
        return this.myQueryName;
    }

    public String getResourceProviderResourceName() {
        return this.myResourceProviderResourceName;
    }

    @Override
    @Nonnull
    public RestOperationTypeEnum getRestOperationType() {
        return RestOperationTypeEnum.SEARCH_TYPE;
    }

    @Override
    protected BundleTypeEnum getResponseBundleType() {
        return BundleTypeEnum.SEARCHSET;
    }

    @Override
    public BaseResourceReturningMethodBinding.ReturnTypeEnum getReturnType() {
        return BaseResourceReturningMethodBinding.ReturnTypeEnum.BUNDLE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean incomingServerRequestMatchesMethod(RequestDetails theRequest) {
        HashSet<String> methodParamsTemp;
        block20: {
            Object queryNameValues;
            if (theRequest.getId() != null && this.myIdParamIndex == null) {
                ourLog.trace("Method {} doesn't match because ID is not null: {}", (Object)this.getMethod(), (Object)theRequest.getId());
                return false;
            }
            if (theRequest.getRequestType() == RequestTypeEnum.GET && theRequest.getOperation() != null && !"_search".equals(theRequest.getOperation())) {
                ourLog.trace("Method {} doesn't match because request type is GET but operation is not null: {}", (Object)theRequest.getId(), (Object)theRequest.getOperation());
                return false;
            }
            if (theRequest.getRequestType() == RequestTypeEnum.POST && !"_search".equals(theRequest.getOperation())) {
                ourLog.trace("Method {} doesn't match because request type is POST but operation is not _search: {}", (Object)theRequest.getId(), (Object)theRequest.getOperation());
                return false;
            }
            if (theRequest.getRequestType() != RequestTypeEnum.GET && theRequest.getRequestType() != RequestTypeEnum.POST) {
                ourLog.trace("Method {} doesn't match because request type is {}", (Object)this.getMethod(), (Object)theRequest.getRequestType());
                return false;
            }
            if (!StringUtils.equals((CharSequence)this.myCompartmentName, (CharSequence)theRequest.getCompartmentName())) {
                ourLog.trace("Method {} doesn't match because it is for compartment {} but request is compartment {}", new Object[]{this.getMethod(), this.myCompartmentName, theRequest.getCompartmentName()});
                return false;
            }
            if (theRequest.getParameters().get("_getpages") != null) {
                return false;
            }
            methodParamsTemp = new HashSet<String>();
            Set<String> unqualifiedNames = theRequest.getUnqualifiedToQualifiedNames().keySet();
            Set<String> qualifiedParamNames = theRequest.getParameters().keySet();
            for (IParameter nextParameter : this.getParameters()) {
                List<String> qualifiedNames;
                QualifierDetails qualifiers;
                if (!(nextParameter instanceof BaseQueryParameter)) continue;
                BaseQueryParameter nextQueryParameter = (BaseQueryParameter)nextParameter;
                String name = nextQueryParameter.getName();
                if (nextQueryParameter.isRequired()) {
                    if (qualifiedParamNames.contains(name) && (qualifiers = SearchMethodBinding.extractQualifiersFromParameterName(name)).passes(nextQueryParameter.getQualifierWhitelist(), nextQueryParameter.getQualifierBlacklist())) {
                        methodParamsTemp.add(name);
                    }
                    if (unqualifiedNames.contains(name)) {
                        qualifiedNames = theRequest.getUnqualifiedToQualifiedNames().get(name);
                        qualifiedNames = this.processWhitelistAndBlacklist(qualifiedNames, nextQueryParameter.getQualifierWhitelist(), nextQueryParameter.getQualifierBlacklist());
                        methodParamsTemp.addAll(qualifiedNames);
                    }
                    if (qualifiedParamNames.contains(name) || unqualifiedNames.contains(name)) continue;
                    ourLog.trace("Method {} doesn't match param '{}' is not present", (Object)this.getMethod().getName(), (Object)name);
                    return false;
                }
                if (qualifiedParamNames.contains(name) && (qualifiers = SearchMethodBinding.extractQualifiersFromParameterName(name)).passes(nextQueryParameter.getQualifierWhitelist(), nextQueryParameter.getQualifierBlacklist())) {
                    methodParamsTemp.add(name);
                }
                if (unqualifiedNames.contains(name)) {
                    qualifiedNames = theRequest.getUnqualifiedToQualifiedNames().get(name);
                    qualifiedNames = this.processWhitelistAndBlacklist(qualifiedNames, nextQueryParameter.getQualifierWhitelist(), nextQueryParameter.getQualifierBlacklist());
                    methodParamsTemp.addAll(qualifiedNames);
                }
                if (qualifiedParamNames.contains(name)) continue;
                methodParamsTemp.add(name);
            }
            if (this.myQueryName != null) {
                queryNameValues = theRequest.getParameters().get("_query");
                if (queryNameValues != null && StringUtils.isNotBlank((CharSequence)queryNameValues[0])) {
                    Object queryName = queryNameValues[0];
                    if (!this.myQueryName.equals(queryName)) {
                        ourLog.trace("Query name does not match {}", (Object)this.myQueryName);
                        return false;
                    }
                    methodParamsTemp.add("_query");
                    break block20;
                } else {
                    ourLog.trace("Query name does not match {}", (Object)this.myQueryName);
                    return false;
                }
            }
            queryNameValues = theRequest.getParameters().get("_query");
            if (queryNameValues != null && StringUtils.isNotBlank((CharSequence)queryNameValues[0])) {
                ourLog.trace("Query has name");
                return false;
            }
        }
        for (String next : theRequest.getParameters().keySet()) {
            if (!next.startsWith("_") || SPECIAL_SEARCH_PARAMS.contains(this.truncModifierPart(next))) continue;
            methodParamsTemp.add(next);
        }
        Set<String> keySet = theRequest.getParameters().keySet();
        if (!this.myAllowUnknownParams) {
            for (String next : keySet) {
                if (methodParamsTemp.contains(next)) continue;
                return false;
            }
        }
        return true;
    }

    private String truncModifierPart(String param) {
        int indexOfSeparator = param.indexOf(":");
        if (indexOfSeparator != -1) {
            return param.substring(0, indexOfSeparator);
        }
        return param;
    }

    @Override
    public IBundleProvider invokeServer(IRestfulServer<?> theServer, RequestDetails theRequest, Object[] theMethodParams) throws InvalidRequestException, InternalErrorException {
        if (this.myIdParamIndex != null) {
            theMethodParams[this.myIdParamIndex.intValue()] = theRequest.getId();
        }
        Object response = this.invokeServerMethod(theServer, theRequest, theMethodParams);
        return this.toResourceList(response);
    }

    @Override
    protected boolean isAddContentLocationHeader() {
        return false;
    }

    private List<String> processWhitelistAndBlacklist(List<String> theQualifiedNames, Set<String> theQualifierWhitelist, Set<String> theQualifierBlacklist) {
        if (theQualifierWhitelist == null && theQualifierBlacklist == null) {
            return theQualifiedNames;
        }
        ArrayList<String> retVal = new ArrayList<String>(theQualifiedNames.size());
        for (String next : theQualifiedNames) {
            QualifierDetails qualifiers = SearchMethodBinding.extractQualifiersFromParameterName(next);
            if (!qualifiers.passes(theQualifierWhitelist, theQualifierBlacklist)) continue;
            retVal.add(next);
        }
        return retVal;
    }

    public String toString() {
        return this.getMethod().toString();
    }

    public static QualifierDetails extractQualifiersFromParameterName(String theParamName) {
        QualifierDetails retVal = new QualifierDetails();
        if (theParamName == null || theParamName.length() == 0) {
            return retVal;
        }
        int dotIdx = -1;
        int colonIdx = -1;
        for (int idx = 0; idx < theParamName.length(); ++idx) {
            char nextChar = theParamName.charAt(idx);
            if (nextChar == '.' && dotIdx == -1) {
                dotIdx = idx;
                continue;
            }
            if (nextChar != ':' || colonIdx != -1) continue;
            colonIdx = idx;
        }
        if (dotIdx != -1 && colonIdx != -1) {
            if (dotIdx < colonIdx) {
                retVal.setDotQualifier(theParamName.substring(dotIdx, colonIdx));
                retVal.setColonQualifier(theParamName.substring(colonIdx));
                retVal.setParamName(theParamName.substring(0, dotIdx));
                retVal.setWholeQualifier(theParamName.substring(dotIdx));
            } else {
                retVal.setColonQualifier(theParamName.substring(colonIdx, dotIdx));
                retVal.setDotQualifier(theParamName.substring(dotIdx));
                retVal.setParamName(theParamName.substring(0, colonIdx));
                retVal.setWholeQualifier(theParamName.substring(colonIdx));
            }
        } else if (dotIdx != -1) {
            retVal.setDotQualifier(theParamName.substring(dotIdx));
            retVal.setParamName(theParamName.substring(0, dotIdx));
            retVal.setWholeQualifier(theParamName.substring(dotIdx));
        } else if (colonIdx != -1) {
            retVal.setColonQualifier(theParamName.substring(colonIdx));
            retVal.setParamName(theParamName.substring(0, colonIdx));
            retVal.setWholeQualifier(theParamName.substring(colonIdx));
        } else {
            retVal.setParamName(theParamName);
            retVal.setColonQualifier(null);
            retVal.setDotQualifier(null);
            retVal.setWholeQualifier(null);
        }
        return retVal;
    }

    static {
        HashSet<String> specialSearchParams = new HashSet<String>();
        specialSearchParams.add("_id");
        specialSearchParams.add("_language");
        specialSearchParams.add("_include");
        specialSearchParams.add("_revinclude");
        SPECIAL_SEARCH_PARAMS = Collections.unmodifiableSet(specialSearchParams);
    }
}

