/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.server.IRestfulResponse;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class RestfulResponse<T extends RequestDetails>
implements IRestfulResponse {
    private IIdType myOperationResourceId;
    private IPrimitiveType<Date> myOperationResourceLastUpdated;
    private final Map<String, List<String>> myHeaders = new HashMap<String, List<String>>();
    private T theRequestDetails;

    public RestfulResponse(T requestDetails) {
        this.theRequestDetails = requestDetails;
    }

    @Override
    public void addHeader(String headerKey, String headerValue) {
        this.getHeaders().computeIfAbsent(headerKey, k -> new ArrayList()).add(headerValue);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.myHeaders;
    }

    public T getRequestDetails() {
        return this.theRequestDetails;
    }

    @Override
    public void setOperationResourceId(IIdType theOperationResourceId) {
        this.myOperationResourceId = theOperationResourceId;
    }

    @Override
    public void setOperationResourceLastUpdated(IPrimitiveType<Date> theOperationResourceLastUpdated) {
        this.myOperationResourceLastUpdated = theOperationResourceLastUpdated;
    }

    public void setRequestDetails(T requestDetails) {
        this.theRequestDetails = requestDetails;
    }

    @Override
    public final Object streamResponseAsResource(IBaseResource theResource, boolean thePrettyPrint, Set<SummaryEnum> theSummaryMode, int theStatusCode, String theStatusMessage, boolean theRespondGzip, boolean theAddContentLocation) throws IOException {
        return RestfulServerUtils.streamResponseAsResource(((RequestDetails)this.theRequestDetails).getServer(), theResource, theSummaryMode, theStatusCode, theStatusMessage, theAddContentLocation, theRespondGzip, this.getRequestDetails(), this.myOperationResourceId, this.myOperationResourceLastUpdated);
    }
}

