/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.method;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.At;
import ca.uhn.fhir.rest.annotation.ConditionalUrlParam;
import ca.uhn.fhir.rest.annotation.Count;
import ca.uhn.fhir.rest.annotation.Elements;
import ca.uhn.fhir.rest.annotation.GraphQLQueryBody;
import ca.uhn.fhir.rest.annotation.GraphQLQueryUrl;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.IncludeParam;
import ca.uhn.fhir.rest.annotation.Offset;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.annotation.OptionalParam;
import ca.uhn.fhir.rest.annotation.Patch;
import ca.uhn.fhir.rest.annotation.RawParam;
import ca.uhn.fhir.rest.annotation.RequiredParam;
import ca.uhn.fhir.rest.annotation.ResourceParam;
import ca.uhn.fhir.rest.annotation.ServerBase;
import ca.uhn.fhir.rest.annotation.Since;
import ca.uhn.fhir.rest.annotation.Sort;
import ca.uhn.fhir.rest.annotation.TransactionParam;
import ca.uhn.fhir.rest.annotation.Validate;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.SearchContainedModeEnum;
import ca.uhn.fhir.rest.api.SearchTotalModeEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.api.ValidationModeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.param.binder.CollectionBinder;
import ca.uhn.fhir.rest.server.method.AtParameter;
import ca.uhn.fhir.rest.server.method.ConditionalParamBinder;
import ca.uhn.fhir.rest.server.method.CountParameter;
import ca.uhn.fhir.rest.server.method.ElementsParameter;
import ca.uhn.fhir.rest.server.method.GraphQLQueryBodyParameter;
import ca.uhn.fhir.rest.server.method.GraphQLQueryUrlParameter;
import ca.uhn.fhir.rest.server.method.IParameter;
import ca.uhn.fhir.rest.server.method.IncludeParameter;
import ca.uhn.fhir.rest.server.method.InterceptorBroadcasterParameter;
import ca.uhn.fhir.rest.server.method.NullParameter;
import ca.uhn.fhir.rest.server.method.OffsetParameter;
import ca.uhn.fhir.rest.server.method.OperationParameter;
import ca.uhn.fhir.rest.server.method.PatchTypeParameter;
import ca.uhn.fhir.rest.server.method.RawParamsParameter;
import ca.uhn.fhir.rest.server.method.RequestDetailsParameter;
import ca.uhn.fhir.rest.server.method.ResourceParameter;
import ca.uhn.fhir.rest.server.method.SearchContainedModeParameter;
import ca.uhn.fhir.rest.server.method.SearchParameter;
import ca.uhn.fhir.rest.server.method.SearchTotalModeParameter;
import ca.uhn.fhir.rest.server.method.ServerBaseParamBinder;
import ca.uhn.fhir.rest.server.method.ServletRequestParameter;
import ca.uhn.fhir.rest.server.method.ServletResponseParameter;
import ca.uhn.fhir.rest.server.method.SinceParameter;
import ca.uhn.fhir.rest.server.method.SortParameter;
import ca.uhn.fhir.rest.server.method.SummaryEnumParameter;
import ca.uhn.fhir.rest.server.method.TransactionParameter;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ParametersUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public class MethodUtil {
    private MethodUtil() {
    }

    public static void extractDescription(SearchParameter theParameter, Annotation[] theAnnotations) {
        for (Annotation annotation : theAnnotations) {
            if (!(annotation instanceof Description)) continue;
            Description desc = (Description)annotation;
            String description = ParametersUtil.extractDescription((Description)desc);
            theParameter.setDescription(description);
        }
    }

    public static List<IParameter> getResourceParameters(final FhirContext theContext, Method theMethod, Object theProvider, RestOperationTypeEnum theRestfulOperationTypeEnum) {
        ArrayList<IParameter> parameters = new ArrayList<IParameter>();
        Class<?>[] parameterTypes = theMethod.getParameterTypes();
        int paramIndex = 0;
        for (Annotation[] nextParameterAnnotations : theMethod.getParameterAnnotations()) {
            Class declaredParameterType;
            IParameter param = null;
            Class parameterType = declaredParameterType = parameterTypes[paramIndex];
            Class outerCollectionType = null;
            Class innerCollectionType = null;
            if (TagList.class.isAssignableFrom(parameterType)) {
                param = new NullParameter();
            } else {
                if (Collection.class.isAssignableFrom(parameterType)) {
                    innerCollectionType = parameterType;
                    parameterType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter((Method)theMethod, (int)paramIndex);
                    if (parameterType == null && theMethod.getDeclaringClass().isSynthetic()) {
                        try {
                            theMethod = theMethod.getDeclaringClass().getSuperclass().getMethod(theMethod.getName(), parameterTypes);
                            parameterType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter((Method)theMethod, (int)paramIndex);
                        }
                        catch (NoSuchMethodException e) {
                            throw new ConfigurationException(Msg.code((int)400) + "A method with name '" + theMethod.getName() + "' does not exist for super class '" + theMethod.getDeclaringClass().getSuperclass() + "'");
                        }
                    }
                    declaredParameterType = parameterType;
                }
                if (Collection.class.isAssignableFrom(parameterType)) {
                    outerCollectionType = innerCollectionType;
                    innerCollectionType = parameterType;
                    declaredParameterType = parameterType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter((Method)theMethod, (int)paramIndex);
                }
                if (Collection.class.isAssignableFrom(parameterType)) {
                    throw new ConfigurationException(Msg.code((int)401) + "Argument #" + paramIndex + " of Method '" + theMethod.getName() + "' in type '" + theMethod.getDeclaringClass().getCanonicalName() + "' is of an invalid generic type (can not be a collection of a collection of a collection)");
                }
                if (IPrimitiveType.class.equals((Object)parameterType)) {
                    BaseRuntimeElementDefinition dateTimeDef;
                    Class genericType = ReflectionUtil.getGenericCollectionTypeOfMethodParameter((Method)theMethod, (int)paramIndex);
                    if (Date.class.equals((Object)genericType)) {
                        dateTimeDef = theContext.getElementDefinition("dateTime");
                        parameterType = dateTimeDef.getImplementingClass();
                    } else if (String.class.equals((Object)genericType) || genericType == null) {
                        dateTimeDef = theContext.getElementDefinition("string");
                        parameterType = dateTimeDef.getImplementingClass();
                    }
                }
            }
            if (ServletRequest.class.isAssignableFrom(parameterType)) {
                param = new ServletRequestParameter();
            } else if (ServletResponse.class.isAssignableFrom(parameterType)) {
                param = new ServletResponseParameter();
            } else if (parameterType.equals(RequestDetails.class) || parameterType.equals(ServletRequestDetails.class)) {
                param = new RequestDetailsParameter();
            } else if (parameterType.equals(IInterceptorBroadcaster.class)) {
                param = new InterceptorBroadcasterParameter();
            } else if (parameterType.equals(SummaryEnum.class)) {
                param = new SummaryEnumParameter();
            } else if (parameterType.equals(PatchTypeEnum.class)) {
                param = new PatchTypeParameter();
            } else if (parameterType.equals(SearchContainedModeEnum.class)) {
                param = new SearchContainedModeParameter();
            } else if (parameterType.equals(SearchTotalModeEnum.class)) {
                param = new SearchTotalModeParameter();
            } else {
                for (int i = 0; i < nextParameterAnnotations.length && param == null; ++i) {
                    String description;
                    SearchParameter parameter;
                    Annotation nextAnnotation = nextParameterAnnotations[i];
                    if (nextAnnotation instanceof RequiredParam) {
                        parameter = new SearchParameter();
                        parameter.setName(((RequiredParam)nextAnnotation).name());
                        parameter.setRequired(true);
                        parameter.setDeclaredTypes(((RequiredParam)nextAnnotation).targetTypes());
                        parameter.setCompositeTypes(((RequiredParam)nextAnnotation).compositeTypes());
                        parameter.setChainLists(((RequiredParam)nextAnnotation).chainWhitelist(), ((RequiredParam)nextAnnotation).chainBlacklist());
                        parameter.setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        MethodUtil.extractDescription(parameter, nextParameterAnnotations);
                        param = parameter;
                        continue;
                    }
                    if (nextAnnotation instanceof OptionalParam) {
                        parameter = new SearchParameter();
                        parameter.setName(((OptionalParam)nextAnnotation).name());
                        parameter.setRequired(false);
                        parameter.setDeclaredTypes(((OptionalParam)nextAnnotation).targetTypes());
                        parameter.setCompositeTypes(((OptionalParam)nextAnnotation).compositeTypes());
                        parameter.setChainLists(((OptionalParam)nextAnnotation).chainWhitelist(), ((OptionalParam)nextAnnotation).chainBlacklist());
                        parameter.setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        MethodUtil.extractDescription(parameter, nextParameterAnnotations);
                        param = parameter;
                        continue;
                    }
                    if (nextAnnotation instanceof RawParam) {
                        param = new RawParamsParameter(parameters);
                        continue;
                    }
                    if (nextAnnotation instanceof IncludeParam) {
                        Class specType;
                        Class instantiableCollectionType;
                        if (parameterType == String.class) {
                            instantiableCollectionType = null;
                            specType = String.class;
                        } else {
                            if (parameterType != Include.class || innerCollectionType == null || outerCollectionType != null) {
                                throw new ConfigurationException(Msg.code((int)402) + "Method '" + theMethod.getName() + "' is annotated with @" + IncludeParam.class.getSimpleName() + " but has a type other than Collection<" + Include.class.getSimpleName() + ">");
                            }
                            instantiableCollectionType = CollectionBinder.getInstantiableCollectionType((Class)innerCollectionType, (String)("Method '" + theMethod.getName() + "'"));
                            specType = parameterType;
                        }
                        param = new IncludeParameter((IncludeParam)nextAnnotation, instantiableCollectionType, specType);
                        continue;
                    }
                    if (nextAnnotation instanceof ResourceParam) {
                        ResourceParameter.Mode mode;
                        if (IBaseResource.class.isAssignableFrom(parameterType)) {
                            mode = ResourceParameter.Mode.RESOURCE;
                        } else if (String.class.equals((Object)parameterType)) {
                            mode = ResourceParameter.Mode.BODY;
                        } else if (byte[].class.equals((Object)parameterType)) {
                            mode = ResourceParameter.Mode.BODY_BYTE_ARRAY;
                        } else if (EncodingEnum.class.equals((Object)parameterType)) {
                            mode = ResourceParameter.Mode.ENCODING;
                        } else {
                            StringBuilder b = new StringBuilder();
                            b.append("Method '");
                            b.append(theMethod.getName());
                            b.append("' is annotated with @");
                            b.append(ResourceParam.class.getSimpleName());
                            b.append(" but has a type that is not an implementation of ");
                            b.append(IBaseResource.class.getCanonicalName());
                            b.append(" or String or byte[]");
                            throw new ConfigurationException(Msg.code((int)403) + b.toString());
                        }
                        boolean methodIsOperation = theMethod.getAnnotation(Operation.class) != null;
                        boolean methodIsPatch = theMethod.getAnnotation(Patch.class) != null;
                        param = new ResourceParameter(parameterType, theProvider, mode, methodIsOperation, methodIsPatch);
                        continue;
                    }
                    if (nextAnnotation instanceof IdParam) {
                        param = new NullParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof ServerBase) {
                        param = new ServerBaseParamBinder();
                        continue;
                    }
                    if (nextAnnotation instanceof Elements) {
                        param = new ElementsParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Since) {
                        param = new SinceParameter();
                        ((SinceParameter)param).setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        continue;
                    }
                    if (nextAnnotation instanceof At) {
                        param = new AtParameter();
                        ((AtParameter)param).setType(theContext, parameterType, innerCollectionType, outerCollectionType);
                        continue;
                    }
                    if (nextAnnotation instanceof Count) {
                        param = new CountParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Offset) {
                        param = new OffsetParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof GraphQLQueryUrl) {
                        param = new GraphQLQueryUrlParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof GraphQLQueryBody) {
                        param = new GraphQLQueryBodyParameter();
                        continue;
                    }
                    if (nextAnnotation instanceof Sort) {
                        param = new SortParameter(theContext);
                        continue;
                    }
                    if (nextAnnotation instanceof TransactionParam) {
                        param = new TransactionParameter(theContext);
                        continue;
                    }
                    if (nextAnnotation instanceof ConditionalUrlParam) {
                        param = new ConditionalParamBinder(theRestfulOperationTypeEnum, ((ConditionalUrlParam)nextAnnotation).supportsMultiple());
                        continue;
                    }
                    if (nextAnnotation instanceof OperationParam) {
                        Operation op = theMethod.getAnnotation(Operation.class);
                        if (op == null) {
                            throw new ConfigurationException(Msg.code((int)404) + "@OperationParam detected on method that is not annotated with @Operation: " + theMethod.toGenericString());
                        }
                        OperationParam operationParam = (OperationParam)nextAnnotation;
                        String description2 = ParametersUtil.extractDescription((Annotation[])nextParameterAnnotations);
                        List examples = ParametersUtil.extractExamples((Annotation[])nextParameterAnnotations);
                        param = new OperationParameter(theContext, op.name(), operationParam.name(), operationParam.min(), operationParam.max(), description2, examples);
                        if (!StringUtils.isNotBlank((CharSequence)operationParam.typeName())) continue;
                        BaseRuntimeElementDefinition elementDefinition = theContext.getElementDefinition(operationParam.typeName());
                        if (elementDefinition == null) {
                            elementDefinition = theContext.getResourceDefinition(operationParam.typeName());
                        }
                        org.apache.commons.lang3.Validate.notNull((Object)elementDefinition, (String)"Unknown type name in @OperationParam: typeName=\"%s\"", (Object[])new Object[]{operationParam.typeName()});
                        Class newParameterType = elementDefinition.getImplementingClass();
                        if (!declaredParameterType.isAssignableFrom(newParameterType)) {
                            throw new ConfigurationException(Msg.code((int)405) + "Non assignable parameter typeName=\"" + operationParam.typeName() + "\" specified on method " + theMethod);
                        }
                        parameterType = newParameterType;
                        continue;
                    }
                    if (nextAnnotation instanceof Validate.Mode) {
                        if (!parameterType.equals(ValidationModeEnum.class)) {
                            throw new ConfigurationException(Msg.code((int)406) + "Parameter annotated with @" + Validate.class.getSimpleName() + "." + Validate.Mode.class.getSimpleName() + " must be of type " + ValidationModeEnum.class.getName());
                        }
                        description = ParametersUtil.extractDescription((Annotation[])nextParameterAnnotations);
                        List examples = ParametersUtil.extractExamples((Annotation[])nextParameterAnnotations);
                        param = new OperationParameter(theContext, "$validate", "mode", 0, 1, description, examples).setConverter(new OperationParameter.IOperationParamConverter(){

                            @Override
                            public Object incomingServer(Object theObject) {
                                if (StringUtils.isNotBlank((CharSequence)theObject.toString())) {
                                    ValidationModeEnum retVal = ValidationModeEnum.forCode((String)theObject.toString());
                                    if (retVal == null) {
                                        OperationParameter.throwInvalidMode(theObject.toString());
                                    }
                                    return retVal;
                                }
                                return null;
                            }

                            @Override
                            public Object outgoingClient(Object theObject) {
                                return ParametersUtil.createString((FhirContext)theContext, (String)((ValidationModeEnum)theObject).getCode());
                            }
                        });
                        continue;
                    }
                    if (!(nextAnnotation instanceof Validate.Profile)) continue;
                    if (!parameterType.equals(String.class)) {
                        throw new ConfigurationException(Msg.code((int)407) + "Parameter annotated with @" + Validate.class.getSimpleName() + "." + Validate.Profile.class.getSimpleName() + " must be of type " + String.class.getName());
                    }
                    description = ParametersUtil.extractDescription((Annotation[])nextParameterAnnotations);
                    List examples = ParametersUtil.extractExamples((Annotation[])nextParameterAnnotations);
                    param = new OperationParameter(theContext, "$validate", "profile", 0, 1, description, examples).setConverter(new OperationParameter.IOperationParamConverter(){

                        @Override
                        public Object incomingServer(Object theObject) {
                            return theObject.toString();
                        }

                        @Override
                        public Object outgoingClient(Object theObject) {
                            return ParametersUtil.createString((FhirContext)theContext, (String)theObject.toString());
                        }
                    });
                }
            }
            if (param == null) {
                throw new ConfigurationException(Msg.code((int)408) + "Parameter #" + (paramIndex + 1) + "/" + parameterTypes.length + " of method '" + theMethod.getName() + "' on type '" + theMethod.getDeclaringClass().getCanonicalName() + "' has no recognized FHIR interface parameter nextParameterAnnotations. Don't know how to handle this parameter");
            }
            param.initializeTypes(theMethod, outerCollectionType, innerCollectionType, parameterType);
            parameters.add(param);
            ++paramIndex;
        }
        return parameters;
    }
}

