/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class CommonResourceSupertypeScanner {
    private List<Class<? extends IBaseResource>> greatestSharedAncestorsDescending;
    private boolean initialized;

    public void register(Class<? extends IBaseResource> resourceClass) {
        LinkedList<Class<? extends IBaseResource>> resourceClassesInHierarchy = new LinkedList<Class<? extends IBaseResource>>();
        Class<? extends IBaseResource> currentClass = resourceClass;
        while (IBaseResource.class.isAssignableFrom(currentClass) && currentClass.getAnnotation(ResourceDef.class) != null) {
            resourceClassesInHierarchy.add(currentClass);
            currentClass = currentClass.getSuperclass();
        }
        Collections.reverse(resourceClassesInHierarchy);
        if (this.initialized) {
            for (int i = 0; i < Math.min(resourceClassesInHierarchy.size(), this.greatestSharedAncestorsDescending.size()); ++i) {
                if (this.greatestSharedAncestorsDescending.get(i) == resourceClassesInHierarchy.get(i)) continue;
                this.greatestSharedAncestorsDescending = this.greatestSharedAncestorsDescending.subList(0, i);
                break;
            }
        } else {
            this.greatestSharedAncestorsDescending = resourceClassesInHierarchy;
            this.initialized = true;
        }
    }

    public Optional<Class<? extends IBaseResource>> getLowestCommonSuperclass() {
        if (!this.initialized || this.greatestSharedAncestorsDescending.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.greatestSharedAncestorsDescending.get(this.greatestSharedAncestorsDescending.size() - 1));
    }
}

