/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.MethodMatchEnum;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceBinding.class);
    private String resourceName;
    private LinkedList<BaseMethodBinding<?>> myMethodBindings = new LinkedList();

    public BaseMethodBinding<?> getMethod(RequestDetails theRequest) {
        if (null == this.myMethodBindings) {
            ourLog.warn("No methods exist for resource: {}", (Object)this.resourceName);
            return null;
        }
        ourLog.debug("Looking for a handler for {}", (Object)theRequest);
        BaseMethodBinding matchedMethod = null;
        Enum matchedMethodStrength = null;
        for (BaseMethodBinding baseMethodBinding : this.myMethodBindings) {
            MethodMatchEnum nextMethodMatch = baseMethodBinding.incomingServerRequestMatchesMethod(theRequest);
            if (nextMethodMatch == MethodMatchEnum.NONE) continue;
            if (matchedMethodStrength == null || matchedMethodStrength.ordinal() < nextMethodMatch.ordinal()) {
                matchedMethod = baseMethodBinding;
                matchedMethodStrength = nextMethodMatch;
            }
            if (matchedMethodStrength != MethodMatchEnum.EXACT) continue;
            break;
        }
        return matchedMethod;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public List<BaseMethodBinding<?>> getMethodBindings() {
        return this.myMethodBindings;
    }

    public void addMethod(BaseMethodBinding<?> method) {
        this.myMethodBindings.push(method);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceBinding)) {
            return false;
        }
        return this.resourceName.equals(((ResourceBinding)o).getResourceName());
    }

    public int hashCode() {
        return 0;
    }
}

