/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.consent;

import ca.uhn.fhir.rest.server.interceptor.consent.ConsentOperationStatusEnum;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class ConsentOutcome {
    public static final ConsentOutcome PROCEED = new ConsentOutcome(ConsentOperationStatusEnum.PROCEED);
    public static final ConsentOutcome REJECT = new ConsentOutcome(ConsentOperationStatusEnum.REJECT);
    public static final ConsentOutcome AUTHORIZED = new ConsentOutcome(ConsentOperationStatusEnum.AUTHORIZED);
    private final ConsentOperationStatusEnum myStatus;
    private final IBaseOperationOutcome myOperationOutcome;
    private final IBaseResource myResource;

    public ConsentOutcome(ConsentOperationStatusEnum theStatus) {
        this(theStatus, null, null);
    }

    public ConsentOutcome(ConsentOperationStatusEnum theStatus, IBaseOperationOutcome theOperationOutcome) {
        this(theStatus, theOperationOutcome, null);
    }

    public ConsentOutcome(ConsentOperationStatusEnum theStatus, IBaseResource theResource) {
        this(theStatus, null, theResource);
    }

    private ConsentOutcome(ConsentOperationStatusEnum theStatus, IBaseOperationOutcome theOperationOutcome, IBaseResource theResource) {
        Validate.notNull((Object)((Object)theStatus), (String)"theStatus must not be null", (Object[])new Object[0]);
        Validate.isTrue((theOperationOutcome == null || theResource == null ? 1 : 0) != 0, (String)"theOperationOutcome and theResource must not both be null", (Object[])new Object[0]);
        this.myStatus = theStatus;
        this.myOperationOutcome = theOperationOutcome;
        this.myResource = theResource;
    }

    public ConsentOperationStatusEnum getStatus() {
        return this.myStatus;
    }

    public IBaseOperationOutcome getOperationOutcome() {
        return this.myOperationOutcome;
    }

    public IBaseResource getResource() {
        return this.myResource;
    }
}

