/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor.partition;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

@Interceptor
public class RequestTenantPartitionInterceptor {
    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_CREATE)
    public RequestPartitionId PartitionIdentifyCreate(RequestDetails theRequestDetails) {
        return this.extractPartitionIdFromRequest(theRequestDetails);
    }

    @Hook(value=Pointcut.STORAGE_PARTITION_IDENTIFY_READ)
    public RequestPartitionId PartitionIdentifyRead(RequestDetails theRequestDetails) {
        return this.extractPartitionIdFromRequest(theRequestDetails);
    }

    @Nonnull
    protected RequestPartitionId extractPartitionIdFromRequest(RequestDetails theRequestDetails) {
        String tenantId = theRequestDetails.getTenantId();
        if (StringUtils.isBlank((CharSequence)tenantId)) {
            throw new InternalErrorException(Msg.code((int)343) + "No tenant ID has been specified");
        }
        return RequestPartitionId.fromPartitionName((String)tenantId);
    }
}

