package ca.uhn.fhir.jpa.bulk.export.model;

/*-
 * #%L
 * HAPI FHIR Storage api
 * %%
 * Copyright (C) 2014 - 2022 Smile CDR, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.batch.core.BatchStatus;

@JsonFormat(shape = JsonFormat.Shape.STRING)
public enum BulkExportJobStatusEnum {

	/**
	 * Sorting OK!
	 */

	SUBMITTED,
	BUILDING,
	COMPLETE,
	ERROR;

	public static BulkExportJobStatusEnum fromBatchStatus(BatchStatus status) {
		switch (status) {
			case STARTING :
				return BulkExportJobStatusEnum.SUBMITTED;
			case COMPLETED :
				return BulkExportJobStatusEnum.COMPLETE;
			case STARTED :
				return BulkExportJobStatusEnum.BUILDING;
			default :
				return BulkExportJobStatusEnum.ERROR;
		}
	}

}
