package ca.uhn.fhir.jpa.bulk.imprt.model;

/*-
 * #%L
 * HAPI FHIR Storage api
 * %%
 * Copyright (C) 2014 - 2022 Smile CDR, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.hl7.fhir.instance.model.api.IBaseResource;

import java.io.Serializable;

public class ParsedBulkImportRecord implements Serializable {

	private static final long serialVersionUID = 1L;

	private final String myTenantName;
	private final IBaseResource myRowContent;
	private final int myLineIndex;

	public ParsedBulkImportRecord(String theTenantName, IBaseResource theRowContent, int theLineIndex) {
		myTenantName = theTenantName;
		myRowContent = theRowContent;
		myLineIndex = theLineIndex;
	}

	public int getLineIndex() {
		return myLineIndex;
	}

	public String getTenantName() {
		return myTenantName;
	}

	public IBaseResource getRowContent() {
		return myRowContent;
	}
}
