package ca.uhn.fhir.jpa.dao;

/*-
 * #%L
 * HAPI FHIR Storage api
 * %%
 * Copyright (C) 2014 - 2022 Smile CDR, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import org.apache.commons.lang3.StringUtils;

/**
 * Utility class to help identify classes of failure.
 */
public class DaoFailureUtil {

	public static boolean isTagStorageFailure(Throwable t) {
		if (StringUtils.isBlank(t.getMessage())) {
			return false;
		} else {
			String msg = t.getMessage().toLowerCase();
			return msg.contains("hfj_tag_def") || msg.contains("hfj_res_tag");
		}
	}
}
