/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.api.model;

import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.function.Supplier;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public class LazyDaoMethodOutcome
extends DaoMethodOutcome {
    private Supplier<EntityAndResource> myEntitySupplier;
    private Supplier<IIdType> myIdSupplier;
    private Runnable myEntitySupplierUseCallback;

    public LazyDaoMethodOutcome(ResourcePersistentId theResourcePersistentId) {
        this.setPersistentId(theResourcePersistentId);
    }

    @Override
    public IBasePersistedResource getEntity() {
        IBasePersistedResource retVal = super.getEntity();
        if (retVal == null) {
            this.tryToRunSupplier();
            retVal = super.getEntity();
        }
        return retVal;
    }

    private void tryToRunSupplier() {
        if (this.myEntitySupplier != null) {
            EntityAndResource entityAndResource = this.myEntitySupplier.get();
            this.setEntity(entityAndResource.getEntity());
            this.setResource(entityAndResource.getResource());
            this.setId(entityAndResource.getResource().getIdElement());
            this.myEntitySupplierUseCallback.run();
        }
    }

    public IIdType getId() {
        IIdType retVal = super.getId();
        if (retVal == null) {
            if (super.hasResource()) {
                retVal = this.getResource().getIdElement();
                this.setId(retVal);
            } else if (this.myIdSupplier != null) {
                retVal = this.myIdSupplier.get();
                this.setId(retVal);
            }
        }
        return retVal;
    }

    public IBaseResource getResource() {
        IBaseResource retVal = super.getResource();
        if (retVal == null) {
            this.tryToRunSupplier();
            retVal = super.getResource();
        }
        return retVal;
    }

    public void setEntitySupplier(Supplier<EntityAndResource> theEntitySupplier) {
        this.myEntitySupplier = theEntitySupplier;
    }

    public void setEntitySupplierUseCallback(Runnable theEntitySupplierUseCallback) {
        this.myEntitySupplierUseCallback = theEntitySupplierUseCallback;
    }

    public void setIdSupplier(Supplier<IIdType> theIdSupplier) {
        this.myIdSupplier = theIdSupplier;
    }

    public static class EntityAndResource {
        private final IBasePersistedResource myEntity;
        private final IBaseResource myResource;

        public EntityAndResource(IBasePersistedResource theEntity, IBaseResource theResource) {
            this.myEntity = theEntity;
            this.myResource = theResource;
        }

        public IBasePersistedResource getEntity() {
            return this.myEntity;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }
    }
}

