/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class BaseBulkItemReader
implements ItemReader<List<ResourcePersistentId>> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    @Value(value="#{stepExecutionContext['resourceType']}")
    protected String myResourceType;
    @Value(value="#{jobParameters['readChunkSize']}")
    protected Long myReadChunkSize;
    @Autowired
    protected FhirContext myContext;
    @Autowired
    private MatchUrlService myMatchUrlService;
    private Iterator<ResourcePersistentId> myPidIterator;
    private RuntimeResourceDefinition myResourceDefinition;

    protected void loadResourcePIDs() {
        this.myPidIterator = this.getResourcePidIterator();
    }

    protected abstract Iterator<ResourcePersistentId> getResourcePidIterator();

    protected abstract String[] getTypeFilterList();

    protected abstract Date getSinceDate();

    protected abstract String getLogInfoForRead();

    protected List<SearchParameterMap> createSearchParameterMapsForResourceType() {
        RuntimeResourceDefinition theDef = this.getResourceDefinition();
        String[] typeFilters = this.getTypeFilterList();
        List<Object> spMaps = null;
        if (typeFilters != null) {
            spMaps = Arrays.stream(typeFilters).filter(typeFilter -> typeFilter.startsWith(this.myResourceType + "?")).map(filter -> this.buildSearchParameterMapForTypeFilter((String)filter, theDef)).collect(Collectors.toList());
        }
        if (spMaps == null || spMaps.isEmpty()) {
            SearchParameterMap defaultMap = new SearchParameterMap();
            this.enhanceSearchParameterMapWithCommonParameters(defaultMap);
            spMaps = Collections.singletonList(defaultMap);
        }
        return spMaps;
    }

    private void enhanceSearchParameterMapWithCommonParameters(SearchParameterMap map) {
        map.setLoadSynchronous(true);
        if (this.getSinceDate() != null) {
            map.setLastUpdated(new DateRangeParam(this.getSinceDate(), null));
        }
    }

    public SearchParameterMap buildSearchParameterMapForTypeFilter(String theFilter, RuntimeResourceDefinition theDef) {
        SearchParameterMap searchParameterMap = this.myMatchUrlService.translateMatchUrl(theFilter, theDef, new MatchUrlService.Flag[0]);
        this.enhanceSearchParameterMapWithCommonParameters(searchParameterMap);
        return searchParameterMap;
    }

    protected RuntimeResourceDefinition getResourceDefinition() {
        if (this.myResourceDefinition == null) {
            this.myResourceDefinition = this.myContext.getResourceDefinition(this.myResourceType);
        }
        return this.myResourceDefinition;
    }

    public List<ResourcePersistentId> read() {
        ourLog.info(this.getLogInfoForRead());
        if (this.myPidIterator == null) {
            this.loadResourcePIDs();
        }
        int count = 0;
        ArrayList<ResourcePersistentId> outgoing = new ArrayList<ResourcePersistentId>();
        while (this.myPidIterator.hasNext() && (long)count < this.myReadChunkSize) {
            outgoing.add(this.myPidIterator.next());
            ++count;
        }
        return outgoing.size() == 0 ? null : outgoing;
    }
}

