/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.job;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.partition.SystemRequestDetails;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.util.BinaryUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Value;

public abstract class BaseResourceToFileWriter
implements ItemWriter<List<IBaseResource>> {
    protected static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    protected FhirContext myFhirContext;
    protected DaoRegistry myDaoRegistry;
    protected ByteArrayOutputStream myOutputStream;
    @Value(value="#{stepExecutionContext['bulkExportCollectionEntityId']}")
    protected Long myBulkExportCollectionEntityId;
    @Value(value="#{stepExecutionContext['resourceType']}")
    protected String myResourceType;
    protected IFhirResourceDao myBinaryDao;
    private final OutputStreamWriter myWriter;
    private final IParser myParser;

    protected BaseResourceToFileWriter(FhirContext theFhirContext, DaoRegistry theDaoRegistry) {
        this.myFhirContext = theFhirContext;
        this.myDaoRegistry = theDaoRegistry;
        this.myParser = this.myFhirContext.newJsonParser().setPrettyPrint(false);
        this.myOutputStream = new ByteArrayOutputStream();
        this.myWriter = new OutputStreamWriter((OutputStream)this.myOutputStream, Constants.CHARSET_UTF8);
    }

    protected IIdType createBinaryFromOutputStream() {
        IBaseBinary binary = BinaryUtil.newBinary((FhirContext)this.myFhirContext);
        binary.setContentType("application/fhir+ndjson");
        binary.setContent(this.myOutputStream.toByteArray());
        DaoMethodOutcome outcome = this.myBinaryDao.create(binary, new SystemRequestDetails().setRequestPartitionId(RequestPartitionId.defaultPartition()));
        return outcome.getResource().getIdElement();
    }

    public void write(List<? extends List<IBaseResource>> theList) throws Exception {
        int count = 0;
        for (List<IBaseResource> list : theList) {
            for (IBaseResource nextFileResource : list) {
                this.myParser.encodeResourceToWriter(nextFileResource, (Writer)this.myWriter);
                this.myWriter.append("\n");
                ++count;
            }
        }
        Optional<IIdType> createdId = this.flushToFiles();
        if (createdId.isPresent()) {
            ourLog.info("Created {} resources for bulk export file containing {} resources of type {} ", new Object[]{count, createdId.get().toUnqualifiedVersionless().getValue(), this.myResourceType});
        }
    }

    protected abstract Optional<IIdType> flushToFiles();
}

