/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.bulk.export.provider;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.batch.config.BatchConstants;
import ca.uhn.fhir.jpa.bulk.export.api.IBulkDataExportSvc;
import ca.uhn.fhir.jpa.bulk.export.model.BulkExportResponseJson;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.PreferHeader;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.bulk.BulkDataExportOptions;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.ArrayUtil;
import ca.uhn.fhir.util.JsonUtil;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BulkDataExportProvider {
    public static final String FARM_TO_TABLE_TYPE_FILTER_REGEX = "(?:,)(?=[A-Z][a-z]+\\?)";
    private static final Logger ourLog = LoggerFactory.getLogger(BulkDataExportProvider.class);
    @Autowired
    private IBulkDataExportSvc myBulkDataExportSvc;
    @Autowired
    private FhirContext myFhirContext;

    @VisibleForTesting
    public void setFhirContextForUnitTest(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    @VisibleForTesting
    public void setBulkDataExportSvcForUnitTests(IBulkDataExportSvc theBulkDataExportSvc) {
        this.myBulkDataExportSvc = theBulkDataExportSvc;
    }

    @Operation(name="$export", global=false, manualResponse=true, idempotent=true)
    public void export(@OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, ServletRequestDetails theRequestDetails) {
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        BulkDataExportOptions bulkDataExportOptions = this.buildSystemBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter);
        Boolean useCache = this.shouldUseCache(theRequestDetails);
        IBulkDataExportSvc.JobInfo outcome = this.myBulkDataExportSvc.submitJob(bulkDataExportOptions, useCache, (RequestDetails)theRequestDetails);
        this.writePollingLocationToResponseHeaders(theRequestDetails, outcome);
    }

    private boolean shouldUseCache(ServletRequestDetails theRequestDetails) {
        CacheControlDirective cacheControlDirective = new CacheControlDirective().parse(theRequestDetails.getHeaders("Cache-Control"));
        return !cacheControlDirective.isNoCache();
    }

    private String getServerBase(ServletRequestDetails theRequestDetails) {
        return StringUtils.removeEnd((String)theRequestDetails.getServerBaseForRequest(), (String)"/");
    }

    private String getDefaultPartitionServerBase(ServletRequestDetails theRequestDetails) {
        if (theRequestDetails.getTenantId() == null || theRequestDetails.getTenantId().equals("DEFAULT")) {
            return this.getServerBase(theRequestDetails);
        }
        return StringUtils.removeEnd((String)theRequestDetails.getServerBaseForRequest().replace(theRequestDetails.getTenantId(), "DEFAULT"), (String)"/");
    }

    @Operation(name="$export", manualResponse=true, idempotent=true, typeName="Group")
    public void groupExport(@IdParam IIdType theIdParam, @OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, @OperationParam(name="_mdm", min=0, max=1, typeName="boolean") IPrimitiveType<Boolean> theMdm, ServletRequestDetails theRequestDetails) {
        ourLog.debug("Received Group Bulk Export Request for Group {}", (Object)theIdParam);
        ourLog.debug("_type={}", (Object)theIdParam);
        ourLog.debug("_since={}", theSince);
        ourLog.debug("_typeFilter={}", theTypeFilter);
        ourLog.debug("_mdm=", theMdm);
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        BulkDataExportOptions bulkDataExportOptions = this.buildGroupBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter, theIdParam, theMdm);
        this.validateResourceTypesAllContainPatientSearchParams(bulkDataExportOptions.getResourceTypes());
        IBulkDataExportSvc.JobInfo outcome = this.myBulkDataExportSvc.submitJob(bulkDataExportOptions, this.shouldUseCache(theRequestDetails), (RequestDetails)theRequestDetails);
        this.writePollingLocationToResponseHeaders(theRequestDetails, outcome);
    }

    private void validateResourceTypesAllContainPatientSearchParams(Set<String> theResourceTypes) {
        List badResourceTypes;
        if (theResourceTypes != null && !(badResourceTypes = theResourceTypes.stream().filter(resourceType -> !BatchConstants.PATIENT_BULK_EXPORT_FORWARD_REFERENCE_RESOURCE_TYPES.contains(resourceType)).filter(resourceType -> !this.myBulkDataExportSvc.getPatientCompartmentResources().contains(resourceType)).collect(Collectors.toList())).isEmpty()) {
            throw new InvalidRequestException(Msg.code((int)512) + String.format("Resource types [%s] are invalid for this type of export, as they do not contain search parameters that refer to patients.", String.join((CharSequence)",", badResourceTypes)));
        }
    }

    @Operation(name="$export", manualResponse=true, idempotent=true, typeName="Patient")
    public void patientExport(@OperationParam(name="_outputFormat", min=0, max=1, typeName="string") IPrimitiveType<String> theOutputFormat, @OperationParam(name="_type", min=0, max=1, typeName="string") IPrimitiveType<String> theType, @OperationParam(name="_since", min=0, max=1, typeName="instant") IPrimitiveType<Date> theSince, @OperationParam(name="_typeFilter", min=0, max=-1, typeName="string") List<IPrimitiveType<String>> theTypeFilter, ServletRequestDetails theRequestDetails) {
        BulkDataExportProvider.validatePreferAsyncHeader(theRequestDetails, "$export");
        BulkDataExportOptions bulkDataExportOptions = this.buildPatientBulkExportOptions(theOutputFormat, theType, theSince, theTypeFilter);
        this.validateResourceTypesAllContainPatientSearchParams(bulkDataExportOptions.getResourceTypes());
        IBulkDataExportSvc.JobInfo outcome = this.myBulkDataExportSvc.submitJob(bulkDataExportOptions, this.shouldUseCache(theRequestDetails), (RequestDetails)theRequestDetails);
        this.writePollingLocationToResponseHeaders(theRequestDetails, outcome);
    }

    @Operation(name="$export-poll-status", manualResponse=true, idempotent=true)
    public void exportPollStatus(@OperationParam(name="_jobId", typeName="string", min=0, max=1) IPrimitiveType<String> theJobId, ServletRequestDetails theRequestDetails) throws IOException {
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        IBulkDataExportSvc.JobInfo status = this.myBulkDataExportSvc.getJobInfoOrThrowResourceNotFound(theJobId.getValueAsString());
        switch (status.getStatus()) {
            case SUBMITTED: 
            case BUILDING: {
                response.setStatus(202);
                response.addHeader("X-Progress", "Build in progress - Status set to " + status.getStatus() + " at " + new InstantType(status.getStatusTime()).getValueAsString());
                response.addHeader("Retry-After", "120");
                break;
            }
            case COMPLETE: {
                response.setStatus(200);
                response.setContentType("application/json");
                BulkExportResponseJson bulkResponseDocument = new BulkExportResponseJson();
                bulkResponseDocument.setTransactionTime(status.getStatusTime());
                bulkResponseDocument.setRequest(status.getRequest());
                for (IBulkDataExportSvc.FileEntry nextFile : status.getFiles()) {
                    String serverBase = this.getDefaultPartitionServerBase(theRequestDetails);
                    String nextUrl = serverBase + "/" + nextFile.getResourceId().toUnqualifiedVersionless().getValue();
                    bulkResponseDocument.addOutput().setType(nextFile.getResourceType()).setUrl(nextUrl);
                }
                JsonUtil.serialize((Object)bulkResponseDocument, (Writer)response.getWriter());
                response.getWriter().close();
                break;
            }
            case ERROR: {
                response.setStatus(500);
                response.setContentType("application/json+fhir");
                IBaseOperationOutcome oo = OperationOutcomeUtil.newInstance((FhirContext)this.myFhirContext);
                OperationOutcomeUtil.addIssue((FhirContext)this.myFhirContext, (IBaseOperationOutcome)oo, (String)"error", (String)status.getStatusMessage(), null, null);
                this.myFhirContext.newJsonParser().setPrettyPrint(true).encodeResourceToWriter((IBaseResource)oo, (Writer)response.getWriter());
                response.getWriter().close();
            }
        }
    }

    private BulkDataExportOptions buildSystemBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter) {
        return this.buildBulkDataExportOptions(theOutputFormat, theType, theSince, theTypeFilter, BulkDataExportOptions.ExportStyle.SYSTEM);
    }

    private BulkDataExportOptions buildGroupBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, IIdType theGroupId, IPrimitiveType<Boolean> theExpandMdm) {
        BulkDataExportOptions bulkDataExportOptions = this.buildBulkDataExportOptions(theOutputFormat, theType, theSince, theTypeFilter, BulkDataExportOptions.ExportStyle.GROUP);
        bulkDataExportOptions.setGroupId(theGroupId);
        boolean mdm = false;
        if (theExpandMdm != null) {
            mdm = (Boolean)theExpandMdm.getValue();
        }
        bulkDataExportOptions.setExpandMdm(mdm);
        return bulkDataExportOptions;
    }

    private BulkDataExportOptions buildPatientBulkExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter) {
        return this.buildBulkDataExportOptions(theOutputFormat, theType, theSince, theTypeFilter, BulkDataExportOptions.ExportStyle.PATIENT);
    }

    private BulkDataExportOptions buildBulkDataExportOptions(IPrimitiveType<String> theOutputFormat, IPrimitiveType<String> theType, IPrimitiveType<Date> theSince, List<IPrimitiveType<String>> theTypeFilter, BulkDataExportOptions.ExportStyle theExportStyle) {
        String outputFormat = theOutputFormat != null ? theOutputFormat.getValueAsString() : null;
        Set resourceTypes = null;
        if (theType != null) {
            resourceTypes = ArrayUtil.commaSeparatedListToCleanSet((String)theType.getValueAsString());
        }
        Date since = null;
        if (theSince != null) {
            since = (Date)theSince.getValue();
        }
        Set<String> typeFilters = this.splitTypeFilters(theTypeFilter);
        BulkDataExportOptions bulkDataExportOptions = new BulkDataExportOptions();
        bulkDataExportOptions.setFilters(typeFilters);
        bulkDataExportOptions.setExportStyle(theExportStyle);
        bulkDataExportOptions.setSince(since);
        bulkDataExportOptions.setResourceTypes(resourceTypes);
        bulkDataExportOptions.setOutputFormat(outputFormat);
        return bulkDataExportOptions;
    }

    public void writePollingLocationToResponseHeaders(ServletRequestDetails theRequestDetails, IBulkDataExportSvc.JobInfo theOutcome) {
        String serverBase = this.getServerBase(theRequestDetails);
        String pollLocation = serverBase + "/$export-poll-status?_jobId=" + theOutcome.getJobId();
        HttpServletResponse response = theRequestDetails.getServletResponse();
        theRequestDetails.getServer().addHeadersToResponse(response);
        response.addHeader("Content-Location", pollLocation);
        response.setStatus(202);
    }

    public static void validatePreferAsyncHeader(ServletRequestDetails theRequestDetails, String theOperationName) {
        String preferHeader = theRequestDetails.getHeader("Prefer");
        PreferHeader prefer = RestfulServerUtils.parsePreferHeader(null, (String)preferHeader);
        if (!prefer.getRespondAsync()) {
            throw new InvalidRequestException(Msg.code((int)513) + "Must request async processing for " + theOperationName);
        }
    }

    private Set<String> splitTypeFilters(List<IPrimitiveType<String>> theTypeFilter) {
        if (theTypeFilter == null) {
            return null;
        }
        HashSet<String> retVal = new HashSet<String>();
        for (IPrimitiveType<String> next : theTypeFilter) {
            String typeFilterString = next.getValueAsString();
            Arrays.stream(typeFilterString.split(FARM_TO_TABLE_TYPE_FILTER_REGEX)).filter(StringUtils::isNotBlank).forEach(t -> retVal.add((String)t));
        }
        return retVal;
    }
}

