/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.HookParams;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.interceptor.model.TransactionWriteOperationsDetails;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.dao.IJpaDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.api.model.DeleteConflict;
import ca.uhn.fhir.jpa.api.model.DeleteConflictList;
import ca.uhn.fhir.jpa.api.model.DeleteMethodOutcome;
import ca.uhn.fhir.jpa.api.model.LazyDaoMethodOutcome;
import ca.uhn.fhir.jpa.cache.IResourceVersionSvc;
import ca.uhn.fhir.jpa.cache.ResourcePersistentIdMap;
import ca.uhn.fhir.jpa.dao.BaseStorageDao;
import ca.uhn.fhir.jpa.dao.DaoFailureUtil;
import ca.uhn.fhir.jpa.dao.EntriesToProcessMap;
import ca.uhn.fhir.jpa.dao.ITransactionProcessorVersionAdapter;
import ca.uhn.fhir.jpa.dao.IdSubstitutionMap;
import ca.uhn.fhir.jpa.dao.tx.HapiTransactionService;
import ca.uhn.fhir.jpa.delete.DeleteConflictUtil;
import ca.uhn.fhir.jpa.model.cross.IBasePersistedResource;
import ca.uhn.fhir.jpa.model.entity.ModelConfig;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import ca.uhn.fhir.jpa.model.search.StorageProcessingMessage;
import ca.uhn.fhir.jpa.searchparam.extractor.ResourceIndexedSearchParams;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryMatchResult;
import ca.uhn.fhir.jpa.searchparam.matcher.InMemoryResourceMatcher;
import ca.uhn.fhir.jpa.searchparam.matcher.SearchParamMatcher;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.PatchTypeEnum;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.api.server.storage.DeferredInterceptorBroadcasts;
import ca.uhn.fhir.rest.api.server.storage.TransactionDetails;
import ca.uhn.fhir.rest.param.ParameterUtil;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.MethodNotAllowedException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.rest.server.exceptions.PayloadTooLargeException;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.BaseResourceReturningMethodBinding;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.rest.server.servlet.ServletSubRequestDetails;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.rest.server.util.ServletRequestUtil;
import ca.uhn.fhir.util.AsyncUtil;
import ca.uhn.fhir.util.ElementUtil;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import ca.uhn.fhir.util.StopWatch;
import ca.uhn.fhir.util.StringUtil;
import ca.uhn.fhir.util.ThreadPoolUtil;
import ca.uhn.fhir.util.UrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class BaseTransactionProcessor {
    public static final String URN_PREFIX = "urn:";
    public static final String URN_PREFIX_ESCAPED = UrlUtil.escapeUrlParam((String)"urn:");
    public static final Pattern UNQUALIFIED_MATCH_URL_START = Pattern.compile("^[a-zA-Z0-9_]+=");
    private static final Logger ourLog = LoggerFactory.getLogger(BaseTransactionProcessor.class);
    public static final Pattern INVALID_PLACEHOLDER_PATTERN = Pattern.compile("[a-zA-Z]+:.*");
    private BaseStorageDao myDao;
    @Autowired
    private PlatformTransactionManager myTxManager;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private ITransactionProcessorVersionAdapter myVersionAdapter;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private IInterceptorBroadcaster myInterceptorBroadcaster;
    @Autowired
    private HapiTransactionService myHapiTransactionService;
    @Autowired
    private DaoConfig myDaoConfig;
    @Autowired
    private ModelConfig myModelConfig;
    @Autowired
    private InMemoryResourceMatcher myInMemoryResourceMatcher;
    @Autowired
    private SearchParamMatcher mySearchParamMatcher;
    private TaskExecutor myExecutor;
    @Autowired
    private IResourceVersionSvc myResourceVersionSvc;

    @VisibleForTesting
    public void setDaoConfig(DaoConfig theDaoConfig) {
        this.myDaoConfig = theDaoConfig;
    }

    public ITransactionProcessorVersionAdapter getVersionAdapter() {
        return this.myVersionAdapter;
    }

    @VisibleForTesting
    public void setVersionAdapter(ITransactionProcessorVersionAdapter theVersionAdapter) {
        this.myVersionAdapter = theVersionAdapter;
    }

    @PostConstruct
    public void start() {
        ourLog.trace("Starting transaction processor");
    }

    private TaskExecutor getTaskExecutor() {
        if (this.myExecutor == null) {
            if (this.myDaoConfig.getBundleBatchPoolSize() > 1) {
                this.myExecutor = ThreadPoolUtil.newThreadPool(this.myDaoConfig.getBundleBatchPoolSize(), this.myDaoConfig.getBundleBatchMaxPoolSize(), "bundle-batch-");
            } else {
                SyncTaskExecutor executor = new SyncTaskExecutor();
                this.myExecutor = executor;
            }
        }
        return this.myExecutor;
    }

    public <BUNDLE extends IBaseBundle> BUNDLE transaction(RequestDetails theRequestDetails, BUNDLE theRequest, boolean theNestedMode) {
        if (theRequestDetails != null && theRequestDetails.getServer() != null && this.myDao != null) {
            IServerInterceptor.ActionRequestDetails requestDetails = new IServerInterceptor.ActionRequestDetails(theRequestDetails, theRequest, "Bundle", null);
            this.myDao.notifyInterceptors(RestOperationTypeEnum.TRANSACTION, requestDetails);
        }
        String actionName = "Transaction";
        IBaseBundle response = this.processTransactionAsSubRequest(theRequestDetails, theRequest, actionName, theNestedMode);
        List entries = this.myVersionAdapter.getEntries(response);
        for (int i = 0; i < entries.size(); ++i) {
            if (!ElementUtil.isEmpty((IBase[])new IBase[]{(IBase)entries.get(i)})) continue;
            entries.remove(i);
            --i;
        }
        return (BUNDLE)response;
    }

    public IBaseBundle collection(RequestDetails theRequestDetails, IBaseBundle theRequest) {
        String transactionType = this.myVersionAdapter.getBundleType(theRequest);
        if (!Bundle.BundleType.COLLECTION.toCode().equals(transactionType)) {
            throw new InvalidRequestException(Msg.code((int)526) + "Can not process collection Bundle of type: " + transactionType);
        }
        ourLog.info("Beginning storing collection with {} resources", (Object)this.myVersionAdapter.getEntries(theRequest).size());
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
        txTemplate.setPropagationBehavior(3);
        Object resp = this.myVersionAdapter.createBundle(Bundle.BundleType.BATCHRESPONSE.toCode());
        ArrayList<IBaseResource> resources = new ArrayList<IBaseResource>();
        for (Object nextRequestEntry : this.myVersionAdapter.getEntries(theRequest)) {
            IBaseResource resource = this.myVersionAdapter.getResource((IBase)nextRequestEntry);
            resources.add(resource);
        }
        Object transactionBundle = this.myVersionAdapter.createBundle("transaction");
        for (IBaseResource next : resources) {
            Object entry = this.myVersionAdapter.addEntry(transactionBundle);
            this.myVersionAdapter.setResource(entry, next);
            this.myVersionAdapter.setRequestVerb(entry, "PUT");
            this.myVersionAdapter.setRequestUrl(entry, next.getIdElement().toUnqualifiedVersionless().getValue());
        }
        this.transaction(theRequestDetails, transactionBundle, false);
        return resp;
    }

    private void populateEntryWithOperationOutcome(BaseServerResponseException caughtEx, IBase nextEntry) {
        this.myVersionAdapter.populateEntryWithOperationOutcome(caughtEx, nextEntry);
    }

    private void handleTransactionCreateOrUpdateOutcome(IdSubstitutionMap idSubstitutions, Map<IIdType, DaoMethodOutcome> idToPersistedOutcome, IIdType nextResourceId, DaoMethodOutcome outcome, IBase newEntry, String theResourceType, IBaseResource theRes, RequestDetails theRequestDetails) {
        String prefer;
        PreferReturnEnum preferReturn;
        IIdType resourceId;
        IIdType newId = outcome.getId().toUnqualified();
        IIdType iIdType = resourceId = BaseTransactionProcessor.isPlaceholder(nextResourceId) ? nextResourceId : nextResourceId.toUnqualifiedVersionless();
        if (!newId.equals(resourceId)) {
            if (!nextResourceId.isEmpty()) {
                idSubstitutions.put(resourceId, newId);
            }
            if (BaseTransactionProcessor.isPlaceholder(resourceId)) {
                IIdType id = this.myContext.getVersion().newIdType();
                id.setValue(theResourceType + "/" + resourceId.getValue());
                idSubstitutions.put(id, newId);
            }
        }
        this.populateIdToPersistedOutcomeMap(idToPersistedOutcome, newId, outcome);
        if (outcome.getCreated().booleanValue()) {
            this.myVersionAdapter.setResponseStatus(newEntry, BaseTransactionProcessor.toStatusString(201));
        } else {
            this.myVersionAdapter.setResponseStatus(newEntry, BaseTransactionProcessor.toStatusString(200));
        }
        Date lastModifier = this.getLastModified(theRes);
        this.myVersionAdapter.setResponseLastModified(newEntry, lastModifier);
        if (theRequestDetails != null && (preferReturn = RestfulServerUtils.parsePreferHeader(null, (String)(prefer = theRequestDetails.getHeader("Prefer"))).getReturn()) != null && preferReturn == PreferReturnEnum.REPRESENTATION && outcome.getResource() != null) {
            outcome.fireResourceViewCallbacks();
            this.myVersionAdapter.setResource(newEntry, outcome.getResource());
        }
    }

    private void populateIdToPersistedOutcomeMap(Map<IIdType, DaoMethodOutcome> idToPersistedOutcome, IIdType newId, DaoMethodOutcome outcome) {
        if (idToPersistedOutcome.containsKey(newId)) {
            if (!(outcome instanceof LazyDaoMethodOutcome)) {
                idToPersistedOutcome.put(newId, outcome);
            }
        } else {
            idToPersistedOutcome.put(newId, outcome);
        }
    }

    private Date getLastModified(IBaseResource theRes) {
        return theRes.getMeta().getLastUpdated();
    }

    public void setDao(BaseStorageDao theDao) {
        this.myDao = theDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBaseBundle processTransactionAsSubRequest(RequestDetails theRequestDetails, IBaseBundle theRequest, String theActionName, boolean theNestedMode) {
        BaseStorageDao.markRequestAsProcessingSubRequest(theRequestDetails);
        try {
            IBaseBundle iBaseBundle = this.processTransaction(theRequestDetails, theRequest, theActionName, theNestedMode);
            return iBaseBundle;
        }
        finally {
            BaseStorageDao.clearRequestAsProcessingSubRequest(theRequestDetails);
        }
    }

    @VisibleForTesting
    public void setTxManager(PlatformTransactionManager theTxManager) {
        this.myTxManager = theTxManager;
    }

    private IBaseBundle batch(RequestDetails theRequestDetails, IBaseBundle theRequest, boolean theNestedMode) {
        ourLog.info("Beginning batch with {} resources", (Object)this.myVersionAdapter.getEntries(theRequest).size());
        long start = System.currentTimeMillis();
        TransactionTemplate txTemplate = new TransactionTemplate(this.myTxManager);
        txTemplate.setPropagationBehavior(3);
        Object response = this.myVersionAdapter.createBundle(Bundle.BundleType.BATCHRESPONSE.toCode());
        ConcurrentHashMap<Integer, Object> responseMap = new ConcurrentHashMap<Integer, Object>();
        List requestEntries = this.myVersionAdapter.getEntries(theRequest);
        int requestEntriesSize = requestEntries.size();
        ArrayList<RetriableBundleTask> getCalls = new ArrayList<RetriableBundleTask>();
        ArrayList<RetriableBundleTask> nonGetCalls = new ArrayList<RetriableBundleTask>();
        CountDownLatch completionLatch = new CountDownLatch(requestEntriesSize);
        for (int i = 0; i < requestEntriesSize; ++i) {
            IBase nextRequestEntry = (IBase)requestEntries.get(i);
            RetriableBundleTask retriableBundleTask = new RetriableBundleTask(completionLatch, theRequestDetails, responseMap, i, nextRequestEntry, theNestedMode);
            if (this.myVersionAdapter.getEntryRequestVerb(this.myContext, nextRequestEntry).equalsIgnoreCase("GET")) {
                getCalls.add(retriableBundleTask);
                continue;
            }
            nonGetCalls.add(retriableBundleTask);
        }
        nonGetCalls.forEach(RetriableBundleTask::run);
        getCalls.forEach(getCall -> this.getTaskExecutor().execute((Runnable)getCall));
        AsyncUtil.awaitLatchAndIgnoreInterrupt((CountDownLatch)completionLatch, (long)300L, (TimeUnit)TimeUnit.SECONDS);
        for (int i = 0; i < requestEntriesSize; ++i) {
            Object nextResponseEntry = responseMap.get(i);
            if (nextResponseEntry instanceof BaseServerResponseExceptionHolder) {
                BaseServerResponseExceptionHolder caughtEx = (BaseServerResponseExceptionHolder)nextResponseEntry;
                if (caughtEx.getException() == null) continue;
                Object nextEntry = this.myVersionAdapter.addEntry(response);
                this.populateEntryWithOperationOutcome(caughtEx.getException(), (IBase)nextEntry);
                this.myVersionAdapter.setResponseStatus(nextEntry, BaseTransactionProcessor.toStatusString(caughtEx.getException().getStatusCode()));
                continue;
            }
            this.myVersionAdapter.addEntry(response, (IBase)nextResponseEntry);
        }
        long delay = System.currentTimeMillis() - start;
        ourLog.info("Batch completed in {}ms", (Object)delay);
        return response;
    }

    @VisibleForTesting
    public void setHapiTransactionService(HapiTransactionService theHapiTransactionService) {
        this.myHapiTransactionService = theHapiTransactionService;
    }

    private IBaseBundle processTransaction(RequestDetails theRequestDetails, IBaseBundle theRequest, String theActionName, boolean theNestedMode) {
        this.validateDependencies();
        String transactionType = this.myVersionAdapter.getBundleType(theRequest);
        if (Bundle.BundleType.BATCH.toCode().equals(transactionType)) {
            return this.batch(theRequestDetails, theRequest, theNestedMode);
        }
        if (transactionType == null) {
            String message = "Transaction Bundle did not specify valid Bundle.type, assuming " + Bundle.BundleType.TRANSACTION.toCode();
            ourLog.warn(message);
            transactionType = Bundle.BundleType.TRANSACTION.toCode();
        }
        if (!Bundle.BundleType.TRANSACTION.toCode().equals(transactionType)) {
            throw new InvalidRequestException(Msg.code((int)527) + "Unable to process transaction where incoming Bundle.type = " + transactionType);
        }
        List<IBase> requestEntries = this.myVersionAdapter.getEntries(theRequest);
        int numberOfEntries = requestEntries.size();
        if (this.myDaoConfig.getMaximumTransactionBundleSize() != null && numberOfEntries > this.myDaoConfig.getMaximumTransactionBundleSize()) {
            throw new PayloadTooLargeException(Msg.code((int)528) + "Transaction Bundle Too large.  Transaction bundle contains " + numberOfEntries + " which exceedes the maximum permitted transaction bundle size of " + this.myDaoConfig.getMaximumTransactionBundleSize());
        }
        ourLog.debug("Beginning {} with {} resources", (Object)theActionName, (Object)numberOfEntries);
        TransactionDetails transactionDetails = new TransactionDetails();
        StopWatch transactionStopWatch = new StopWatch();
        for (int i = 0; i < numberOfEntries; ++i) {
            IBase nextReqEntry = (IBase)requestEntries.get(i);
            String verb = this.myVersionAdapter.getEntryRequestVerb(this.myContext, nextReqEntry);
            if (verb != null && this.isValidVerb(verb)) continue;
            throw new InvalidRequestException(Msg.code((int)529) + this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "transactionEntryHasInvalidVerb", new Object[]{verb, i}));
        }
        Object response = this.myVersionAdapter.createBundle(Bundle.BundleType.TRANSACTIONRESPONSE.toCode());
        ArrayList<IBase> getEntries = new ArrayList<IBase>();
        IdentityHashMap<IBase, Integer> originalRequestOrder = new IdentityHashMap<IBase, Integer>();
        for (int i = 0; i < requestEntries.size(); ++i) {
            IBase requestEntry = (IBase)requestEntries.get(i);
            originalRequestOrder.put(requestEntry, i);
            this.myVersionAdapter.addEntry(response);
            if (!this.myVersionAdapter.getEntryRequestVerb(this.myContext, requestEntry).equals("GET")) continue;
            getEntries.add(requestEntry);
        }
        HashSet<String> placeholderIds = new HashSet<String>();
        for (IBase nextEntry : requestEntries) {
            String fullUrl = this.myVersionAdapter.getFullUrl(nextEntry);
            if (!StringUtils.isNotBlank((CharSequence)fullUrl) || !fullUrl.startsWith(URN_PREFIX)) continue;
            placeholderIds.add(fullUrl);
        }
        requestEntries.sort(new TransactionSorter(placeholderIds));
        this.prepareThenExecuteTransactionWriteOperations(theRequestDetails, theActionName, transactionDetails, transactionStopWatch, (IBaseBundle)response, originalRequestOrder, requestEntries);
        this.doTransactionReadOperations(theRequestDetails, (IBaseBundle)response, (List<IBase>)getEntries, originalRequestOrder, transactionStopWatch, theNestedMode);
        if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_INFO, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails)) {
            String taskDurations = transactionStopWatch.formatTaskDurations();
            StorageProcessingMessage message = new StorageProcessingMessage();
            message.setMessage("Transaction timing:\n" + taskDurations);
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(StorageProcessingMessage.class, (Object)message);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
        }
        return response;
    }

    private void doTransactionReadOperations(RequestDetails theRequestDetails, IBaseBundle theResponse, List<IBase> theGetEntries, IdentityHashMap<IBase, Integer> theOriginalRequestOrder, StopWatch theTransactionStopWatch, boolean theNestedMode) {
        if (theGetEntries.size() > 0) {
            theTransactionStopWatch.startTask("Process " + theGetEntries.size() + " GET entries");
            for (IBase nextReqEntry : theGetEntries) {
                if (theNestedMode) {
                    throw new InvalidRequestException(Msg.code((int)530) + "Can not invoke read operation on nested transaction");
                }
                if (!(theRequestDetails instanceof ServletRequestDetails)) {
                    throw new MethodNotAllowedException(Msg.code((int)531) + "Can not call transaction GET methods from this context");
                }
                ServletRequestDetails srd = (ServletRequestDetails)theRequestDetails;
                Integer originalOrder = theOriginalRequestOrder.get(nextReqEntry);
                IBase nextRespEntry = (IBase)this.myVersionAdapter.getEntries(theResponse).get(originalOrder);
                ArrayListMultimap paramValues = ArrayListMultimap.create();
                String transactionUrl = this.extractTransactionUrlOrThrowException(nextReqEntry, "GET");
                ServletSubRequestDetails requestDetails = ServletRequestUtil.getServletSubRequestDetails((ServletRequestDetails)srd, (String)transactionUrl, (ArrayListMultimap)paramValues);
                String url = requestDetails.getRequestPath();
                BaseMethodBinding method = srd.getServer().determineResourceMethod((RequestDetails)requestDetails, url);
                if (method == null) {
                    throw new IllegalArgumentException(Msg.code((int)532) + "Unable to handle GET " + url);
                }
                if (StringUtils.isNotBlank((CharSequence)this.myVersionAdapter.getEntryRequestIfMatch(nextReqEntry))) {
                    requestDetails.addHeader("If-Match", this.myVersionAdapter.getEntryRequestIfMatch(nextReqEntry));
                }
                if (StringUtils.isNotBlank((CharSequence)this.myVersionAdapter.getEntryRequestIfNoneExist(nextReqEntry))) {
                    requestDetails.addHeader("If-None-Exist", this.myVersionAdapter.getEntryRequestIfNoneExist(nextReqEntry));
                }
                if (StringUtils.isNotBlank((CharSequence)this.myVersionAdapter.getEntryRequestIfNoneMatch(nextReqEntry))) {
                    requestDetails.addHeader("If-None-Match", this.myVersionAdapter.getEntryRequestIfNoneMatch(nextReqEntry));
                }
                Validate.isTrue((boolean)(method instanceof BaseResourceReturningMethodBinding), (String)"Unable to handle GET {}", (Object[])new Object[]{url});
                try {
                    BaseResourceReturningMethodBinding methodBinding = (BaseResourceReturningMethodBinding)method;
                    requestDetails.setRestOperationType(methodBinding.getRestOperationType());
                    IBaseResource resource = methodBinding.doInvokeServer((IRestfulServer)srd.getServer(), (RequestDetails)requestDetails);
                    if (paramValues.containsKey((Object)"_summary") || paramValues.containsKey((Object)"_content")) {
                        resource = this.filterNestedBundle((RequestDetails)requestDetails, resource);
                    }
                    this.myVersionAdapter.setResource(nextRespEntry, resource);
                    this.myVersionAdapter.setResponseStatus(nextRespEntry, BaseTransactionProcessor.toStatusString(200));
                }
                catch (NotModifiedException e) {
                    this.myVersionAdapter.setResponseStatus(nextRespEntry, BaseTransactionProcessor.toStatusString(304));
                }
                catch (BaseServerResponseException e) {
                    ourLog.info("Failure processing transaction GET {}: {}", (Object)url, (Object)e.toString());
                    this.myVersionAdapter.setResponseStatus(nextRespEntry, BaseTransactionProcessor.toStatusString(e.getStatusCode()));
                    this.populateEntryWithOperationOutcome(e, nextRespEntry);
                }
            }
            theTransactionStopWatch.endCurrentTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareThenExecuteTransactionWriteOperations(RequestDetails theRequestDetails, String theActionName, TransactionDetails theTransactionDetails, StopWatch theTransactionStopWatch, IBaseBundle theResponse, IdentityHashMap<IBase, Integer> theOriginalRequestOrder, List<IBase> theEntries) {
        EntriesToProcessMap entriesToProcess;
        TransactionWriteOperationsDetails writeOperationsDetails = null;
        if (this.haveWriteOperationsHooks(theRequestDetails)) {
            writeOperationsDetails = this.buildWriteOperationsDetails(theEntries);
            this.callWriteOperationsHook(Pointcut.STORAGE_TRANSACTION_WRITE_OPERATIONS_PRE, theRequestDetails, theTransactionDetails, writeOperationsDetails);
        }
        TransactionCallback txCallback = status -> {
            LinkedHashSet<IIdType> allIds = new LinkedHashSet<IIdType>();
            IdSubstitutionMap idSubstitutions = new IdSubstitutionMap();
            HashMap<IIdType, DaoMethodOutcome> idToPersistedOutcome = new HashMap<IIdType, DaoMethodOutcome>();
            EntriesToProcessMap retVal = this.doTransactionWriteOperations(theRequestDetails, theActionName, theTransactionDetails, allIds, idSubstitutions, idToPersistedOutcome, theResponse, theOriginalRequestOrder, theEntries, theTransactionStopWatch);
            theTransactionStopWatch.startTask("Commit writes to database");
            return retVal;
        };
        try {
            entriesToProcess = (EntriesToProcessMap)this.myHapiTransactionService.execute(theRequestDetails, theTransactionDetails, txCallback);
        }
        finally {
            if (this.haveWriteOperationsHooks(theRequestDetails)) {
                this.callWriteOperationsHook(Pointcut.STORAGE_TRANSACTION_WRITE_OPERATIONS_POST, theRequestDetails, theTransactionDetails, writeOperationsDetails);
            }
        }
        theTransactionStopWatch.endCurrentTask();
        for (Map.Entry<IBase, IIdType> nextEntry : entriesToProcess.entrySet()) {
            String responseLocation = nextEntry.getValue().toUnqualified().getValue();
            String responseEtag = nextEntry.getValue().getVersionIdPart();
            this.myVersionAdapter.setResponseLocation(nextEntry.getKey(), responseLocation);
            this.myVersionAdapter.setResponseETag(nextEntry.getKey(), responseEtag);
        }
    }

    private boolean haveWriteOperationsHooks(RequestDetails theRequestDetails) {
        return CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_TRANSACTION_WRITE_OPERATIONS_PRE, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails) || CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.STORAGE_TRANSACTION_WRITE_OPERATIONS_POST, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails);
    }

    private void callWriteOperationsHook(Pointcut thePointcut, RequestDetails theRequestDetails, TransactionDetails theTransactionDetails, TransactionWriteOperationsDetails theWriteOperationsDetails) {
        HookParams params = new HookParams().add(TransactionDetails.class, (Object)theTransactionDetails).add(TransactionWriteOperationsDetails.class, (Object)theWriteOperationsDetails);
        CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)thePointcut, (HookParams)params);
    }

    private TransactionWriteOperationsDetails buildWriteOperationsDetails(List<IBase> theEntries) {
        ArrayList<String> updateRequestUrls = new ArrayList<String>();
        ArrayList<String> conditionalCreateRequestUrls = new ArrayList<String>();
        for (IBase nextEntry : theEntries) {
            String requestUrl;
            String method = this.myVersionAdapter.getEntryRequestVerb(this.myContext, nextEntry);
            if ("PUT".equals(method)) {
                requestUrl = this.myVersionAdapter.getEntryRequestUrl(nextEntry);
                if (!StringUtils.isNotBlank((CharSequence)requestUrl)) continue;
                updateRequestUrls.add(requestUrl);
                continue;
            }
            if (!"POST".equals(method) || !StringUtils.isNotBlank((CharSequence)(requestUrl = this.myVersionAdapter.getEntryRequestIfNoneExist(nextEntry))) || !requestUrl.contains("?")) continue;
            conditionalCreateRequestUrls.add(requestUrl);
        }
        TransactionWriteOperationsDetails writeOperationsDetails = new TransactionWriteOperationsDetails();
        writeOperationsDetails.setUpdateRequestUrls(updateRequestUrls);
        writeOperationsDetails.setConditionalCreateRequestUrls(conditionalCreateRequestUrls);
        return writeOperationsDetails;
    }

    private boolean isValidVerb(String theVerb) {
        try {
            return Bundle.HTTPVerb.fromCode((String)theVerb) != null;
        }
        catch (FHIRException theE) {
            return false;
        }
    }

    private IBaseResource filterNestedBundle(RequestDetails theRequestDetails, IBaseResource theResource) {
        IParser p = this.myContext.newJsonParser();
        RestfulServerUtils.configureResponseParser((RequestDetails)theRequestDetails, (IParser)p);
        return p.parseResource(theResource.getClass(), p.encodeResourceToString(theResource));
    }

    protected void validateDependencies() {
        Validate.notNull((Object)this.myContext);
        Validate.notNull((Object)this.myTxManager);
    }

    private IIdType newIdType(String theValue) {
        return this.myContext.getVersion().newIdType().setValue(theValue);
    }

    @VisibleForTesting
    public void setModelConfig(ModelConfig theModelConfig) {
        this.myModelConfig = theModelConfig;
    }

    private void consolidateDuplicateConditionals(RequestDetails theRequestDetails, String theActionName, List<IBase> theEntries) {
        HashSet<CallSite> keysWithNoFullUrl = new HashSet<CallSite>();
        HashMap<CallSite, String> keyToUuid = new HashMap<CallSite, String>();
        int index = 0;
        int originalIndex = 0;
        while (index < theEntries.size()) {
            block18: {
                IBase nextReqEntry = theEntries.get(index);
                IBaseResource resource = this.myVersionAdapter.getResource(nextReqEntry);
                if (resource != null) {
                    Object conditionalUrl;
                    String verb = this.myVersionAdapter.getEntryRequestVerb(this.myContext, nextReqEntry);
                    String entryFullUrl = this.myVersionAdapter.getFullUrl(nextReqEntry);
                    String requestUrl = this.myVersionAdapter.getEntryRequestUrl(nextReqEntry);
                    String ifNoneExist = this.myVersionAdapter.getEntryRequestIfNoneExist(nextReqEntry);
                    boolean consolidateEntryCandidate = false;
                    switch (verb) {
                        case "PUT": {
                            int questionMarkIndex;
                            conditionalUrl = requestUrl;
                            if (!StringUtils.isNotBlank((CharSequence)requestUrl) || (questionMarkIndex = requestUrl.indexOf(63)) < 0 || requestUrl.length() <= questionMarkIndex + 1) break;
                            consolidateEntryCandidate = true;
                            break;
                        }
                        case "POST": {
                            conditionalUrl = ifNoneExist;
                            if (!StringUtils.isNotBlank((CharSequence)ifNoneExist) || !StringUtils.isBlank((CharSequence)entryFullUrl) && entryFullUrl.equals(requestUrl)) break;
                            consolidateEntryCandidate = true;
                            break;
                        }
                        default: {
                            break block18;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)conditionalUrl) && !((String)conditionalUrl).contains("?")) {
                        conditionalUrl = this.myContext.getResourceType(resource) + "?" + (String)conditionalUrl;
                    }
                    String key = verb + "|" + (String)conditionalUrl;
                    if (consolidateEntryCandidate) {
                        if (StringUtils.isBlank((CharSequence)entryFullUrl)) {
                            if (StringUtils.isNotBlank((CharSequence)conditionalUrl) && !keysWithNoFullUrl.add((CallSite)((Object)key))) {
                                throw new InvalidRequestException(Msg.code((int)2008) + "Unable to process " + theActionName + " - Request contains multiple anonymous entries (Bundle.entry.fullUrl not populated) with conditional URL: \"" + UrlUtil.sanitizeUrlPart((CharSequence)conditionalUrl) + "\". Does transaction request contain duplicates?");
                            }
                        } else if (!keyToUuid.containsKey(key)) {
                            keyToUuid.put((CallSite)((Object)key), entryFullUrl);
                        } else {
                            String msg = "Discarding transaction bundle entry " + originalIndex + " as it contained a duplicate conditional " + verb;
                            ourLog.info(msg);
                            if (CompositeInterceptorBroadcaster.hasHooks((Pointcut)Pointcut.JPA_PERFTRACE_WARNING, (IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails)) {
                                StorageProcessingMessage message = new StorageProcessingMessage().setMessage(msg);
                                HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequestDetails).addIfMatchesType(ServletRequestDetails.class, (Object)theRequestDetails).add(StorageProcessingMessage.class, (Object)message);
                                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails, (Pointcut)Pointcut.JPA_PERFTRACE_INFO, (HookParams)params);
                            }
                            theEntries.remove(index);
                            --index;
                            String existingUuid = (String)keyToUuid.get(key);
                            this.replaceReferencesInEntriesWithConsolidatedUUID(theEntries, entryFullUrl, existingUuid);
                        }
                    }
                }
            }
            ++index;
            ++originalIndex;
        }
    }

    private void replaceReferencesInEntriesWithConsolidatedUUID(List<IBase> theEntries, String theEntryFullUrl, String existingUuid) {
        for (IBase nextEntry : theEntries) {
            IBaseResource nextResource = this.myVersionAdapter.getResource(nextEntry);
            for (IBaseReference nextReference : this.myContext.newTerser().getAllPopulatedChildElementsOfType(nextResource, IBaseReference.class)) {
                String nextReferenceId = nextReference.getReferenceElement().getValue();
                if (StringUtils.isBlank((CharSequence)nextReferenceId) && nextReference.getResource() != null) {
                    nextReferenceId = nextReference.getResource().getIdElement().getValue();
                }
                if (!theEntryFullUrl.equals(nextReferenceId)) continue;
                nextReference.setReference(existingUuid);
                nextReference.setResource(null);
            }
        }
    }

    private IIdType getNextResourceIdFromBaseResource(IBaseResource theBaseResource, IBase theNextReqEntry, Set<IIdType> theAllIds) {
        IIdType nextResourceId = null;
        if (theBaseResource != null) {
            IIdType nextId;
            int colonIndex;
            nextResourceId = theBaseResource.getIdElement();
            String fullUrl = this.myVersionAdapter.getFullUrl(theNextReqEntry);
            if (StringUtils.isNotBlank((CharSequence)fullUrl)) {
                IIdType fullUrlIdType = this.newIdType(fullUrl);
                if (BaseTransactionProcessor.isPlaceholder(fullUrlIdType)) {
                    nextResourceId = fullUrlIdType;
                } else if (!nextResourceId.hasIdPart()) {
                    nextResourceId = fullUrlIdType;
                }
            }
            if (nextResourceId.hasIdPart() && !BaseTransactionProcessor.isPlaceholder(nextResourceId) && (colonIndex = nextResourceId.getIdPart().indexOf(58)) != -1 && INVALID_PLACEHOLDER_PATTERN.matcher(nextResourceId.getIdPart()).matches()) {
                throw new InvalidRequestException(Msg.code((int)533) + "Invalid placeholder ID found: " + nextResourceId.getIdPart() + " - Must be of the form 'urn:uuid:[uuid]' or 'urn:oid:[oid]'");
            }
            if (nextResourceId.hasIdPart() && !nextResourceId.hasResourceType() && !BaseTransactionProcessor.isPlaceholder(nextResourceId)) {
                nextResourceId = this.newIdType(this.toResourceName(theBaseResource.getClass()), nextResourceId.getIdPart());
                theBaseResource.setId(nextResourceId);
            }
            if (BaseTransactionProcessor.isPlaceholder(nextResourceId)) {
                if (!theAllIds.add(nextResourceId)) {
                    throw new InvalidRequestException(Msg.code((int)534) + this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "transactionContainsMultipleWithDuplicateId", new Object[]{nextResourceId}));
                }
            } else if (nextResourceId.hasResourceType() && nextResourceId.hasIdPart() && !theAllIds.add(nextId = nextResourceId.toUnqualifiedVersionless())) {
                throw new InvalidRequestException(Msg.code((int)535) + this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "transactionContainsMultipleWithDuplicateId", new Object[]{nextId}));
            }
        }
        return nextResourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntriesToProcessMap doTransactionWriteOperations(RequestDetails theRequest, String theActionName, TransactionDetails theTransactionDetails, Set<IIdType> theAllIds, IdSubstitutionMap theIdSubstitutions, Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome, IBaseBundle theResponse, IdentityHashMap<IBase, Integer> theOriginalRequestOrder, List<IBase> theEntries, StopWatch theTransactionStopWatch) {
        theTransactionDetails.beginAcceptingDeferredInterceptorBroadcasts(new Pointcut[]{Pointcut.STORAGE_PRECOMMIT_RESOURCE_CREATED, Pointcut.STORAGE_PRECOMMIT_RESOURCE_UPDATED, Pointcut.STORAGE_PRECOMMIT_RESOURCE_DELETED});
        try {
            HashSet<String> deletedResources = new HashSet<String>();
            DeleteConflictList deleteConflicts = new DeleteConflictList();
            EntriesToProcessMap entriesToProcess = new EntriesToProcessMap();
            HashSet<IIdType> nonUpdatedEntities = new HashSet<IIdType>();
            HashSet<IBasePersistedResource> updatedEntities = new HashSet<IBasePersistedResource>();
            HashMap<String, IIdType> conditionalUrlToIdMap = new HashMap<String, IIdType>();
            ArrayList<IBaseResource> updatedResources = new ArrayList<IBaseResource>();
            HashMap<String, Class<? extends IBaseResource>> conditionalRequestUrls = new HashMap<String, Class<? extends IBaseResource>>();
            this.consolidateDuplicateConditionals(theRequest, theActionName, theEntries);
            for (int i = 0; i < theEntries.size(); ++i) {
                if (i % 250 == 0) {
                    ourLog.debug("Processed {} non-GET entries out of {} in transaction", (Object)i, (Object)theEntries.size());
                }
                IBase iBase = theEntries.get(i);
                IBaseResource res = this.myVersionAdapter.getResource(iBase);
                IIdType nextResourceId = this.getNextResourceIdFromBaseResource(res, iBase, theAllIds);
                String verb = this.myVersionAdapter.getEntryRequestVerb(this.myContext, iBase);
                String resourceType = res != null ? this.myContext.getResourceType(res) : null;
                Integer order = theOriginalRequestOrder.get(iBase);
                IBase nextRespEntry = (IBase)this.myVersionAdapter.getEntries(theResponse).get(order);
                theTransactionStopWatch.startTask("Bundle.entry[" + i + "]: " + verb + " " + StringUtils.defaultString((String)resourceType));
                switch (verb) {
                    case "POST": {
                        String url = this.myVersionAdapter.getEntryRequestUrl(iBase);
                        if (StringUtils.isNotBlank((CharSequence)url)) {
                            this.extractAndVerifyTransactionUrlForEntry(iBase, verb);
                        }
                        this.validateResourcePresent(res, order, verb);
                        IFhirResourceDao resourceDao = this.getDaoOrThrowException(res.getClass());
                        res.setId((String)null);
                        String matchUrl = this.myVersionAdapter.getEntryRequestIfNoneExist(iBase);
                        matchUrl = BaseTransactionProcessor.performIdSubstitutionsInMatchUrl(theIdSubstitutions, matchUrl);
                        DaoMethodOutcome outcome = resourceDao.create(res, matchUrl, false, theTransactionDetails, theRequest);
                        this.setConditionalUrlToBeValidatedLater(conditionalUrlToIdMap, matchUrl, outcome.getId());
                        res.setId(outcome.getId());
                        if (nextResourceId != null) {
                            this.handleTransactionCreateOrUpdateOutcome(theIdSubstitutions, theIdToPersistedOutcome, nextResourceId, outcome, nextRespEntry, resourceType, res, theRequest);
                        }
                        entriesToProcess.put(nextRespEntry, outcome.getId());
                        if (!outcome.getCreated().booleanValue()) {
                            nonUpdatedEntities.add(outcome.getId());
                            break;
                        }
                        if (!StringUtils.isNotBlank((CharSequence)matchUrl)) break;
                        conditionalRequestUrls.put(matchUrl, res.getClass());
                        break;
                    }
                    case "DELETE": {
                        Object matchUrl;
                        String url = this.extractAndVerifyTransactionUrlForEntry(iBase, verb);
                        UrlUtil.UrlParts parts = UrlUtil.parseUrl((String)url);
                        IFhirResourceDao<? extends IBaseResource> dao = this.toDao(parts, verb, url);
                        int status = 204;
                        if (parts.getResourceId() != null) {
                            DaoMethodOutcome outcome;
                            IIdType deleteId = this.newIdType(parts.getResourceType(), parts.getResourceId());
                            if (!deletedResources.contains(deleteId.getValueAsString()) && (outcome = dao.delete(deleteId, deleteConflicts, theRequest, theTransactionDetails)).getEntity() != null) {
                                deletedResources.add(deleteId.getValueAsString());
                                entriesToProcess.put(nextRespEntry, outcome.getId());
                            }
                        } else {
                            matchUrl = parts.getResourceType() + "?" + parts.getParams();
                            matchUrl = BaseTransactionProcessor.performIdSubstitutionsInMatchUrl(theIdSubstitutions, (String)matchUrl);
                            DeleteMethodOutcome deleteOutcome = dao.deleteByUrl((String)matchUrl, deleteConflicts, theRequest);
                            this.setConditionalUrlToBeValidatedLater(conditionalUrlToIdMap, (String)matchUrl, deleteOutcome.getId());
                            List<ResourceTable> allDeleted = deleteOutcome.getDeletedEntities();
                            for (ResourceTable deleted : allDeleted) {
                                deletedResources.add(deleted.getIdDt().toUnqualifiedVersionless().getValueAsString());
                            }
                            if (allDeleted.isEmpty()) {
                                status = 204;
                            }
                            this.myVersionAdapter.setResponseOutcome(nextRespEntry, deleteOutcome.getOperationOutcome());
                        }
                        this.myVersionAdapter.setResponseStatus(nextRespEntry, BaseTransactionProcessor.toStatusString(status));
                        break;
                    }
                    case "PUT": {
                        Object matchUrl;
                        DaoMethodOutcome outcome;
                        this.validateResourcePresent(res, order, verb);
                        IFhirResourceDao resourceDao = this.getDaoOrThrowException(res.getClass());
                        String url = this.extractAndVerifyTransactionUrlForEntry(iBase, verb);
                        UrlUtil.UrlParts parts = UrlUtil.parseUrl((String)url);
                        if (StringUtils.isNotBlank((CharSequence)parts.getResourceId())) {
                            String version = null;
                            if (StringUtils.isNotBlank((CharSequence)this.myVersionAdapter.getEntryRequestIfMatch(iBase))) {
                                version = ParameterUtil.parseETagValue((String)this.myVersionAdapter.getEntryRequestIfMatch(iBase));
                            }
                            res.setId(this.newIdType(parts.getResourceType(), parts.getResourceId(), version));
                            outcome = resourceDao.update(res, null, false, false, theRequest, theTransactionDetails);
                        } else {
                            res.setId((String)null);
                            matchUrl = StringUtils.isNotBlank((CharSequence)parts.getParams()) ? parts.getResourceType() + "?" + parts.getParams() : parts.getResourceType();
                            matchUrl = BaseTransactionProcessor.performIdSubstitutionsInMatchUrl(theIdSubstitutions, (String)matchUrl);
                            outcome = resourceDao.update(res, (String)matchUrl, false, false, theRequest, theTransactionDetails);
                            this.setConditionalUrlToBeValidatedLater(conditionalUrlToIdMap, (String)matchUrl, outcome.getId());
                            if (Boolean.TRUE.equals(outcome.getCreated())) {
                                conditionalRequestUrls.put((String)matchUrl, res.getClass());
                            }
                        }
                        if (outcome.getCreated() == Boolean.FALSE || outcome.getCreated() == Boolean.TRUE && outcome.getId().getVersionIdPartAsLong() > 1L) {
                            updatedEntities.add(outcome.getEntity());
                            if (outcome.getResource() != null) {
                                updatedResources.add(outcome.getResource());
                            }
                        }
                        this.handleTransactionCreateOrUpdateOutcome(theIdSubstitutions, theIdToPersistedOutcome, nextResourceId, outcome, nextRespEntry, resourceType, res, theRequest);
                        entriesToProcess.put(nextRespEntry, outcome.getId());
                        break;
                    }
                    case "PATCH": {
                        this.validateResourcePresent(res, order, verb);
                        String url = this.extractAndVerifyTransactionUrlForEntry(iBase, verb);
                        UrlUtil.UrlParts parts = UrlUtil.parseUrl((String)url);
                        String matchUrl = this.toMatchUrl(iBase);
                        matchUrl = BaseTransactionProcessor.performIdSubstitutionsInMatchUrl(theIdSubstitutions, matchUrl);
                        String patchBody = null;
                        IBaseParameters patchBodyParameters = null;
                        PatchTypeEnum patchType = null;
                        if (res instanceof IBaseBinary) {
                            String contentType;
                            IBaseBinary binary = (IBaseBinary)res;
                            if (binary.getContent() != null && binary.getContent().length > 0) {
                                patchBody = StringUtil.toUtf8String((byte[])binary.getContent());
                            }
                            if ((patchType = PatchTypeEnum.forContentTypeOrThrowInvalidRequestException((FhirContext)this.myContext, (String)(contentType = binary.getContentType()))) == PatchTypeEnum.FHIR_PATCH_JSON || patchType == PatchTypeEnum.FHIR_PATCH_XML) {
                                String msg = this.myContext.getLocalizer().getMessage(BaseTransactionProcessor.class, "fhirPatchShouldNotUseBinaryResource", new Object[0]);
                                throw new InvalidRequestException(Msg.code((int)536) + msg);
                            }
                        } else if (res instanceof IBaseParameters) {
                            patchBodyParameters = (IBaseParameters)res;
                            patchType = PatchTypeEnum.FHIR_PATCH_JSON;
                        }
                        if (patchBodyParameters == null && StringUtils.isBlank(patchBody)) {
                            String msg = this.myContext.getLocalizer().getMessage(BaseTransactionProcessor.class, "missingPatchBody", new Object[0]);
                            throw new InvalidRequestException(Msg.code((int)537) + msg);
                        }
                        IFhirResourceDao<? extends IBaseResource> dao = this.toDao(parts, verb, url);
                        IIdType patchId = this.myContext.getVersion().newIdType().setValue(parts.getResourceId());
                        DaoMethodOutcome outcome = dao.patch(patchId, matchUrl, patchType, patchBody, patchBodyParameters, theRequest);
                        this.setConditionalUrlToBeValidatedLater(conditionalUrlToIdMap, matchUrl, outcome.getId());
                        updatedEntities.add(outcome.getEntity());
                        if (outcome.getResource() == null) break;
                        updatedResources.add(outcome.getResource());
                        break;
                    }
                    case "GET": {
                        break;
                    }
                    default: {
                        throw new InvalidRequestException(Msg.code((int)538) + "Unable to handle verb in transaction: " + verb);
                    }
                }
                theTransactionStopWatch.endCurrentTask();
            }
            this.checkForDeleteConflicts(deleteConflicts, deletedResources, updatedResources);
            theIdToPersistedOutcome.entrySet().forEach(idAndOutcome -> theTransactionDetails.addResolvedResourceId((IIdType)idAndOutcome.getKey(), ((DaoMethodOutcome)((Object)((Object)((Object)idAndOutcome.getValue())))).getPersistentId()));
            this.resolveReferencesThenSaveAndIndexResources(theRequest, theTransactionDetails, theIdSubstitutions, theIdToPersistedOutcome, theTransactionStopWatch, entriesToProcess, nonUpdatedEntities, updatedEntities);
            theTransactionStopWatch.endCurrentTask();
            theTransactionStopWatch.startTask("Flush writes to database");
            this.flushSession(theIdToPersistedOutcome);
            theTransactionStopWatch.endCurrentTask();
            if (conditionalRequestUrls.size() > 0) {
                theTransactionStopWatch.startTask("Check for conflicts in conditional resources");
            }
            if (!this.myDaoConfig.isMassIngestionMode()) {
                this.validateNoDuplicates(theRequest, theActionName, conditionalRequestUrls, theIdToPersistedOutcome.values());
            }
            theTransactionStopWatch.endCurrentTask();
            if (conditionalUrlToIdMap.size() > 0) {
                theTransactionStopWatch.startTask("Check that all conditionally created/updated entities actually match their conditionals.");
            }
            if (!this.myDaoConfig.isMassIngestionMode()) {
                this.validateAllInsertsMatchTheirConditionalUrls(theIdToPersistedOutcome, conditionalUrlToIdMap, theRequest);
            }
            theTransactionStopWatch.endCurrentTask();
            for (IIdType iIdType : theAllIds) {
                IIdType replacement = theIdSubstitutions.getForSource(iIdType);
                if (replacement == null || replacement.equals(iIdType)) continue;
                ourLog.debug("Placeholder resource ID \"{}\" was replaced with permanent ID \"{}\"", (Object)iIdType, (Object)replacement);
            }
            ListMultimap deferredBroadcastEvents = theTransactionDetails.endAcceptingDeferredInterceptorBroadcasts();
            for (Map.Entry nextEntry : deferredBroadcastEvents.entries()) {
                Pointcut nextPointcut = (Pointcut)nextEntry.getKey();
                HookParams nextParams = (HookParams)nextEntry.getValue();
                CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)nextPointcut, (HookParams)nextParams);
            }
            DeferredInterceptorBroadcasts deferredInterceptorBroadcasts = new DeferredInterceptorBroadcasts(deferredBroadcastEvents);
            HookParams params = new HookParams().add(RequestDetails.class, (Object)theRequest).addIfMatchesType(ServletRequestDetails.class, (Object)theRequest).add(DeferredInterceptorBroadcasts.class, (Object)deferredInterceptorBroadcasts).add(TransactionDetails.class, (Object)theTransactionDetails).add(IBaseBundle.class, (Object)theResponse);
            CompositeInterceptorBroadcaster.doCallHooks((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequest, (Pointcut)Pointcut.STORAGE_TRANSACTION_PROCESSED, (HookParams)params);
            theTransactionDetails.deferredBroadcastProcessingFinished();
            EntriesToProcessMap entriesToProcessMap = entriesToProcess;
            return entriesToProcessMap;
        }
        finally {
            if (theTransactionDetails.isAcceptingDeferredInterceptorBroadcasts()) {
                theTransactionDetails.endAcceptingDeferredInterceptorBroadcasts();
            }
        }
    }

    private void setConditionalUrlToBeValidatedLater(Map<String, IIdType> theConditionalUrlToIdMap, String theMatchUrl, IIdType theId) {
        if (!StringUtils.isBlank((CharSequence)theMatchUrl)) {
            theConditionalUrlToIdMap.put(theMatchUrl, theId);
        }
    }

    private void validateAllInsertsMatchTheirConditionalUrls(Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome, Map<String, IIdType> conditionalUrlToIdMap, RequestDetails theRequest) {
        conditionalUrlToIdMap.entrySet().stream().filter(entry -> entry.getKey() != null).forEach(entry -> {
            String matchUrl = (String)entry.getKey();
            IIdType value = (IIdType)entry.getValue();
            DaoMethodOutcome daoMethodOutcome = (DaoMethodOutcome)((Object)((Object)theIdToPersistedOutcome.get(value)));
            if (daoMethodOutcome != null && !daoMethodOutcome.isNop() && daoMethodOutcome.getResource() != null) {
                InMemoryMatchResult match = this.mySearchParamMatcher.match(matchUrl, daoMethodOutcome.getResource(), theRequest);
                if (ourLog.isDebugEnabled()) {
                    ourLog.debug("Checking conditional URL [{}] against resource with ID [{}]: Supported?:[{}], Matched?:[{}]", new Object[]{matchUrl, value, match.supported(), match.matched()});
                }
                if (match.supported() && !match.matched()) {
                    throw new PreconditionFailedException(Msg.code((int)539) + "Invalid conditional URL \"" + matchUrl + "\". The given resource is not matched by this URL.");
                }
            }
        });
    }

    private void checkForDeleteConflicts(DeleteConflictList theDeleteConflicts, Set<String> theDeletedResources, List<IBaseResource> theUpdatedResources) {
        Iterator<DeleteConflict> iter = theDeleteConflicts.iterator();
        while (iter.hasNext()) {
            List referencesInSource;
            boolean sourceStillReferencesTarget;
            DeleteConflict nextDeleteConflict = iter.next();
            if (theDeletedResources.contains(nextDeleteConflict.getSourceId().toUnqualifiedVersionless().getValue())) {
                iter.remove();
                continue;
            }
            String sourceId = nextDeleteConflict.getSourceId().toUnqualifiedVersionless().getValue();
            String targetId = nextDeleteConflict.getTargetId().toUnqualifiedVersionless().getValue();
            Optional<IBaseResource> updatedSource = theUpdatedResources.stream().filter(t -> sourceId.equals(t.getIdElement().toUnqualifiedVersionless().getValue())).findFirst();
            if (!updatedSource.isPresent() || (sourceStillReferencesTarget = (referencesInSource = this.myContext.newTerser().getAllResourceReferences(updatedSource.get())).stream().anyMatch(t -> targetId.equals(t.getResourceReference().getReferenceElement().toUnqualifiedVersionless().getValue())))) continue;
            iter.remove();
        }
        DeleteConflictUtil.validateDeleteConflictsEmptyOrThrowException(this.myContext, theDeleteConflicts);
    }

    private void resolveReferencesThenSaveAndIndexResources(RequestDetails theRequest, TransactionDetails theTransactionDetails, IdSubstitutionMap theIdSubstitutions, Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome, StopWatch theTransactionStopWatch, EntriesToProcessMap entriesToProcess, Set<IIdType> nonUpdatedEntities, Set<IBasePersistedResource> updatedEntities) {
        Set<IBaseReference> referencesToAutoVersion;
        FhirTerser terser = this.myContext.newTerser();
        theTransactionStopWatch.startTask("Index " + theIdToPersistedOutcome.size() + " resources");
        IdentityHashMap<DaoMethodOutcome, Set<IBaseReference>> deferredIndexesForAutoVersioning = null;
        int i = 0;
        for (DaoMethodOutcome daoMethodOutcome : theIdToPersistedOutcome.values()) {
            IBaseResource nextResource;
            if (i++ % 250 == 0) {
                ourLog.debug("Have indexed {} entities out of {} in transaction", (Object)i, (Object)theIdToPersistedOutcome.values().size());
            }
            if (daoMethodOutcome.isNop() || (nextResource = daoMethodOutcome.getResource()) == null) continue;
            referencesToAutoVersion = BaseStorageDao.extractReferencesToAutoVersion(this.myContext, this.myModelConfig, nextResource);
            if (referencesToAutoVersion.isEmpty()) {
                this.resolveReferencesThenSaveAndIndexResource(theRequest, theTransactionDetails, theIdSubstitutions, theIdToPersistedOutcome, entriesToProcess, nonUpdatedEntities, updatedEntities, terser, daoMethodOutcome, nextResource, referencesToAutoVersion);
                continue;
            }
            if (deferredIndexesForAutoVersioning == null) {
                deferredIndexesForAutoVersioning = new IdentityHashMap<DaoMethodOutcome, Set<IBaseReference>>();
            }
            deferredIndexesForAutoVersioning.put(daoMethodOutcome, referencesToAutoVersion);
        }
        if (deferredIndexesForAutoVersioning != null) {
            for (Map.Entry entry : deferredIndexesForAutoVersioning.entrySet()) {
                DaoMethodOutcome nextOutcome = (DaoMethodOutcome)((Object)entry.getKey());
                referencesToAutoVersion = (Set<IBaseReference>)entry.getValue();
                IBaseResource nextResource = nextOutcome.getResource();
                this.resolveReferencesThenSaveAndIndexResource(theRequest, theTransactionDetails, theIdSubstitutions, theIdToPersistedOutcome, entriesToProcess, nonUpdatedEntities, updatedEntities, terser, nextOutcome, nextResource, referencesToAutoVersion);
            }
        }
    }

    private void resolveReferencesThenSaveAndIndexResource(RequestDetails theRequest, TransactionDetails theTransactionDetails, IdSubstitutionMap theIdSubstitutions, Map<IIdType, DaoMethodOutcome> theIdToPersistedOutcome, EntriesToProcessMap entriesToProcess, Set<IIdType> nonUpdatedEntities, Set<IBasePersistedResource> updatedEntities, FhirTerser terser, DaoMethodOutcome nextOutcome, IBaseResource nextResource, Set<IBaseReference> theReferencesToAutoVersion) {
        List allRefs = terser.getAllResourceReferences(nextResource);
        for (ResourceReferenceInfo nextRef : allRefs) {
            DaoMethodOutcome outcome;
            IBaseReference resourceReference = nextRef.getResourceReference();
            IIdType nextId = resourceReference.getReferenceElement();
            IIdType newId = null;
            if (!nextId.hasIdPart()) {
                IIdType targetId;
                if (resourceReference.getResource() == null || (targetId = resourceReference.getResource().getIdElement()).getValue() == null || targetId.getValue().startsWith("#")) continue;
                if (theIdSubstitutions.containsTarget(targetId)) {
                    newId = targetId;
                } else {
                    throw new InternalErrorException(Msg.code((int)540) + "References by resource with no reference ID are not supported in DAO layer");
                }
            }
            if (newId != null || theIdSubstitutions.containsSource(nextId)) {
                if (newId == null) {
                    newId = theIdSubstitutions.getForSource(nextId);
                }
                if (newId == null) continue;
                ourLog.debug(" * Replacing resource ref {} with {}", (Object)nextId, (Object)newId);
                this.addRollbackReferenceRestore(theTransactionDetails, resourceReference);
                if (theReferencesToAutoVersion.contains(resourceReference)) {
                    resourceReference.setReference(newId.getValue());
                    resourceReference.setResource(null);
                    continue;
                }
                resourceReference.setReference(newId.toVersionless().getValue());
                resourceReference.setResource(null);
                continue;
            }
            if (nextId.getValue().startsWith(URN_PREFIX)) {
                throw new InvalidRequestException(Msg.code((int)541) + "Unable to satisfy placeholder ID " + nextId.getValue() + " found in element named '" + nextRef.getName() + "' within resource of type: " + nextResource.getIdElement().getResourceType());
            }
            ResourcePersistentIdMap resourceVersionMap = this.myResourceVersionSvc.getLatestVersionIdsForResourceIds(RequestPartitionId.allPartitions(), theReferencesToAutoVersion.stream().map(IBaseReference::getReferenceElement).collect(Collectors.toList()));
            for (IBaseReference baseRef : theReferencesToAutoVersion) {
                IIdType id = baseRef.getReferenceElement();
                if (!resourceVersionMap.containsKey(id) && this.myDaoConfig.isAutoCreatePlaceholderReferenceTargets()) {
                    String newRef = id.withVersion("1").getValue();
                    id.setValue(newRef);
                    continue;
                }
                theTransactionDetails.addResolvedResourceId(id, resourceVersionMap.getResourcePersistentId(id));
            }
            if (!theReferencesToAutoVersion.contains(resourceReference) || (outcome = theIdToPersistedOutcome.get(nextId)) == null || outcome.isNop() || Boolean.TRUE.equals(outcome.getCreated())) continue;
            this.addRollbackReferenceRestore(theTransactionDetails, resourceReference);
            resourceReference.setReference(nextId.getValue());
            resourceReference.setResource(null);
        }
        Class uriType = this.myContext.getElementDefinition("uri").getImplementingClass();
        List allUris = terser.getAllPopulatedChildElementsOfType(nextResource, uriType);
        for (IPrimitiveType nextRef : allUris) {
            if (nextRef instanceof IIdType) continue;
            String nextUriString = nextRef.getValueAsString();
            if (theIdSubstitutions.containsSource(nextUriString)) {
                IIdType newId = theIdSubstitutions.getForSource(nextUriString);
                ourLog.debug(" * Replacing resource ref {} with {}", (Object)nextUriString, (Object)newId);
                String existingValue = nextRef.getValueAsString();
                theTransactionDetails.addRollbackUndoAction(() -> nextRef.setValueAsString(existingValue));
                nextRef.setValueAsString(newId.toVersionless().getValue());
                continue;
            }
            ourLog.debug(" * Reference [{}] does not exist in bundle", (Object)nextUriString);
        }
        IPrimitiveType deletedInstantOrNull = nextResource instanceof IAnyResource ? (IPrimitiveType)ResourceMetadataKeyEnum.DELETED_AT.get((IAnyResource)nextResource) : (IPrimitiveType)ResourceMetadataKeyEnum.DELETED_AT.get((IResource)nextResource);
        Date deletedTimestampOrNull = deletedInstantOrNull != null ? (Date)deletedInstantOrNull.getValue() : null;
        IFhirResourceDao<?> dao = this.myDaoRegistry.getResourceDao(nextResource.getClass());
        IJpaDao jpaDao = (IJpaDao)((Object)dao);
        IBasePersistedResource updateOutcome = null;
        if (updatedEntities.contains(nextOutcome.getEntity())) {
            boolean forceUpdateVersion = !theReferencesToAutoVersion.isEmpty();
            updateOutcome = jpaDao.updateInternal(theRequest, nextResource, true, forceUpdateVersion, nextOutcome.getEntity(), nextResource.getIdElement(), nextOutcome.getPreviousResource(), theTransactionDetails);
        } else if (!nonUpdatedEntities.contains(nextOutcome.getId())) {
            updateOutcome = jpaDao.updateEntity(theRequest, nextResource, nextOutcome.getEntity(), deletedTimestampOrNull, true, false, theTransactionDetails, false, true);
        }
        if (updateOutcome != null) {
            IIdType newId = updateOutcome.getIdDt();
            IIdType entryId = entriesToProcess.getIdWithVersionlessComparison(newId);
            if (entryId != null && !StringUtils.equals((CharSequence)entryId.getValue(), (CharSequence)newId.getValue())) {
                entryId.setValue(newId.getValue());
            }
            nextOutcome.setId(newId);
            IIdType target = theIdSubstitutions.getForSource(newId);
            if (target != null) {
                target.setValue(newId.getValue());
            }
        }
    }

    private void addRollbackReferenceRestore(TransactionDetails theTransactionDetails, IBaseReference resourceReference) {
        String existingValue = resourceReference.getReferenceElement().getValue();
        theTransactionDetails.addRollbackUndoAction(() -> resourceReference.setReference(existingValue));
    }

    private void validateNoDuplicates(RequestDetails theRequest, String theActionName, Map<String, Class<? extends IBaseResource>> conditionalRequestUrls, Collection<DaoMethodOutcome> thePersistedOutcomes) {
        IdentityHashMap resourceToIndexedParams = new IdentityHashMap(thePersistedOutcomes.size());
        thePersistedOutcomes.stream().filter(t -> !t.isNop()).filter(t -> t.getEntity() instanceof ResourceTable).filter(t -> t.getEntity().getDeleted() == null).filter(t -> t.getResource() != null).forEach(t -> resourceToIndexedParams.put(t.getResource(), new ResourceIndexedSearchParams((ResourceTable)t.getEntity())));
        for (Map.Entry<String, Class<? extends IBaseResource>> nextEntry : conditionalRequestUrls.entrySet()) {
            String matchUrl = nextEntry.getKey();
            if (!StringUtils.isNotBlank((CharSequence)matchUrl)) continue;
            if (matchUrl.startsWith("?") || !matchUrl.contains("?") && UNQUALIFIED_MATCH_URL_START.matcher(matchUrl).find()) {
                StringBuilder b = new StringBuilder();
                b.append(this.myContext.getResourceType(nextEntry.getValue()));
                if (!matchUrl.startsWith("?")) {
                    b.append("?");
                }
                b.append(matchUrl);
                matchUrl = b.toString();
            }
            if (!this.myInMemoryResourceMatcher.canBeEvaluatedInMemory(matchUrl).supported()) continue;
            int counter = 0;
            for (Map.Entry entries : resourceToIndexedParams.entrySet()) {
                ResourceIndexedSearchParams indexedParams = (ResourceIndexedSearchParams)entries.getValue();
                IBaseResource resource = (IBaseResource)entries.getKey();
                String resourceType = this.myContext.getResourceType(resource);
                if (!matchUrl.startsWith(resourceType + "?") || !this.myInMemoryResourceMatcher.match(matchUrl, resource, indexedParams).matched() || ++counter <= 1) continue;
                throw new InvalidRequestException(Msg.code((int)542) + "Unable to process " + theActionName + " - Request would cause multiple resources to match URL: \"" + matchUrl + "\". Does transaction request contain duplicates?");
            }
        }
    }

    protected abstract void flushSession(Map<IIdType, DaoMethodOutcome> var1);

    private void validateResourcePresent(IBaseResource theResource, Integer theOrder, String theVerb) {
        if (theResource == null) {
            String msg = this.myContext.getLocalizer().getMessage(BaseTransactionProcessor.class, "missingMandatoryResource", new Object[]{theVerb, theOrder});
            throw new InvalidRequestException(Msg.code((int)543) + msg);
        }
    }

    private IIdType newIdType(String theResourceType, String theResourceId, String theVersion) {
        IdType id = new IdType(theResourceType, theResourceId, theVersion);
        return this.myContext.getVersion().newIdType().setValue(id.getValue());
    }

    private IIdType newIdType(String theToResourceName, String theIdPart) {
        return this.newIdType(theToResourceName, theIdPart, null);
    }

    @VisibleForTesting
    public void setDaoRegistry(DaoRegistry theDaoRegistry) {
        this.myDaoRegistry = theDaoRegistry;
    }

    private IFhirResourceDao getDaoOrThrowException(Class<? extends IBaseResource> theClass) {
        IFhirResourceDao<? extends IBaseResource> dao = this.myDaoRegistry.getResourceDaoOrNull(theClass);
        if (dao == null) {
            TreeSet<String> types = new TreeSet<String>(this.myDaoRegistry.getRegisteredDaoTypes());
            String type = this.myContext.getResourceType(theClass);
            String msg = this.myContext.getLocalizer().getMessage(BaseTransactionProcessor.class, "unsupportedResourceType", new Object[]{type, ((Object)types).toString()});
            throw new InvalidRequestException(Msg.code((int)544) + msg);
        }
        return dao;
    }

    private String toResourceName(Class<? extends IBaseResource> theResourceType) {
        return this.myContext.getResourceType(theResourceType);
    }

    public void setContext(FhirContext theContext) {
        this.myContext = theContext;
    }

    private String extractAndVerifyTransactionUrlForEntry(IBase theEntry, String theVerb) {
        String url = this.extractTransactionUrlOrThrowException(theEntry, theVerb);
        if (!this.isValidResourceTypeUrl(url)) {
            ourLog.debug("Invalid url. Should begin with a resource type: {}", (Object)url);
            String msg = this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "transactionInvalidUrl", new Object[]{theVerb, url});
            throw new InvalidRequestException(Msg.code((int)2006) + msg);
        }
        return url;
    }

    private boolean isValidResourceTypeUrl(@Nonnull String theUrl) {
        if (UrlUtil.isAbsolute((String)theUrl)) {
            return false;
        }
        int queryStringIndex = theUrl.indexOf("?");
        String url = queryStringIndex > 0 ? theUrl.substring(0, theUrl.indexOf("?")) : theUrl;
        String[] parts = url.startsWith("/") ? url.substring(1).split("/") : url.split("/");
        Set allResourceTypes = this.myContext.getResourceTypes();
        return allResourceTypes.contains(parts[0]);
    }

    private String extractTransactionUrlOrThrowException(IBase nextEntry, String verb) {
        String url = this.myVersionAdapter.getEntryRequestUrl(nextEntry);
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new InvalidRequestException(Msg.code((int)545) + this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "transactionMissingUrl", new Object[]{verb}));
        }
        return url;
    }

    private IFhirResourceDao<? extends IBaseResource> toDao(UrlUtil.UrlParts theParts, String theVerb, String theUrl) {
        RuntimeResourceDefinition resType;
        try {
            resType = this.myContext.getResourceDefinition(theParts.getResourceType());
        }
        catch (DataFormatException e) {
            String msg = this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "transactionInvalidUrl", new Object[]{theVerb, theUrl});
            throw new InvalidRequestException(Msg.code((int)546) + msg);
        }
        IFhirResourceDao dao = null;
        if (resType != null) {
            dao = this.myDaoRegistry.getResourceDao(resType.getImplementingClass());
        }
        if (dao == null) {
            String msg = this.myContext.getLocalizer().getMessage(BaseStorageDao.class, "transactionInvalidUrl", new Object[]{theVerb, theUrl});
            throw new InvalidRequestException(Msg.code((int)547) + msg);
        }
        return dao;
    }

    private String toMatchUrl(IBase theEntry) {
        String url;
        UrlUtil.UrlParts parts;
        String verb = this.myVersionAdapter.getEntryRequestVerb(this.myContext, theEntry);
        if (verb.equals("POST")) {
            return this.myVersionAdapter.getEntryIfNoneExist(theEntry);
        }
        if (verb.equals("PATCH")) {
            return this.myVersionAdapter.getEntryRequestIfMatch(theEntry);
        }
        if ((verb.equals("PUT") || verb.equals("DELETE")) && StringUtils.isBlank((CharSequence)(parts = UrlUtil.parseUrl((String)(url = this.extractTransactionUrlOrThrowException(theEntry, verb)))).getResourceId())) {
            return parts.getResourceType() + "?" + parts.getParams();
        }
        return null;
    }

    public static boolean isPlaceholder(IIdType theId) {
        if (theId != null && theId.getValue() != null) {
            return theId.getValue().startsWith("urn:oid:") || theId.getValue().startsWith("urn:uuid:");
        }
        return false;
    }

    private static String toStatusString(int theStatusCode) {
        return theStatusCode + " " + StringUtils.defaultString((String)((String)Constants.HTTP_STATUS_NAMES.get(theStatusCode)));
    }

    public static String performIdSubstitutionsInMatchUrl(IdSubstitutionMap theIdSubstitutions, String theMatchUrl) {
        Object matchUrl = theMatchUrl;
        if (StringUtils.isNotBlank((CharSequence)matchUrl) && !theIdSubstitutions.isEmpty()) {
            int startIdx = ((String)matchUrl).indexOf(63);
            while (startIdx != -1) {
                int searchFrom;
                int equalsIdx;
                int endIdx = ((String)matchUrl).indexOf(38, startIdx + 1);
                if (endIdx == -1) {
                    endIdx = ((String)matchUrl).length();
                }
                if ((equalsIdx = ((String)matchUrl).indexOf(61, startIdx + 1)) == -1) {
                    searchFrom = ((String)matchUrl).length();
                } else if (equalsIdx >= endIdx) {
                    searchFrom = ((String)matchUrl).length();
                } else {
                    boolean isUrnEscaped;
                    String paramValue = ((String)matchUrl).substring(equalsIdx + 1, endIdx);
                    boolean isUrn = BaseTransactionProcessor.isUrn(paramValue);
                    boolean bl = isUrnEscaped = !isUrn && BaseTransactionProcessor.isUrnEscaped(paramValue);
                    if (isUrn || isUrnEscaped) {
                        IIdType replacement;
                        if (isUrnEscaped) {
                            paramValue = UrlUtil.unescape((String)paramValue);
                        }
                        if ((replacement = theIdSubstitutions.getForSource(paramValue)) != null) {
                            String replacementValue = replacement.hasVersionIdPart() ? replacement.toVersionless().getValue() : replacement.getValue();
                            matchUrl = ((String)matchUrl).substring(0, equalsIdx + 1) + replacementValue + ((String)matchUrl).substring(endIdx);
                            searchFrom = equalsIdx + 1 + replacementValue.length();
                        } else {
                            searchFrom = endIdx;
                        }
                    } else {
                        searchFrom = endIdx;
                    }
                }
                if (searchFrom >= ((String)matchUrl).length()) break;
                startIdx = ((String)matchUrl).indexOf(38, searchFrom);
            }
        }
        return matchUrl;
    }

    private static boolean isUrn(@Nonnull String theId) {
        return theId.startsWith(URN_PREFIX);
    }

    private static boolean isUrnEscaped(@Nonnull String theId) {
        return theId.startsWith(URN_PREFIX_ESCAPED);
    }

    public class RetriableBundleTask
    implements Runnable {
        private final CountDownLatch myCompletedLatch;
        private final RequestDetails myRequestDetails;
        private final IBase myNextReqEntry;
        private final Map<Integer, Object> myResponseMap;
        private final int myResponseOrder;
        private final boolean myNestedMode;
        private BaseServerResponseException myLastSeenException;

        protected RetriableBundleTask(CountDownLatch theCompletedLatch, RequestDetails theRequestDetails, Map<Integer, Object> theResponseMap, int theResponseOrder, IBase theNextReqEntry, boolean theNestedMode) {
            this.myCompletedLatch = theCompletedLatch;
            this.myRequestDetails = theRequestDetails;
            this.myNextReqEntry = theNextReqEntry;
            this.myResponseMap = theResponseMap;
            this.myResponseOrder = theResponseOrder;
            this.myNestedMode = theNestedMode;
            this.myLastSeenException = null;
        }

        private void processBatchEntry() {
            Object subRequestBundle = BaseTransactionProcessor.this.myVersionAdapter.createBundle(Bundle.BundleType.TRANSACTION.toCode());
            BaseTransactionProcessor.this.myVersionAdapter.addEntry(subRequestBundle, this.myNextReqEntry);
            IBaseBundle nextResponseBundle = BaseTransactionProcessor.this.processTransactionAsSubRequest(this.myRequestDetails, (IBaseBundle)subRequestBundle, "Batch sub-request", this.myNestedMode);
            IBase subResponseEntry = (IBase)BaseTransactionProcessor.this.myVersionAdapter.getEntries(nextResponseBundle).get(0);
            this.myResponseMap.put(this.myResponseOrder, subResponseEntry);
            if (BaseTransactionProcessor.this.myVersionAdapter.getResource(subResponseEntry) == null) {
                IBase nextResponseBundleFirstEntry = (IBase)BaseTransactionProcessor.this.myVersionAdapter.getEntries(nextResponseBundle).get(0);
                this.myResponseMap.put(this.myResponseOrder, nextResponseBundleFirstEntry);
            }
        }

        private boolean processBatchEntryWithRetry() {
            int maxAttempts = 3;
            int attempt = 1;
            while (true) {
                try {
                    this.processBatchEntry();
                    return true;
                }
                catch (BaseServerResponseException e) {
                    this.myLastSeenException = e;
                    return false;
                }
                catch (Throwable t) {
                    this.myLastSeenException = new InternalErrorException(t);
                    if (!DaoFailureUtil.isTagStorageFailure(t) || attempt >= maxAttempts) {
                        ourLog.error("Failure during BATCH sub transaction processing", t);
                        return false;
                    }
                    ++attempt;
                    continue;
                }
                break;
            }
        }

        @Override
        public void run() {
            boolean success = this.processBatchEntryWithRetry();
            if (!success) {
                this.populateResponseMapWithLastSeenException();
            }
            ourLog.debug("processing batch for {} is completed", (Object)BaseTransactionProcessor.this.myVersionAdapter.getEntryRequestUrl(this.myNextReqEntry));
            this.myCompletedLatch.countDown();
        }

        private void populateResponseMapWithLastSeenException() {
            BaseServerResponseExceptionHolder caughtEx = new BaseServerResponseExceptionHolder();
            caughtEx.setException(this.myLastSeenException);
            this.myResponseMap.put(this.myResponseOrder, caughtEx);
        }
    }

    private static class BaseServerResponseExceptionHolder {
        private BaseServerResponseException myException;

        private BaseServerResponseExceptionHolder() {
        }

        public BaseServerResponseException getException() {
            return this.myException;
        }

        public void setException(BaseServerResponseException myException) {
            this.myException = myException;
        }
    }

    public class TransactionSorter
    implements Comparator<IBase> {
        private final Set<String> myPlaceholderIds;

        public TransactionSorter(Set<String> thePlaceholderIds) {
            this.myPlaceholderIds = thePlaceholderIds;
        }

        @Override
        public int compare(IBase theO1, IBase theO2) {
            int o2;
            int o1 = this.toOrder(theO1);
            if (o1 == (o2 = this.toOrder(theO2))) {
                String matchUrl1 = BaseTransactionProcessor.this.toMatchUrl(theO1);
                String matchUrl2 = BaseTransactionProcessor.this.toMatchUrl(theO2);
                if (StringUtils.isBlank((CharSequence)matchUrl1) && StringUtils.isBlank((CharSequence)matchUrl2)) {
                    return 0;
                }
                if (StringUtils.isBlank((CharSequence)matchUrl1)) {
                    return -1;
                }
                if (StringUtils.isBlank((CharSequence)matchUrl2)) {
                    return 1;
                }
                boolean match1containsSubstitutions = false;
                boolean match2containsSubstitutions = false;
                for (String nextPlaceholder : this.myPlaceholderIds) {
                    if (matchUrl1.contains(nextPlaceholder)) {
                        match1containsSubstitutions = true;
                    }
                    if (!matchUrl2.contains(nextPlaceholder)) continue;
                    match2containsSubstitutions = true;
                }
                if (match1containsSubstitutions && match2containsSubstitutions) {
                    return 0;
                }
                if (!match1containsSubstitutions && !match2containsSubstitutions) {
                    return 0;
                }
                if (match1containsSubstitutions) {
                    return 1;
                }
                return -1;
            }
            return o1 - o2;
        }

        private int toOrder(IBase theO1) {
            int o1 = 0;
            if (BaseTransactionProcessor.this.myVersionAdapter.getEntryRequestVerb(BaseTransactionProcessor.this.myContext, theO1) != null) {
                switch (BaseTransactionProcessor.this.myVersionAdapter.getEntryRequestVerb(BaseTransactionProcessor.this.myContext, theO1)) {
                    case "DELETE": {
                        o1 = 1;
                        break;
                    }
                    case "POST": {
                        o1 = 2;
                        break;
                    }
                    case "PUT": {
                        o1 = 3;
                        break;
                    }
                    case "PATCH": {
                        o1 = 4;
                        break;
                    }
                    case "GET": {
                        o1 = 5;
                        break;
                    }
                    default: {
                        o1 = 0;
                    }
                }
            }
            return o1;
        }
    }
}

