/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.dao;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.hl7.fhir.instance.model.api.IIdType;

public class IdSubstitutionMap {
    private final Map<Entry, Entry> myMap = new HashMap<Entry, Entry>();
    private final Multimap<Entry, Entry> myReverseMap = MultimapBuilder.hashKeys().arrayListValues().build();

    public boolean containsSource(IIdType theId) {
        if (theId.isLocal()) {
            return false;
        }
        return this.myMap.containsKey(new Entry(theId));
    }

    public boolean containsSource(String theId) {
        return this.myMap.containsKey(new Entry(theId));
    }

    public boolean containsTarget(IIdType theId) {
        return this.myReverseMap.containsKey((Object)new Entry(theId));
    }

    public boolean containsTarget(String theId) {
        return this.myReverseMap.containsKey((Object)new Entry(theId));
    }

    public IIdType getForSource(IIdType theId) {
        Entry target = this.myMap.get(new Entry(theId));
        if (target != null) {
            assert (target.myId != null);
            return target.myId;
        }
        return null;
    }

    public IIdType getForSource(String theId) {
        Entry target = this.myMap.get(new Entry(theId));
        if (target != null) {
            assert (target.myId != null);
            return target.myId;
        }
        return null;
    }

    public List<Pair<IIdType, IIdType>> entrySet() {
        return this.myMap.entrySet().stream().map(t -> Pair.of((Object)((Entry)t.getKey()).myId, (Object)((Entry)t.getValue()).myId)).collect(Collectors.toList());
    }

    public void put(IIdType theSource, IIdType theTarget) {
        this.myMap.put(new Entry(theSource), new Entry(theTarget));
        this.myReverseMap.put((Object)new Entry(theTarget), (Object)new Entry(theSource));
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    static String toVersionlessValue(IIdType theId) {
        boolean isPlaceholder = theId.getValue().startsWith("urn:");
        String unversionedId = isPlaceholder || !theId.hasBaseUrl() && !theId.hasVersionIdPart() || !theId.hasResourceType() ? theId.getValue() : theId.toUnqualifiedVersionless().getValue();
        return unversionedId;
    }

    private static class Entry {
        private final String myUnversionedId;
        private final IIdType myId;

        private Entry(String theId) {
            this.myId = null;
            this.myUnversionedId = theId;
        }

        private Entry(IIdType theId) {
            String unversionedId;
            this.myUnversionedId = unversionedId = IdSubstitutionMap.toVersionlessValue(theId);
            this.myId = theId;
        }

        public boolean equals(Object theOther) {
            String otherUnversionedId;
            return theOther instanceof Entry && this.myUnversionedId.equals(otherUnversionedId = ((Entry)theOther).myUnversionedId);
        }

        public int hashCode() {
            return this.myUnversionedId.hashCode();
        }
    }
}

