/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.graphql;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.rest.annotation.GraphQL;
import ca.uhn.fhir.rest.annotation.GraphQLQueryBody;
import ca.uhn.fhir.rest.annotation.GraphQLQueryUrl;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Initialize;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.UnclassifiedServerFailureException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.utils.GraphQLEngine;
import org.hl7.fhir.utilities.graphql.IGraphQLEngine;
import org.hl7.fhir.utilities.graphql.IGraphQLStorageServices;
import org.hl7.fhir.utilities.graphql.ObjectValue;
import org.hl7.fhir.utilities.graphql.Package;
import org.hl7.fhir.utilities.graphql.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(GraphQLProvider.class);
    private final Supplier<IGraphQLEngine> myEngineFactory;
    private final IGraphQLStorageServices myStorageServices;

    public GraphQLProvider(IGraphQLStorageServices theStorageServices) {
        this(FhirContext.forR4(), null, theStorageServices);
    }

    public GraphQLProvider(@Nonnull FhirContext theFhirContext, @Nullable IValidationSupport theValidationSupport, @Nonnull IGraphQLStorageServices theStorageServices) {
        Validate.notNull((Object)theFhirContext, (String)"theFhirContext must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theStorageServices, (String)"theStorageServices must not be null", (Object[])new Object[0]);
        switch (theFhirContext.getVersion().getVersion()) {
            case DSTU3: {
                IValidationSupport validationSupport = theValidationSupport;
                validationSupport = (IValidationSupport)ObjectUtils.defaultIfNull((Object)validationSupport, (Object)new DefaultProfileValidationSupport(theFhirContext));
                HapiWorkerContext workerContext = new HapiWorkerContext(theFhirContext, validationSupport);
                this.myEngineFactory = () -> new org.hl7.fhir.dstu3.utils.GraphQLEngine((IWorkerContext)workerContext);
                break;
            }
            case R4: {
                IValidationSupport validationSupport = theValidationSupport;
                validationSupport = (IValidationSupport)ObjectUtils.defaultIfNull((Object)validationSupport, (Object)new DefaultProfileValidationSupport(theFhirContext));
                org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext workerContext = new org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext(theFhirContext, validationSupport);
                this.myEngineFactory = () -> new org.hl7.fhir.r4.utils.GraphQLEngine((org.hl7.fhir.r4.context.IWorkerContext)workerContext);
                break;
            }
            case R5: {
                IValidationSupport validationSupport = theValidationSupport;
                validationSupport = (IValidationSupport)ObjectUtils.defaultIfNull((Object)validationSupport, (Object)new DefaultProfileValidationSupport(theFhirContext));
                org.hl7.fhir.r5.hapi.ctx.HapiWorkerContext workerContext = new org.hl7.fhir.r5.hapi.ctx.HapiWorkerContext(theFhirContext, validationSupport);
                this.myEngineFactory = () -> new GraphQLEngine((org.hl7.fhir.r5.context.IWorkerContext)workerContext);
                break;
            }
            default: {
                throw new UnsupportedOperationException(Msg.code((int)1143) + "GraphQL not supported for version: " + theFhirContext.getVersion().getVersion());
            }
        }
        this.myStorageServices = theStorageServices;
    }

    @Description(value="This operation invokes a GraphQL expression for fetching an joining a graph of resources, returning them in a custom format.")
    @GraphQL(type=RequestTypeEnum.GET)
    public String processGraphQlGetRequest(ServletRequestDetails theRequestDetails, @IdParam IIdType theId, @GraphQLQueryUrl String theQueryUrl) {
        if (theQueryUrl != null) {
            return this.processGraphQLRequest(theRequestDetails, theId, theQueryUrl);
        }
        throw new InvalidRequestException(Msg.code((int)1144) + "Unable to parse empty GraphQL expression");
    }

    @Description(value="This operation invokes a GraphQL expression for fetching an joining a graph of resources, returning them in a custom format.")
    @GraphQL(type=RequestTypeEnum.POST)
    public String processGraphQlPostRequest(ServletRequestDetails theServletRequestDetails, RequestDetails theRequestDetails, @IdParam IIdType theId, @GraphQLQueryBody String theQueryBody) {
        if (theQueryBody != null) {
            return this.processGraphQLRequest(theServletRequestDetails, theId, theQueryBody);
        }
        throw new InvalidRequestException(Msg.code((int)1145) + "Unable to parse empty GraphQL expression");
    }

    public String processGraphQLRequest(ServletRequestDetails theRequestDetails, IIdType theId, String theQuery) {
        Package parsedGraphQLRequest;
        try {
            parsedGraphQLRequest = Parser.parse((String)theQuery);
        }
        catch (Exception e) {
            throw new InvalidRequestException(Msg.code((int)1146) + "Unable to parse GraphQL Expression: " + e);
        }
        return this.processGraphQLRequest(theRequestDetails, theId, parsedGraphQLRequest);
    }

    protected String processGraphQLRequest(ServletRequestDetails theRequestDetails, IIdType theId, Package parsedGraphQLRequest) {
        IGraphQLEngine engine = this.myEngineFactory.get();
        engine.setAppInfo((Object)theRequestDetails);
        engine.setServices(this.myStorageServices);
        engine.setGraphQL(parsedGraphQLRequest);
        try {
            if (theId != null) {
                IBaseResource focus = this.myStorageServices.lookup((Object)theRequestDetails, theId.getResourceType(), theId.getIdPart());
                engine.setFocus(focus);
            }
            engine.execute();
            StringBuilder outputBuilder = new StringBuilder();
            ObjectValue output = engine.getOutput();
            output.write(outputBuilder, Integer.valueOf(0), "\n");
            return outputBuilder.toString();
        }
        catch (Exception e) {
            StringBuilder b = new StringBuilder();
            b.append("Unable to execute GraphQL Expression: ");
            int statusCode = 500;
            if (e instanceof BaseServerResponseException) {
                b.append("HTTP ");
                statusCode = ((BaseServerResponseException)((Object)e)).getStatusCode();
                b.append(statusCode);
                b.append(" ");
            } else {
                ourLog.error("Failure during GraphQL processing", (Throwable)e);
            }
            b.append(e.getMessage());
            throw new UnclassifiedServerFailureException(statusCode, Msg.code((int)1147) + b);
        }
    }

    @Initialize
    public void initialize(RestfulServer theServer) {
        ourLog.trace("Initializing GraphQL provider");
        if (!theServer.getFhirContext().getVersion().getVersion().isEqualOrNewerThan(FhirVersionEnum.DSTU3)) {
            throw new ConfigurationException(Msg.code((int)1148) + "Can not use " + this.getClass().getName() + " provider on server with FHIR " + theServer.getFhirContext().getVersion().getVersion().name() + " context");
        }
    }
}

