/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.interceptor.api.Hook;
import ca.uhn.fhir.interceptor.api.Interceptor;
import ca.uhn.fhir.interceptor.api.Pointcut;
import ca.uhn.fhir.jpa.interceptor.validation.IRepositoryValidatingRule;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Interceptor
public class RepositoryValidatingInterceptor {
    private static final Logger ourLog = LoggerFactory.getLogger(RepositoryValidatingInterceptor.class);
    private final Multimap<String, IRepositoryValidatingRule> myRules = ArrayListMultimap.create();
    private FhirContext myFhirContext;

    public RepositoryValidatingInterceptor() {
    }

    public RepositoryValidatingInterceptor(FhirContext theFhirContext, List<IRepositoryValidatingRule> theRules) {
        this.setFhirContext(theFhirContext);
        this.setRules(theRules);
    }

    public void setFhirContext(FhirContext theFhirContext) {
        this.myFhirContext = theFhirContext;
    }

    public void setRules(List<IRepositoryValidatingRule> theRules) {
        Validate.notNull(theRules, (String)"theRules must not be null", (Object[])new Object[0]);
        this.myRules.clear();
        for (IRepositoryValidatingRule next : theRules) {
            this.myRules.put((Object)next.getResourceType(), (Object)next);
        }
        String rulesDescription = "RepositoryValidatingInterceptor has rules:\n" + this.describeRules();
        ourLog.info(rulesDescription);
    }

    @Nonnull
    public String describeRules() {
        return " * " + this.myRules.values().stream().distinct().map(t -> t.toString()).sorted().collect(Collectors.joining("\n * "));
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_CREATED)
    void create(RequestDetails theRequestDetails, IBaseResource theResource) {
        this.handle(theRequestDetails, theResource);
    }

    @Hook(value=Pointcut.STORAGE_PRESTORAGE_RESOURCE_UPDATED)
    void update(RequestDetails theRequestDetails, IBaseResource theOldResource, IBaseResource theNewResource) {
        this.handle(theRequestDetails, theNewResource);
    }

    private void handle(RequestDetails theRequestDetails, IBaseResource theNewResource) {
        Validate.notNull((Object)this.myFhirContext, (String)"No FhirContext has been set for this interceptor of type: %s", (Object[])new Object[]{this.getClass()});
        if (!this.isPlaceholderResource(theNewResource)) {
            String resourceType = this.myFhirContext.getResourceType(theNewResource);
            Collection rules = this.myRules.get((Object)resourceType);
            for (IRepositoryValidatingRule nextRule : rules) {
                IRepositoryValidatingRule.RuleEvaluation outcome = nextRule.evaluate(theRequestDetails, theNewResource);
                if (outcome.isPasses()) continue;
                this.handleFailure(outcome);
            }
        }
    }

    private boolean isPlaceholderResource(IBaseResource theNewResource) {
        return ExtensionUtil.hasExtension((IBase)theNewResource, (String)"http://hapifhir.io/fhir/StructureDefinition/resource-placeholder");
    }

    protected void handleFailure(IRepositoryValidatingRule.RuleEvaluation theOutcome) {
        if (theOutcome.getOperationOutcome() != null) {
            String firstIssue = OperationOutcomeUtil.getFirstIssueDetails((FhirContext)this.myFhirContext, (IBaseOperationOutcome)theOutcome.getOperationOutcome());
            throw new PreconditionFailedException(Msg.code((int)574) + firstIssue, theOutcome.getOperationOutcome());
        }
        throw new PreconditionFailedException(Msg.code((int)575) + theOutcome.getFailureDescription());
    }
}

