/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.interceptor.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.interceptor.api.IInterceptorBroadcaster;
import ca.uhn.fhir.jpa.interceptor.validation.BaseTypedRule;
import ca.uhn.fhir.jpa.interceptor.validation.IRepositoryValidatingRule;
import ca.uhn.fhir.jpa.validation.ValidatorPolicyAdvisor;
import ca.uhn.fhir.jpa.validation.ValidatorResourceFetcher;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.interceptor.ValidationResultEnrichingInterceptor;
import ca.uhn.fhir.rest.server.util.CompositeInterceptorBroadcaster;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidatorModule;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.common.hapi.validation.validator.FhirInstanceValidator;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;

class RequireValidationRule
extends BaseTypedRule {
    private final FhirInstanceValidator myValidator;
    private final IInterceptorBroadcaster myInterceptorBroadcaster;
    private ResultSeverityEnum myRejectOnSeverity = ResultSeverityEnum.ERROR;
    private List<TagOnSeverity> myTagOnSeverity = Collections.emptyList();

    public RequireValidationRule(FhirContext theFhirContext, String theType, IValidationSupport theValidationSupport, ValidatorResourceFetcher theValidatorResourceFetcher, ValidatorPolicyAdvisor theValidationPolicyAdvisor, IInterceptorBroadcaster theInterceptorBroadcaster) {
        super(theFhirContext, theType);
        this.myInterceptorBroadcaster = theInterceptorBroadcaster;
        this.myValidator = new FhirInstanceValidator(theValidationSupport);
        this.myValidator.setValidatorResourceFetcher((IValidatorResourceFetcher)theValidatorResourceFetcher);
        this.myValidator.setValidatorPolicyAdvisor((IValidationPolicyAdvisor)theValidationPolicyAdvisor);
        this.myValidator.setBestPracticeWarningLevel(BestPracticeWarningLevel.Warning);
    }

    void setBestPracticeWarningLevel(BestPracticeWarningLevel theBestPracticeWarningLevel) {
        this.myValidator.setBestPracticeWarningLevel(theBestPracticeWarningLevel);
    }

    @Override
    @Nonnull
    public IRepositoryValidatingRule.RuleEvaluation evaluate(RequestDetails theRequestDetails, @Nonnull IBaseResource theResource) {
        FhirValidator validator = this.getFhirContext().newValidator();
        validator.setInterceptorBroadcaster(CompositeInterceptorBroadcaster.newCompositeBroadcaster((IInterceptorBroadcaster)this.myInterceptorBroadcaster, (RequestDetails)theRequestDetails));
        validator.registerValidatorModule((IValidatorModule)this.myValidator);
        ValidationResult outcome = validator.validateWithResult(theResource);
        for (SingleValidationMessage next : outcome.getMessages()) {
            if (next.getSeverity().ordinal() >= ResultSeverityEnum.ERROR.ordinal() && this.myRejectOnSeverity != null && this.myRejectOnSeverity.ordinal() <= next.getSeverity().ordinal()) {
                return IRepositoryValidatingRule.RuleEvaluation.forFailure((IRepositoryValidatingRule)this, outcome.toOperationOutcome());
            }
            for (TagOnSeverity nextTagOnSeverity : this.myTagOnSeverity) {
                if (next.getSeverity().ordinal() < nextTagOnSeverity.getSeverity()) continue;
                theResource.getMeta().addTag().setSystem(nextTagOnSeverity.getTagSystem()).setCode(nextTagOnSeverity.getTagCode());
            }
        }
        ValidationResultEnrichingInterceptor.addValidationResultToRequestDetails((RequestDetails)theRequestDetails, (ValidationResult)outcome);
        return IRepositoryValidatingRule.RuleEvaluation.forSuccess(this);
    }

    public void rejectOnSeverity(ResultSeverityEnum theSeverity) {
        this.myRejectOnSeverity = theSeverity;
    }

    public void tagOnSeverity(ResultSeverityEnum theSeverity, String theTagSystem, String theTagCode) {
        Validate.notNull((Object)theSeverity, (String)"theSeverity must not be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)theTagSystem, (String)"theTagSystem must not be null or empty", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)theTagCode, (String)"theTagCode must not be null or empty", (Object[])new Object[0]);
        if (this.myTagOnSeverity.isEmpty()) {
            this.myTagOnSeverity = new ArrayList<TagOnSeverity>();
        }
        this.myTagOnSeverity.add(new TagOnSeverity(theSeverity.ordinal(), theTagSystem, theTagCode));
    }

    public void dontReject() {
        this.myRejectOnSeverity = null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("resourceType", (Object)this.getResourceType()).append("rejectOnSeverity", (Object)this.myRejectOnSeverity).append("tagOnSeverity", this.myTagOnSeverity).toString();
    }

    public FhirInstanceValidator getValidator() {
        return this.myValidator;
    }

    public void setAllowAnyExtensions() {
        this.myValidator.setAnyExtensionsAllowed(true);
    }

    private static class TagOnSeverity {
        private final int mySeverity;
        private final String myTagSystem;
        private final String myTagCode;

        private TagOnSeverity(int theSeverity, String theTagSystem, String theTagCode) {
            this.mySeverity = theSeverity;
            this.myTagSystem = theTagSystem;
            this.myTagCode = theTagCode;
        }

        public int getSeverity() {
            return this.mySeverity;
        }

        public String getTagSystem() {
            return this.myTagSystem;
        }

        public String getTagCode() {
            return this.myTagCode;
        }

        public String toString() {
            return ResultSeverityEnum.values()[this.mySeverity].name() + "/" + this.myTagSystem + "/" + this.myTagCode;
        }
    }
}

