/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.subscription.channel.subscription;

import ca.uhn.fhir.jpa.subscription.channel.api.IChannelReceiver;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;

public class BroadcastingSubscribableChannelWrapper
extends AbstractSubscribableChannel
implements IChannelReceiver {
    private final IChannelReceiver myWrappedChannel;
    private final MessageHandler myHandler = message -> this.send(message);

    public BroadcastingSubscribableChannelWrapper(IChannelReceiver theChannel) {
        theChannel.subscribe(this.myHandler);
        this.myWrappedChannel = theChannel;
    }

    public SubscribableChannel getWrappedChannel() {
        return this.myWrappedChannel;
    }

    protected boolean sendInternal(Message<?> theMessage, long timeout) {
        Set subscribers = this.getSubscribers();
        Validate.isTrue((subscribers.size() > 0 ? 1 : 0) != 0, (String)"Channel has zero subscribers", (Object[])new Object[0]);
        for (MessageHandler next : subscribers) {
            next.handleMessage(theMessage);
        }
        return true;
    }

    public void destroy() throws Exception {
        this.myWrappedChannel.destroy();
        this.myWrappedChannel.unsubscribe(this.myHandler);
    }

    public void addInterceptor(ChannelInterceptor interceptor) {
        super.addInterceptor(interceptor);
        this.myWrappedChannel.addInterceptor(interceptor);
    }

    @Override
    public String getName() {
        return this.myWrappedChannel.getName();
    }
}

