/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.api.model.TranslationQuery;
import ca.uhn.fhir.jpa.model.entity.TagTypeEnum;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class MemoryCacheService {
    @Autowired
    DaoConfig myDaoConfig;
    private EnumMap<CacheEnum, Cache<?, ?>> myCaches;

    @PostConstruct
    public void start() {
        this.myCaches = new EnumMap(CacheEnum.class);
        for (CacheEnum next : CacheEnum.values()) {
            int maximumSize;
            long timeoutSeconds;
            switch (next) {
                case CONCEPT_TRANSLATION: 
                case CONCEPT_TRANSLATION_REVERSE: {
                    timeoutSeconds = TimeUnit.SECONDS.convert(this.myDaoConfig.getTranslationCachesExpireAfterWriteInMinutes(), TimeUnit.MINUTES);
                    maximumSize = 10000;
                    break;
                }
                default: {
                    timeoutSeconds = TimeUnit.SECONDS.convert(1L, TimeUnit.MINUTES);
                    maximumSize = 10000;
                    if (!this.myDaoConfig.isMassIngestionMode()) break;
                    timeoutSeconds = TimeUnit.SECONDS.convert(50L, TimeUnit.MINUTES);
                    maximumSize = 100000;
                }
            }
            Cache nextCache = Caffeine.newBuilder().expireAfterWrite(timeoutSeconds, TimeUnit.SECONDS).maximumSize((long)maximumSize).build();
            this.myCaches.put(next, nextCache);
        }
    }

    public <K, T> T get(CacheEnum theCache, K theKey, Function<K, T> theSupplier) {
        assert (theCache.myKeyType.isAssignableFrom(theKey.getClass()));
        Cache<K, T> cache = this.getCache(theCache);
        return (T)cache.get(theKey, theSupplier);
    }

    public <K, T> T getThenPutAfterCommit(CacheEnum theCache, K theKey, Function<K, T> theSupplier) {
        assert (theCache.myKeyType.isAssignableFrom(theKey.getClass()));
        Cache<K, T> cache = this.getCache(theCache);
        Object retVal = cache.getIfPresent(theKey);
        if (retVal == null) {
            retVal = theSupplier.apply(theKey);
            this.putAfterCommit(theCache, theKey, retVal);
        }
        return (T)retVal;
    }

    public <K, V> V getIfPresent(CacheEnum theCache, K theKey) {
        assert (theCache.myKeyType.isAssignableFrom(theKey.getClass()));
        return (V)this.getCache(theCache).getIfPresent(theKey);
    }

    public <K, V> void put(CacheEnum theCache, K theKey, V theValue) {
        assert (theCache.myKeyType.isAssignableFrom(theKey.getClass()));
        this.getCache(theCache).put(theKey, theValue);
    }

    public <K, V> void putAfterCommit(final CacheEnum theCache, final K theKey, final V theValue) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    MemoryCacheService.this.put(theCache, theKey, theValue);
                }
            });
        } else {
            this.put(theCache, theKey, theValue);
        }
    }

    public <K, V> Map<K, V> getAllPresent(CacheEnum theCache, Iterable<K> theKeys) {
        return this.getCache(theCache).getAllPresent(theKeys);
    }

    public void invalidateAllCaches() {
        this.myCaches.values().forEach(Cache::invalidateAll);
    }

    private <K, T> Cache<K, T> getCache(CacheEnum theCache) {
        return this.myCaches.get((Object)theCache);
    }

    public long getEstimatedSize(CacheEnum theCache) {
        return this.getCache(theCache).estimatedSize();
    }

    public static enum CacheEnum {
        TAG_DEFINITION(TagDefinitionCacheKey.class),
        RESOURCE_LOOKUP(String.class),
        FORCED_ID_TO_PID(String.class),
        PID_TO_FORCED_ID(Long.class),
        CONCEPT_TRANSLATION(TranslationQuery.class),
        MATCH_URL(String.class),
        CONCEPT_TRANSLATION_REVERSE(TranslationQuery.class),
        RESOURCE_CONDITIONAL_CREATE_VERSION(Long.class),
        HISTORY_COUNT(HistoryCountKey.class);

        private final Class<?> myKeyType;

        private CacheEnum(Class<?> theKeyType) {
            this.myKeyType = theKeyType;
        }
    }

    public static class HistoryCountKey {
        private final String myTypeName;
        private final Long myInstanceId;
        private final int myHashCode;

        private HistoryCountKey(String theTypeName, Long theInstanceId) {
            this.myTypeName = theTypeName;
            this.myInstanceId = theInstanceId;
            this.myHashCode = new HashCodeBuilder().append((Object)this.myTypeName).append((Object)this.myInstanceId).toHashCode();
        }

        public static HistoryCountKey forSystem() {
            return new HistoryCountKey(null, null);
        }

        public static HistoryCountKey forType(@Nonnull String theType) {
            assert (StringUtils.isNotBlank((CharSequence)theType));
            return new HistoryCountKey(theType, null);
        }

        public static HistoryCountKey forInstance(@Nonnull Long theInstanceId) {
            assert (theInstanceId != null);
            return new HistoryCountKey(null, theInstanceId);
        }

        public boolean equals(Object theO) {
            boolean retVal = false;
            if (theO instanceof HistoryCountKey) {
                HistoryCountKey that = (HistoryCountKey)theO;
                retVal = new EqualsBuilder().append((Object)this.myTypeName, (Object)that.myTypeName).append((Object)this.myInstanceId, (Object)that.myInstanceId).isEquals();
            }
            return retVal;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }

    public static class TagDefinitionCacheKey {
        private final TagTypeEnum myType;
        private final String mySystem;
        private final String myCode;
        private final int myHashCode;

        public TagDefinitionCacheKey(TagTypeEnum theType, String theSystem, String theCode) {
            this.myType = theType;
            this.mySystem = theSystem;
            this.myCode = theCode;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myType).append((Object)this.mySystem).append((Object)this.myCode).toHashCode();
        }

        public boolean equals(Object theO) {
            boolean retVal = false;
            if (theO instanceof TagDefinitionCacheKey) {
                TagDefinitionCacheKey that = (TagDefinitionCacheKey)theO;
                retVal = new EqualsBuilder().append((Object)this.myType, (Object)that.myType).append((Object)this.mySystem, (Object)that.mySystem).append((Object)this.myCode, (Object)that.myCode).isEquals();
            }
            return retVal;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

