/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.validation.ValidationSettings;
import java.util.List;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.constants.BindingKind;
import org.hl7.fhir.r5.utils.validation.constants.CodedContentValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.ContainedReferenceValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ValidatorPolicyAdvisor
implements IValidationPolicyAdvisor {
    private static final Logger ourLog = LoggerFactory.getLogger(ValidatorPolicyAdvisor.class);
    @Autowired
    private ValidationSettings myValidationSettings;
    @Autowired
    private FhirContext myFhirContext;

    public ReferenceValidationPolicy policyForReference(IResourceValidator validator, Object appContext, String path, String url) {
        int slashIdx = url.indexOf("/");
        if (slashIdx > 0 && this.myFhirContext.getResourceTypes().contains(url.substring(0, slashIdx))) {
            return this.myValidationSettings.getLocalReferenceValidationDefaultPolicy();
        }
        return ReferenceValidationPolicy.IGNORE;
    }

    public CodedContentValidationPolicy policyForCodedContent(IResourceValidator iResourceValidator, Object o, String s, ElementDefinition elementDefinition, StructureDefinition structureDefinition, BindingKind bindingKind, ValueSet valueSet, List<String> list) {
        return CodedContentValidationPolicy.CODE;
    }

    public ContainedReferenceValidationPolicy policyForContained(IResourceValidator validator, Object appContext, String containerType, String containerId, Element.SpecialElement containingResourceType, String path, String url) {
        return ContainedReferenceValidationPolicy.CHECK_VALID;
    }
}

