/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.annotation.PostConstruct;
import org.hl7.fhir.common.hapi.validation.validator.VersionSpecificWorkerContextWrapper;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.JsonParser;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ValidatorResourceFetcher
implements IValidatorResourceFetcher {
    private static final Logger ourLog = LoggerFactory.getLogger(ValidatorResourceFetcher.class);
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private IValidationSupport myValidationSupport;
    private VersionSpecificWorkerContextWrapper myVersionSpecificContextWrapper;

    @PostConstruct
    public void start() {
        this.myVersionSpecificContextWrapper = VersionSpecificWorkerContextWrapper.newVersionSpecificWorkerContextWrapper((IValidationSupport)this.myValidationSupport);
    }

    public Element fetch(IResourceValidator iResourceValidator, Object appContext, String theUrl) throws FHIRFormatError, DefinitionException, FHIRException, IOException {
        Object target;
        IdType id = new IdType(theUrl);
        String resourceType = id.getResourceType();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        try {
            target = dao.read((IIdType)id, (RequestDetails)appContext);
        }
        catch (ResourceNotFoundException e) {
            ourLog.info("Failed to resolve local reference: {}", (Object)theUrl);
            return null;
        }
        try {
            return new JsonParser((IWorkerContext)this.myVersionSpecificContextWrapper).parse(this.myFhirContext.newJsonParser().encodeResourceToString(target), resourceType);
        }
        catch (Exception e) {
            throw new FHIRException(Msg.code((int)576) + e);
        }
    }

    public boolean resolveURL(IResourceValidator iResourceValidator, Object o, String s, String s1, String s2) throws IOException, FHIRException {
        return true;
    }

    public byte[] fetchRaw(IResourceValidator iResourceValidator, String s) throws MalformedURLException, IOException {
        throw new UnsupportedOperationException(Msg.code((int)577));
    }

    public IValidatorResourceFetcher setLocale(Locale locale) {
        return this;
    }

    public CanonicalResource fetchCanonicalResource(IResourceValidator iResourceValidator, String s) throws URISyntaxException {
        return null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator iResourceValidator, String s) {
        return false;
    }
}

