/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.Date;

public class TranslatingUtilities {
    private TranslationServices translator;

    public TranslationServices getTranslator() {
        return this.translator;
    }

    public void setTranslator(TranslationServices translator) {
        this.translator = translator;
    }

    protected String translate(String context, String value) {
        return this.hasTranslator() ? this.translator.translate(context, value) : value;
    }

    protected String translate(String context, String value, Object ... args) {
        return this.hasTranslator() ? this.translator.translate(context, value, args) : String.format(value, args);
    }

    protected boolean hasTranslator() {
        return this.translator != null;
    }

    public String toStr(int value) {
        return this.hasTranslator() ? this.translator.toStr(value) : Integer.toString(value);
    }

    public String toStr(Date value) {
        return this.hasTranslator() ? this.translator.toStr(value) : value.toString();
    }

    public static interface TranslationServices {
        public String translate(String var1, String var2);

        public String translate(String var1, String var2, Object ... var3);

        public String toStr(int var1);

        public String toStr(Date var1);
    }
}

