/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.graphql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.graphql.EGraphEngine;
import org.hl7.fhir.utilities.graphql.EGraphQLException;
import org.hl7.fhir.utilities.graphql.NameValue;
import org.hl7.fhir.utilities.graphql.NumberValue;
import org.hl7.fhir.utilities.graphql.ObjectValue;
import org.hl7.fhir.utilities.graphql.StringValue;
import org.hl7.fhir.utilities.graphql.Value;

public class Argument {
    String name;
    private List<Value> values = new ArrayList<Value>();
    boolean list;

    public Argument() {
    }

    public Argument(String name, Value value) {
        this.name = name;
        this.values.add(value);
    }

    public Argument(String name, JsonElement json) throws EGraphQLException {
        this.name = name;
        this.valuesFromNode(json);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public void addValue(Value value) {
        this.values.add(value);
    }

    public boolean hasValue(String value) {
        for (Value v : this.values) {
            if (!v.isValue(value)) continue;
            return true;
        }
        return false;
    }

    public void valuesFromNode(JsonElement json) throws EGraphQLException {
        if (json instanceof JsonPrimitive && ((JsonPrimitive)json).isString()) {
            this.values.add(new StringValue(((JsonPrimitive)json).getAsString()));
        } else if (json instanceof JsonPrimitive && ((JsonPrimitive)json).isNumber()) {
            this.values.add(new NumberValue(((JsonPrimitive)json).getAsString()));
        } else if (json instanceof JsonPrimitive && ((JsonPrimitive)json).isBoolean()) {
            this.values.add(new NameValue(((JsonPrimitive)json).getAsBoolean()));
        } else if (json instanceof JsonObject) {
            this.values.add(new ObjectValue((JsonObject)json));
        } else if (json instanceof JsonArray) {
            for (JsonElement v : (JsonArray)json) {
                this.valuesFromNode(v);
            }
        } else {
            throw new EGraphQLException("Unexpected JSON type for \"" + this.name + "\": " + json.getClass().getName());
        }
    }

    public void write(StringBuilder b, int indent) throws EGraphQLException, EGraphEngine {
        b.append("\"");
        for (char ch : this.name.toCharArray()) {
            if (ch == '\"') {
                b.append("\"");
                continue;
            }
            if (ch == '\\') {
                b.append("\\");
                continue;
            }
            if (ch == '\r') {
                b.append("\\r");
                continue;
            }
            if (ch == '\n') {
                b.append("\\n");
                continue;
            }
            if (ch == '\t') {
                b.append("\\t");
                continue;
            }
            if (ch < ' ') {
                b.append("\\u" + Integer.toHexString(ch));
                continue;
            }
            b.append(ch);
        }
        b.append("\":");
        if (this.list) {
            b.append("[");
            boolean first = true;
            for (Value v : this.values) {
                if (first) {
                    first = false;
                } else {
                    b.append(",");
                }
                v.write(b, indent);
            }
            b.append("]");
        } else {
            if (this.values.size() > 1) {
                throw new EGraphQLException("Internal error: non list \"" + this.name + "\" has " + Integer.toString(this.values.size()) + " values");
            }
            if (this.values.size() == 0) {
                b.append("null");
            } else {
                this.values.get(0).write(b, indent);
            }
        }
    }
}

