/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.graphql;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.graphql.Argument;
import org.hl7.fhir.utilities.graphql.EGraphEngine;
import org.hl7.fhir.utilities.graphql.EGraphQLException;
import org.hl7.fhir.utilities.graphql.Value;

public class ObjectValue
extends Value {
    private List<Argument> fields = new ArrayList<Argument>();

    public ObjectValue() {
    }

    public ObjectValue(JsonObject json) throws EGraphQLException {
        for (Map.Entry n : json.entrySet()) {
            this.fields.add(new Argument((String)n.getKey(), (JsonElement)n.getValue()));
        }
    }

    public List<Argument> getFields() {
        return this.fields;
    }

    public Argument addField(String name, boolean isList) {
        Argument result = null;
        for (Argument t : this.fields) {
            if (!t.name.equals(name)) continue;
            result = t;
        }
        if (result == null) {
            result = new Argument();
            result.setName(name);
            result.setList(isList);
            this.fields.add(result);
        } else {
            result.list = true;
        }
        return result;
    }

    @Override
    public void write(StringBuilder b, int indent) throws EGraphQLException, EGraphEngine {
        this.write(b, indent, System.lineSeparator());
    }

    @Override
    public String getValue() {
        return null;
    }

    public void write(StringBuilder b, Integer indent, String lineSeparator) throws EGraphQLException, EGraphEngine {
        b.append("{");
        String s = "";
        String se = "";
        if (indent > -1) {
            se = lineSeparator + Utilities.padLeft("", ' ', indent * 2);
            Integer n = indent;
            indent = indent + 1;
            Integer n2 = indent;
            s = lineSeparator + Utilities.padLeft("", ' ', indent * 2);
        }
        boolean first = true;
        for (Argument a : this.fields) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(s);
            a.write(b, indent);
        }
        b.append(se);
        b.append("}");
    }
}

