/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.util.Collections;
import java.util.Comparator;
import org.hl7.fhir.exceptions.UcumException;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.Canonical;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.ExpressionParser;
import org.hl7.fhir.utilities.ucum.Factor;
import org.hl7.fhir.utilities.ucum.Operator;
import org.hl7.fhir.utilities.ucum.Symbol;
import org.hl7.fhir.utilities.ucum.Term;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.special.Registry;

public class Converter {
    private UcumModel model;
    private Registry handlers;

    public Converter(UcumModel model, Registry handlers) {
        this.model = model;
        this.handlers = handlers;
    }

    public Canonical convert(Term term) throws UcumException {
        return this.normalise("  ", term);
    }

    private Canonical normalise(String indent, Term term) throws UcumException {
        Canonical.CanonicalUnit sf;
        int i;
        Canonical result = new Canonical(new Decimal(1));
        this.debug(indent, "canonicalise", term);
        boolean div = false;
        for (Term t = term; t != null; t = t.getTerm()) {
            if (t.getComp() instanceof Term) {
                Canonical temp = this.normalise(indent + "  ", (Term)t.getComp());
                if (div) {
                    result.divideValue(temp.getValue());
                    for (Canonical.CanonicalUnit canonicalUnit : temp.getUnits()) {
                        canonicalUnit.setExponent(0 - canonicalUnit.getExponent());
                    }
                } else {
                    result.multiplyValue(temp.getValue());
                }
                result.getUnits().addAll(temp.getUnits());
            } else if (t.getComp() instanceof Factor) {
                if (div) {
                    result.divideValue(((Factor)t.getComp()).getValue());
                } else {
                    result.multiplyValue(((Factor)t.getComp()).getValue());
                }
            } else if (t.getComp() instanceof Symbol) {
                Symbol o = (Symbol)t.getComp();
                Canonical temp = this.normalise(indent, o);
                if (div) {
                    result.divideValue(temp.getValue());
                    for (Canonical.CanonicalUnit c2 : temp.getUnits()) {
                        c2.setExponent(0 - c2.getExponent());
                    }
                } else {
                    result.multiplyValue(temp.getValue());
                }
                result.getUnits().addAll(temp.getUnits());
            }
            div = t.getOp() == Operator.DIVISION;
        }
        this.debug(indent, "collate", result);
        block3: for (i = result.getUnits().size() - 1; i >= 0; --i) {
            sf = result.getUnits().get(i);
            for (int j = i - 1; j >= 0; --j) {
                Canonical.CanonicalUnit st = result.getUnits().get(j);
                if (st.getBase() != sf.getBase()) continue;
                st.setExponent(sf.getExponent() + st.getExponent());
                result.getUnits().remove(i);
                continue block3;
            }
        }
        for (i = result.getUnits().size() - 1; i >= 0; --i) {
            sf = result.getUnits().get(i);
            if (sf.getExponent() != 0) continue;
            result.getUnits().remove(i);
        }
        this.debug(indent, "sort", result);
        Collections.sort(result.getUnits(), new Comparator<Canonical.CanonicalUnit>(){

            @Override
            public int compare(Canonical.CanonicalUnit lhs, Canonical.CanonicalUnit rhs) {
                return lhs.getBase().getCode().compareTo(rhs.getBase().getCode());
            }
        });
        this.debug(indent, "done", result);
        return result;
    }

    private Canonical normalise(String indent, Symbol sym) throws UcumException {
        Canonical result;
        block11: {
            result = new Canonical(new Decimal(1));
            if (sym.getUnit() instanceof BaseUnit) {
                result.getUnits().add(new Canonical.CanonicalUnit((BaseUnit)sym.getUnit(), sym.getExponent()));
            } else {
                int i;
                Canonical can = this.expandDefinedUnit(indent, (DefinedUnit)sym.getUnit());
                for (Canonical.CanonicalUnit c : can.getUnits()) {
                    c.setExponent(c.getExponent() * sym.getExponent());
                }
                result.getUnits().addAll(can.getUnits());
                if (sym.getExponent() > 0) {
                    for (i = 0; i < sym.getExponent(); ++i) {
                        result.multiplyValue(can.getValue());
                    }
                } else {
                    for (i = 0; i > sym.getExponent(); --i) {
                        result.divideValue(can.getValue());
                    }
                }
            }
            if (sym.getPrefix() == null) break block11;
            if (sym.getExponent() > 0) {
                for (int i = 0; i < sym.getExponent(); ++i) {
                    result.multiplyValue(sym.getPrefix().getValue());
                }
            } else {
                for (int i = 0; i > sym.getExponent(); --i) {
                    result.divideValue(sym.getPrefix().getValue());
                }
            }
        }
        return result;
    }

    private Canonical expandDefinedUnit(String indent, DefinedUnit unit) throws UcumException {
        String u = unit.getValue().getUnit();
        if (unit.isSpecial()) {
            if (!this.handlers.exists(unit.getCode())) {
                throw new UcumException("Not handled yet (special unit)");
            }
            u = this.handlers.get(unit.getCode()).getUnits();
        }
        Term t = new ExpressionParser(this.model).parse(u);
        this.debug(indent, "now handle", t);
        Canonical result = this.normalise(indent + "  ", t);
        result.multiplyValue(unit.getValue().getValue());
        return result;
    }

    private void debug(String indent, String state, Term unit) {
    }

    private void debug(String indent, String state, Canonical can) {
    }
}

