/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import com.github.rjeschke.txtmark.Processor;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class MarkDownProcessor {
    private Dialect dialect;

    public MarkDownProcessor(Dialect dialect) {
        this.dialect = dialect;
    }

    public String process(String source, String context) {
        switch (this.dialect) {
            case DARING_FIREBALL: {
                return Processor.process((String)source);
            }
            case COMMON_MARK: {
                return this.processCommonMark(source);
            }
        }
        throw new Error("Unknown Markdown Dialect: " + this.dialect.toString() + " at " + context);
    }

    private String processCommonMark(String source) {
        Parser parser = Parser.builder().build();
        Node document = parser.parse(source);
        HtmlRenderer renderer = HtmlRenderer.builder().build();
        return renderer.render(document);
    }

    public static enum Dialect {
        DARING_FIREBALL,
        COMMON_MARK;

    }
}

